/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.array;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.DirectArray;
import io.questdb.cairo.sql.ArrayFunction;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.array.DoubleArrayShiftFunctionFactory;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public class DoubleArrayShiftDefaultNaNFunctionFactory
implements FunctionFactory {
    private static final String FUNCTION_NAME = "shift";

    @Override
    public String getSignature() {
        return "shift(D[]I)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        return new Func(args.getQuick(0), args.getQuick(1), configuration);
    }

    private static class Func
    extends ArrayFunction
    implements BinaryFunction {
        private final DirectArray array;
        private final Function arrayArg;
        private final Function shiftFunction;

        public Func(Function arrayArg, Function shiftFunction, CairoConfiguration configuration) {
            this.arrayArg = arrayArg;
            this.shiftFunction = shiftFunction;
            this.type = arrayArg.getType();
            this.array = new DirectArray(configuration);
        }

        @Override
        public void close() {
            BinaryFunction.super.close();
            Misc.free(this.array);
        }

        @Override
        public ArrayView getArray(Record rec) {
            ArrayView arr = this.arrayArg.getArray(rec);
            if (arr.isNull()) {
                this.array.ofNull();
                return this.array;
            }
            int offset = this.shiftFunction.getInt(rec);
            if (offset == 0) {
                return arr;
            }
            MemoryA memory = this.array.copyShapeAndStartMemoryA(arr);
            if (arr.isVanilla()) {
                DoubleArrayShiftFunctionFactory.applyToEntireVanillaArray(arr, memory, offset, Double.NaN);
            } else {
                DoubleArrayShiftFunctionFactory.applyRecursive(arr, 0, 0, offset, memory, Double.NaN);
            }
            return this.array;
        }

        @Override
        public Function getLeft() {
            return this.arrayArg;
        }

        @Override
        public String getName() {
            return DoubleArrayShiftDefaultNaNFunctionFactory.FUNCTION_NAME;
        }

        @Override
        public Function getRight() {
            return this.shiftFunction;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }
    }
}

