/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions;

import io.questdb.cairo.TableUtils;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.griffin.SqlUtil;
import io.questdb.std.BinarySequence;
import io.questdb.std.Interval;
import io.questdb.std.Long256;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8s;
import org.jetbrains.annotations.NotNull;

public abstract class VarcharFunction
implements Function {
    private final StringSink utf16SinkA = new StringSink();
    private final StringSink utf16SinkB = new StringSink();

    @Override
    public ArrayView getArray(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final BinarySequence getBin(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getBinLen(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean getBool(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final byte getByte(Record rec) {
        return SqlUtil.implicitCastVarcharAsByte(this.getVarcharA(rec));
    }

    @Override
    public char getChar(Record rec) {
        return SqlUtil.implicitCastVarcharAsChar(this.getVarcharA(rec));
    }

    @Override
    public long getDate(Record rec) {
        return SqlUtil.implicitCastStrAsDate(this.getStrA(rec));
    }

    @Override
    public double getDouble(Record rec) {
        return SqlUtil.implicitCastVarcharAsDouble(this.getVarcharA(rec));
    }

    @Override
    public float getFloat(Record rec) {
        return SqlUtil.implicitCastVarcharAsFloat(this.getVarcharA(rec));
    }

    @Override
    public byte getGeoByte(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getGeoInt(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getGeoLong(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getGeoShort(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int getIPv4(Record rec) {
        Utf8Sequence value = this.getVarcharA(rec);
        return SqlUtil.implicitCastStrAsIPv4(value != null ? value.asAsciiCharSequence() : null);
    }

    @Override
    public int getInt(Record rec) {
        return SqlUtil.implicitCastVarcharAsInt(this.getVarcharA(rec));
    }

    @Override
    @NotNull
    public Interval getInterval(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(Record rec) {
        return SqlUtil.implicitCastVarcharAsLong(this.getVarcharA(rec));
    }

    @Override
    public long getLong128Hi(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong128Lo(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getLong256(Record rec, CharSink<?> sink) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long256 getLong256A(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long256 getLong256B(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RecordCursorFactory getRecordCursorFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final short getShort(Record rec) {
        return SqlUtil.implicitCastVarcharAsShort(this.getVarcharA(rec));
    }

    @Override
    public CharSequence getStrA(Record rec) {
        Utf8Sequence utf8seq = this.getVarcharA(rec);
        if (utf8seq == null) {
            return null;
        }
        if (utf8seq.isAscii()) {
            return utf8seq.asAsciiCharSequence();
        }
        this.utf16SinkA.clear();
        Utf8s.utf8ToUtf16(utf8seq, this.utf16SinkA);
        return this.utf16SinkA;
    }

    @Override
    public CharSequence getStrB(Record rec) {
        Utf8Sequence utf8seq = this.getVarcharB(rec);
        if (utf8seq == null) {
            return null;
        }
        if (utf8seq.isAscii()) {
            return utf8seq.asAsciiCharSequence();
        }
        this.utf16SinkB.clear();
        Utf8s.utf8ToUtf16(utf8seq, this.utf16SinkB);
        return this.utf16SinkB;
    }

    @Override
    public int getStrLen(Record rec) {
        return TableUtils.lengthOf(this.getStrA(rec));
    }

    @Override
    public final CharSequence getSymbol(Record rec) {
        return this.getStrA(rec);
    }

    @Override
    public final CharSequence getSymbolB(Record rec) {
        return this.getStrB(rec);
    }

    @Override
    public final long getTimestamp(Record rec) {
        return SqlUtil.implicitCastVarcharAsTimestamp(this.getStrA(rec));
    }

    @Override
    public final int getType() {
        return 26;
    }

    @Override
    public int getVarcharSize(Record rec) {
        Utf8Sequence utf8seq = this.getVarcharA(rec);
        if (utf8seq == null) {
            return -1;
        }
        return utf8seq.size();
    }
}

