/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions;

import io.questdb.cairo.TableUtils;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.griffin.SqlUtil;
import io.questdb.std.BinarySequence;
import io.questdb.std.Interval;
import io.questdb.std.Long256;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8StringSink;
import org.jetbrains.annotations.NotNull;

public abstract class StrFunction
implements Function {
    private final Utf8StringSink utf8SinkA = new Utf8StringSink();
    private final Utf8StringSink utf8SinkB = new Utf8StringSink();

    @Override
    public ArrayView getArray(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final BinarySequence getBin(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getBinLen(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean getBool(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final byte getByte(Record rec) {
        return SqlUtil.implicitCastStrAsByte(this.getStrA(rec));
    }

    @Override
    public final char getChar(Record rec) {
        return SqlUtil.implicitCastStrAsChar(this.getStrA(rec));
    }

    @Override
    public final long getDate(Record rec) {
        return SqlUtil.implicitCastStrAsDate(this.getStrA(rec));
    }

    @Override
    public final double getDouble(Record rec) {
        return SqlUtil.implicitCastStrAsDouble(this.getStrA(rec));
    }

    @Override
    public final float getFloat(Record rec) {
        return SqlUtil.implicitCastStrAsFloat(this.getStrA(rec));
    }

    @Override
    public byte getGeoByte(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getGeoInt(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getGeoLong(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getGeoShort(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int getIPv4(Record rec) {
        return SqlUtil.implicitCastStrAsIPv4(this.getStrA(rec));
    }

    @Override
    public final int getInt(Record rec) {
        return SqlUtil.implicitCastStrAsInt(this.getStrA(rec));
    }

    @Override
    @NotNull
    public Interval getInterval(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final long getLong(Record rec) {
        return SqlUtil.implicitCastStrAsLong(this.getStrA(rec));
    }

    @Override
    public long getLong128Hi(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong128Lo(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void getLong256(Record rec, CharSink<?> sink) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Long256 getLong256A(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Long256 getLong256B(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final RecordCursorFactory getRecordCursorFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final short getShort(Record rec) {
        return SqlUtil.implicitCastStrAsShort(this.getStrA(rec));
    }

    @Override
    public int getStrLen(Record rec) {
        return TableUtils.lengthOf(this.getStrA(rec));
    }

    @Override
    public final CharSequence getSymbol(Record rec) {
        return this.getStrA(rec);
    }

    @Override
    public final CharSequence getSymbolB(Record rec) {
        return this.getStrB(rec);
    }

    @Override
    public final long getTimestamp(Record rec) {
        return SqlUtil.implicitCastStrAsTimestamp(this.getStrA(rec));
    }

    @Override
    public final int getType() {
        return 11;
    }

    @Override
    public Utf8Sequence getVarcharA(Record rec) {
        CharSequence cs = this.getStrA(rec);
        if (cs != null) {
            this.utf8SinkA.clear();
            this.utf8SinkA.put(cs);
            return this.utf8SinkA;
        }
        return null;
    }

    @Override
    public Utf8Sequence getVarcharB(Record rec) {
        CharSequence cs = this.getStrB(rec);
        if (cs != null) {
            this.utf8SinkB.clear();
            this.utf8SinkB.put(cs);
            return this.utf8SinkB;
        }
        return null;
    }

    @Override
    public int getVarcharSize(Record rec) {
        CharSequence utf16Value = this.getStrA(rec);
        if (utf16Value == null) {
            return -1;
        }
        this.utf8SinkA.clear();
        this.utf8SinkA.put(utf16Value);
        return this.utf8SinkA.size();
    }
}

