/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.arr.BorrowedArray;
import io.questdb.cutlass.line.tcp.LineTcpParser;
import io.questdb.std.QuietCloseable;
import io.questdb.std.ThreadLocal;
import io.questdb.std.Unsafe;
import org.jetbrains.annotations.NotNull;

public class ArrayBinaryFormatParser
implements QuietCloseable {
    private final BorrowedArray array = new BorrowedArray();
    private short elemType;
    private int nDims;
    private int nextBinaryPartExpectSize = 1;
    private long shapeAddr;
    private ParserState state;

    @Override
    public void close() {
        this.nextBinaryPartExpectSize = 1;
        this.state = ParserState.ELEMENT_TYPE;
    }

    @NotNull
    public BorrowedArray getArray() {
        assert (this.state == ParserState.FINISH);
        return this.array;
    }

    public int getNextExpectSize() {
        return this.nextBinaryPartExpectSize;
    }

    public boolean processNextBinaryPart(long addr) throws ParseException {
        switch (this.state) {
            case ELEMENT_TYPE: {
                this.elemType = Unsafe.getUnsafe().getByte(addr);
                if (this.elemType == 33) {
                    this.array.ofNull();
                    this.state = ParserState.FINISH;
                    return true;
                }
                if (!ColumnType.isSupportedArrayElementType(this.elemType)) {
                    throw ParseException.invalidType();
                }
                this.state = ParserState.N_DIMS;
                this.nextBinaryPartExpectSize = 1;
                return false;
            }
            case N_DIMS: {
                this.nDims = Unsafe.getUnsafe().getByte(addr);
                if (this.nDims > 32) {
                    throw ParseException.tooManyDims();
                }
                if (this.nDims == 0) {
                    this.array.ofNull();
                    this.state = ParserState.FINISH;
                    return true;
                }
                this.state = ParserState.SHAPE;
                this.nextBinaryPartExpectSize = this.nDims * 4;
                return false;
            }
            case SHAPE: {
                int dimLength;
                long i;
                this.shapeAddr = addr;
                int n = this.nDims;
                for (i = 0L; i < (long)n; ++i) {
                    dimLength = Unsafe.getUnsafe().getInt(addr + i * 4L);
                    if (dimLength != 0) continue;
                    int type = ColumnType.encodeArrayType(this.elemType, this.nDims);
                    this.array.of(type, this.shapeAddr, 0L, 0);
                    this.state = ParserState.FINISH;
                    return true;
                }
                this.nextBinaryPartExpectSize = ColumnType.sizeOf(this.elemType);
                for (i = 0L; i < (long)n; ++i) {
                    dimLength = Unsafe.getUnsafe().getInt(addr + i * 4L);
                    try {
                        this.nextBinaryPartExpectSize = Math.multiplyExact(this.nextBinaryPartExpectSize, dimLength);
                        continue;
                    }
                    catch (ArithmeticException e) {
                        throw ParseException.tooLarge();
                    }
                }
                this.state = ParserState.VALUES;
                return false;
            }
            case VALUES: {
                int type = ColumnType.encodeArrayType(this.elemType, this.nDims);
                this.array.of(type, this.shapeAddr, addr, this.nextBinaryPartExpectSize);
                this.state = ParserState.FINISH;
                return true;
            }
        }
        throw ParseException.invalidType();
    }

    public void reset() {
        this.nextBinaryPartExpectSize = 1;
        this.state = ParserState.ELEMENT_TYPE;
        this.array.clear();
    }

    public void shl(long delta) {
        if (this.state == ParserState.FINISH && !this.array.isNull()) {
            this.array.borrowedFlatView().shl(delta);
        } else if (this.state == ParserState.VALUES) {
            this.shapeAddr -= delta;
        }
    }

    private static enum ParserState {
        ELEMENT_TYPE,
        N_DIMS,
        SHAPE,
        VALUES,
        FINISH;

    }

    public static class ParseException
    extends Exception {
        private static final ThreadLocal<ParseException> tlException = new ThreadLocal<ParseException>(ParseException::new);
        private LineTcpParser.ErrorCode errorCode;

        @NotNull
        public static ParseException invalidType() {
            return tlException.get().errorCode(LineTcpParser.ErrorCode.ARRAY_INVALID_TYPE);
        }

        @NotNull
        public static ParseException tooLarge() {
            return tlException.get().errorCode(LineTcpParser.ErrorCode.ARRAY_TOO_LARGE);
        }

        @NotNull
        public static ParseException tooManyDims() {
            return tlException.get().errorCode(LineTcpParser.ErrorCode.ARRAY_TOO_MANY_DIMENSIONS);
        }

        public ParseException errorCode(LineTcpParser.ErrorCode errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public LineTcpParser.ErrorCode errorCode() {
            return this.errorCode;
        }
    }
}

