/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.Metrics;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoError;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.EntryUnavailableException;
import io.questdb.cairo.ImplicitCastException;
import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.sql.InsertOperation;
import io.questdb.cairo.sql.NetworkSqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.OperationFuture;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.cutlass.http.HttpChunkedResponse;
import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpConstants;
import io.questdb.cutlass.http.HttpException;
import io.questdb.cutlass.http.HttpRequestHandler;
import io.questdb.cutlass.http.HttpRequestHeader;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.cutlass.http.LocalValue;
import io.questdb.cutlass.http.ex.RetryOperationException;
import io.questdb.cutlass.http.processors.JsonQueryProcessorConfiguration;
import io.questdb.cutlass.http.processors.JsonQueryProcessorState;
import io.questdb.cutlass.text.Utf8Exception;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContextImpl;
import io.questdb.griffin.SqlTimeoutException;
import io.questdb.griffin.engine.ops.Operation;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.NoSpaceLeftInResponseBufferException;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.network.QueryPausedException;
import io.questdb.std.Chars;
import io.questdb.std.FlyweightMessageContainer;
import io.questdb.std.Misc;
import io.questdb.std.NanosecondClock;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.Path;
import io.questdb.std.str.Utf8Sink;
import java.io.Closeable;

public class JsonQueryProcessor
implements HttpRequestProcessor,
HttpRequestHandler,
Closeable {
    private static final Log LOG = LogFactory.getLog(JsonQueryProcessor.class);
    private static final LocalValue<JsonQueryProcessorState> LV = new LocalValue();
    protected final ObjList<QueryExecutor> queryExecutors = new ObjList();
    private final long asyncCommandTimeout;
    private final long asyncWriterStartTimeout;
    private final NetworkSqlExecutionCircuitBreaker circuitBreaker;
    private final JsonQueryProcessorConfiguration configuration;
    private final CairoEngine engine;
    private final int maxSqlRecompileAttempts;
    private final Metrics metrics;
    private final NanosecondClock nanosecondClock;
    private final Path path;
    private final byte requiredAuthType;
    private final SqlExecutionContextImpl sqlExecutionContext;

    public JsonQueryProcessor(JsonQueryProcessorConfiguration configuration, CairoEngine engine, int sharedQueryWorkerCount) {
        this(configuration, engine, new SqlExecutionContextImpl(engine, sharedQueryWorkerCount));
    }

    public JsonQueryProcessor(JsonQueryProcessorConfiguration configuration, CairoEngine engine, SqlExecutionContextImpl sqlExecutionContext) {
        try {
            this.configuration = configuration;
            this.path = new Path();
            this.engine = engine;
            this.requiredAuthType = configuration.getRequiredAuthType();
            QueryExecutor sendConfirmation = this::updateMetricsAndSendConfirmation;
            this.queryExecutors.extendAndSet(1, this::executeNewSelect);
            this.queryExecutors.extendAndSet(2, this::executeInsert);
            this.queryExecutors.extendAndSet(3, sendConfirmation);
            this.queryExecutors.extendAndSet(4, this::executeAlterTable);
            this.queryExecutors.extendAndSet(6, sendConfirmation);
            this.queryExecutors.extendAndSet(7, this::executeDdl);
            this.queryExecutors.extendAndSet(8, this::executePseudoSelect);
            this.queryExecutors.extendAndSet(9, this::executeDdl);
            this.queryExecutors.extendAndSet(10, this::executeInsert);
            this.queryExecutors.extendAndSet(11, JsonQueryProcessor::cannotCopyRemote);
            this.queryExecutors.extendAndSet(12, sendConfirmation);
            this.queryExecutors.extendAndSet(5, sendConfirmation);
            this.queryExecutors.extendAndSet(13, sendConfirmation);
            this.queryExecutors.extendAndSet(14, this::executeUpdate);
            this.queryExecutors.extendAndSet(17, sendConfirmation);
            this.queryExecutors.extendAndSet(18, sendConfirmation);
            this.queryExecutors.extendAndSet(19, sendConfirmation);
            this.queryExecutors.extendAndSet(20, sendConfirmation);
            this.queryExecutors.extendAndSet(21, this::executeDdl);
            this.queryExecutors.extendAndSet(22, sendConfirmation);
            this.queryExecutors.extendAndSet(23, sendConfirmation);
            this.queryExecutors.extendAndSet(24, sendConfirmation);
            this.queryExecutors.extendAndSet(25, this::executeExplain);
            this.queryExecutors.extendAndSet(26, sendConfirmation);
            this.queryExecutors.extendAndSet(31, sendConfirmation);
            this.queryExecutors.extendAndSet(27, sendConfirmation);
            this.queryExecutors.extendAndSet(28, sendConfirmation);
            this.queryExecutors.extendAndSet(29, sendConfirmation);
            this.queryExecutors.extendAndSet(30, sendConfirmation);
            this.queryExecutors.extendAndSet(34, JsonQueryProcessor::sendEmptyQueryNotice);
            this.queryExecutors.extendAndSet(32, this::executeDdl);
            this.queryExecutors.extendAndSet(33, sendConfirmation);
            assert (this.queryExecutors.size() == 35);
            this.sqlExecutionContext = sqlExecutionContext;
            this.nanosecondClock = configuration.getNanosecondClock();
            this.maxSqlRecompileAttempts = engine.getConfiguration().getMaxSqlRecompileAttempts();
            this.circuitBreaker = new NetworkSqlExecutionCircuitBreaker(engine.getConfiguration().getCircuitBreakerConfiguration(), 21);
            this.metrics = engine.getMetrics();
            this.asyncWriterStartTimeout = engine.getConfiguration().getWriterAsyncCommandBusyWaitTimeout();
            this.asyncCommandTimeout = engine.getConfiguration().getWriterAsyncCommandMaxTimeout();
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public void close() {
        Misc.free(this.path);
        Misc.free(this.circuitBreaker);
    }

    public void execute0(JsonQueryProcessorState state) throws PeerDisconnectedException, PeerIsSlowToReadException, QueryPausedException {
        OperationFuture fut = state.getOperationFuture();
        HttpConnectionContext context = state.getHttpConnectionContext();
        this.circuitBreaker.resetTimer();
        if (fut == null) {
            this.metrics.jsonQueryMetrics().markStart();
            state.startExecutionTimer();
            this.sqlExecutionContext.with(context.getSecurityContext(), null, null, context.getFd(), this.circuitBreaker.of(context.getFd()));
            this.sqlExecutionContext.initNow();
            if (state.getStatementTimeout() > 0L) {
                this.circuitBreaker.setTimeout(state.getStatementTimeout());
            } else {
                this.circuitBreaker.resetMaxTimeToDefault();
            }
        }
        try {
            if (fut != null) {
                this.retryQueryExecution(state, fut);
                return;
            }
            RecordCursorFactory factory = context.getSelectCache().poll(state.getQuery());
            if (factory != null) {
                try {
                    this.sqlExecutionContext.storeTelemetry((short)1, (short)2);
                    this.executeCachedSelect(state, factory);
                }
                catch (TableReferenceOutOfDateException e) {
                    LOG.info().$safe(e.getFlyweightMessage()).$();
                    this.compileAndExecuteQuery(state);
                }
            } else {
                this.compileAndExecuteQuery(state);
            }
        }
        catch (ImplicitCastException | SqlException e) {
            JsonQueryProcessor.sqlError(context.getChunkedResponse(), state, (FlyweightMessageContainer)((Object)e), this.configuration.getKeepAliveHeader());
            state.setQueryCacheable(false);
            JsonQueryProcessor.readyForNextRequest(context);
        }
        catch (EntryUnavailableException e) {
            LOG.info().$("[fd=").$(context.getFd()).$("] resource busy, will retry").$();
            throw RetryOperationException.INSTANCE;
        }
        catch (DataUnavailableException e) {
            LOG.info().$("[fd=").$(context.getFd()).$("] data is in cold storage, will retry").$();
            throw QueryPausedException.instance(e.getEvent(), this.sqlExecutionContext.getCircuitBreaker());
        }
        catch (CairoException e) {
            this.internalError(context.getChunkedResponse(), context.getLastRequestBytesSent(), e.getFlyweightMessage(), JsonQueryProcessor.getStatusCode(e), e, state, context.getMetrics());
            JsonQueryProcessor.readyForNextRequest(context);
        }
        catch (PeerDisconnectedException | PeerIsSlowToReadException | QueryPausedException e) {
            throw e;
        }
        catch (Throwable e) {
            this.internalError(context.getChunkedResponse(), context.getLastRequestBytesSent(), e.getMessage(), 500, e, state, context.getMetrics());
            JsonQueryProcessor.readyForNextRequest(context);
        }
    }

    @Override
    public void failRequest(HttpConnectionContext context, HttpException e) throws PeerDisconnectedException, PeerIsSlowToReadException {
        JsonQueryProcessorState state = LV.get(context);
        HttpChunkedResponse response = context.getChunkedResponse();
        JsonQueryProcessor.logInternalError(e, state, this.metrics);
        JsonQueryProcessor.sendException(response, context, 0, e.getFlyweightMessage(), state.getQuery(), this.configuration.getKeepAliveHeader(), 400);
        response.shutdownWrite();
    }

    @Override
    public HttpRequestProcessor getProcessor(HttpRequestHeader requestHeader) {
        return this;
    }

    @Override
    public byte getRequiredAuthType() {
        return this.requiredAuthType;
    }

    @Override
    public void onRequestComplete(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, QueryPausedException {
        JsonQueryProcessorState state = LV.get(context);
        if (state == null) {
            state = new JsonQueryProcessorState(context, this.nanosecondClock, this.configuration.getKeepAliveHeader());
            LV.set(context, state);
        }
        state.setRnd(null);
        if (this.parseUrl(state, this.configuration.getKeepAliveHeader())) {
            this.execute0(state);
        } else {
            JsonQueryProcessor.readyForNextRequest(context);
        }
    }

    @Override
    public void onRequestRetry(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, QueryPausedException {
        JsonQueryProcessorState state = LV.get(context);
        this.execute0(state);
    }

    @Override
    public void parkRequest(HttpConnectionContext context, boolean pausedQuery) {
        JsonQueryProcessorState state = LV.get(context);
        if (state != null) {
            state.setPausedQuery(pausedQuery);
            state.setRnd(this.sqlExecutionContext.getRandom());
        }
    }

    @Override
    public boolean processCookies(HttpConnectionContext context, SecurityContext securityContext) {
        return context.getCookieHandler().processCookies(context, securityContext);
    }

    @Override
    public void resumeSend(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, QueryPausedException {
        JsonQueryProcessorState state = LV.get(context);
        if (state != null) {
            this.sqlExecutionContext.with(context.getSecurityContext(), null, state.getRnd(), context.getFd(), this.circuitBreaker.of(context.getFd()));
            if (!state.isPausedQuery()) {
                context.resumeResponseSend();
            } else {
                state.setPausedQuery(false);
            }
            try {
                this.doResumeSend(state, context);
            }
            catch (CairoError e) {
                this.internalError(context.getChunkedResponse(), context.getLastRequestBytesSent(), e.getFlyweightMessage(), 500, e, state, context.getMetrics());
            }
            catch (CairoException e) {
                this.internalError(context.getChunkedResponse(), context.getLastRequestBytesSent(), e.getFlyweightMessage(), 400, e, state, context.getMetrics());
            }
        }
    }

    private static void cannotCopyRemote(JsonQueryProcessorState state, CompiledQuery cc, CharSequence keepAliveHeader) throws SqlException {
        throw SqlException.$(0, "copy from STDIN is not supported over REST");
    }

    private static int getStatusCode(CairoException e) {
        if (e.isAuthorizationError()) {
            return 403;
        }
        return 400;
    }

    private static void logInternalError(Throwable e, JsonQueryProcessorState state, Metrics metrics) {
        if (e instanceof CairoException) {
            CairoException ce = (CairoException)e;
            if (ce.isInterruption()) {
                state.info().$("query cancelled [reason=`").$safe(((CairoException)e).getFlyweightMessage()).$("`, q=`").$safe(state.getQueryOrHidden()).$("`]").$();
            } else if (ce.isCritical()) {
                state.critical().$("error [msg=`").$safe(ce.getFlyweightMessage()).$("`, errno=").$(ce.getErrno()).$(", q=`").$safe(state.getQueryOrHidden()).$("`]").$();
            } else {
                state.error().$("error [msg=`").$safe(ce.getFlyweightMessage()).$("`, errno=").$(ce.getErrno()).$(", q=`").$safe(state.getQueryOrHidden()).$("`]").$();
            }
        } else if (e instanceof HttpException) {
            state.error().$("internal HTTP server error [reason=`").$safe(((HttpException)e).getFlyweightMessage()).$("`, q=`").$safe(state.getQueryOrHidden()).$("`]").$();
        } else {
            state.critical().$("internal error [ex=").$(e).$(", q=`").$safe(state.getQueryOrHidden()).$("`]").$();
            metrics.healthMetrics().incrementUnhandledErrors();
        }
    }

    private static void readyForNextRequest(HttpConnectionContext context) {
        LOG.debug().$("all sent [fd=").$(context.getFd()).$(", lastRequestBytesSent=").$(context.getLastRequestBytesSent()).$(", nCompletedRequests=").$(context.getNCompletedRequests() + 1).$(", totalBytesSent=").$(context.getTotalBytesSent()).I$();
    }

    private static void sendConfirmation(JsonQueryProcessorState state, CharSequence keepAliveHeader) throws PeerDisconnectedException, PeerIsSlowToReadException {
        HttpConnectionContext context = state.getHttpConnectionContext();
        HttpChunkedResponse response = context.getChunkedResponse();
        JsonQueryProcessor.header(response, context, keepAliveHeader, 200);
        ((Utf8Sink)((Utf8Sink)response.put('{').putAsciiQuoted("ddl")).putAscii(':').putAsciiQuoted("OK")).putAscii('}');
        response.sendChunk(true);
        JsonQueryProcessor.readyForNextRequest(context);
    }

    private static void sendEmptyQueryNotice(JsonQueryProcessorState state, CompiledQuery cc, CharSequence keepAliveHeader) throws PeerDisconnectedException, PeerIsSlowToReadException {
        HttpConnectionContext context = state.getHttpConnectionContext();
        HttpChunkedResponse response = context.getChunkedResponse();
        JsonQueryProcessor.header(response, context, keepAliveHeader, 200);
        String noticeOrError = state.getApiVersion() >= 2 ? "notice" : "error";
        ((Utf8Sink)((Utf8Sink)((Utf8Sink)((Utf8Sink)((Utf8Sink)response.put('{').putAsciiQuoted(noticeOrError)).putAscii(':').putAsciiQuoted("empty query")).putAscii(",").putAsciiQuoted("query")).putAscii(':').putQuote().escapeJsonStr(state.getQuery()).putQuote().putAscii(",").putAsciiQuoted("position")).putAscii(':').putAsciiQuoted("0")).putAscii('}');
        response.sendChunk(true);
        JsonQueryProcessor.readyForNextRequest(context);
    }

    private static void sendInsertConfirmation(JsonQueryProcessorState state, CharSequence keepAliveHeader) throws PeerDisconnectedException, PeerIsSlowToReadException {
        HttpConnectionContext context = state.getHttpConnectionContext();
        HttpChunkedResponse response = context.getChunkedResponse();
        JsonQueryProcessor.header(response, context, keepAliveHeader, 200);
        ((Utf8Sink)((Utf8Sink)response.put('{').putAsciiQuoted("dml")).putAscii(':').putAsciiQuoted("OK")).put('}');
        response.sendChunk(true);
        JsonQueryProcessor.readyForNextRequest(context);
    }

    private static void sendUpdateConfirmation(JsonQueryProcessorState state, CharSequence keepAliveHeader, long updateRecords) throws PeerDisconnectedException, PeerIsSlowToReadException {
        HttpConnectionContext context = state.getHttpConnectionContext();
        HttpChunkedResponse response = context.getChunkedResponse();
        JsonQueryProcessor.header(response, context, keepAliveHeader, 200);
        ((Utf8Sink)((Utf8Sink)((Utf8Sink)((Utf8Sink)response.put('{').putAsciiQuoted("dml")).putAscii(':').putAsciiQuoted("OK")).putAscii(',').putAsciiQuoted("updated")).putAscii(':').put(updateRecords)).put('}');
        response.sendChunk(true);
        JsonQueryProcessor.readyForNextRequest(context);
    }

    private static void sqlError(HttpChunkedResponse response, JsonQueryProcessorState state, FlyweightMessageContainer container, CharSequence keepAliveHeader) throws PeerDisconnectedException, PeerIsSlowToReadException {
        JsonQueryProcessor.sendException(response, state.getHttpConnectionContext(), container.getPosition(), container.getFlyweightMessage(), state.getQuery(), keepAliveHeader, 400);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileAndExecuteQuery(JsonQueryProcessorState state) throws PeerDisconnectedException, PeerIsSlowToReadException, QueryPausedException, SqlException {
        try (SqlCompiler compiler = this.engine.getSqlCompiler();){
            int retries = 0;
            while (true) {
                long compilationStart = this.nanosecondClock.getTicks();
                CompiledQuery cc = compiler.compile(state.getQuery(), this.sqlExecutionContext);
                this.sqlExecutionContext.storeTelemetry(cc.getType(), (short)2);
                state.setCompilerNanos(this.nanosecondClock.getTicks() - compilationStart);
                state.setQueryType(cc.getType());
                try {
                    this.queryExecutors.getQuick(cc.getType()).execute(state, cc, this.configuration.getKeepAliveHeader());
                }
                catch (TableReferenceOutOfDateException e) {
                    if (retries == this.maxSqlRecompileAttempts) {
                        throw SqlException.$(0, e.getFlyweightMessage());
                    }
                    LOG.info().$safe(e.getFlyweightMessage()).$();
                    ++retries;
                    continue;
                }
                break;
            }
        }
        finally {
            state.setContainsSecret(this.sqlExecutionContext.containsSecret());
        }
    }

    private void doResumeSend(JsonQueryProcessorState state, HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, QueryPausedException {
        LOG.debug().$("resume [fd=").$(context.getFd()).I$();
        HttpChunkedResponse response = context.getChunkedResponse();
        while (true) {
            try {
                state.resume(response);
            }
            catch (ImplicitCastException | SqlException e) {
                JsonQueryProcessor.sqlError(context.getChunkedResponse(), state, (FlyweightMessageContainer)((Object)e), this.configuration.getKeepAliveHeader());
                state.setQueryCacheable(false);
            }
            catch (DataUnavailableException e) {
                response.resetToBookmark();
                throw QueryPausedException.instance(e.getEvent(), this.sqlExecutionContext.getCircuitBreaker());
            }
            catch (NoSpaceLeftInResponseBufferException ignored) {
                if (response.resetToBookmark()) {
                    response.sendChunk(false);
                    continue;
                }
                state.logBufferTooSmall();
                throw CairoException.nonCritical().put("response buffer is too small for the column value [columnName=").put(state.getCurrentColumnName()).put(", columnIndex=").put(state.getCurrentColumnIndex()).put(']');
            }
            break;
        }
        JsonQueryProcessor.readyForNextRequest(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAlterTable(JsonQueryProcessorState state, CompiledQuery cq, CharSequence keepAliveHeader) throws PeerIsSlowToReadException, PeerDisconnectedException, SqlException {
        try (OperationFuture fut = null;){
            fut = cq.execute(state.getEventSubSequence());
            int waitResult = fut.await(this.getAsyncWriterStartTimeout(state));
            if (waitResult != 2) {
                state.setOperationFuture(fut);
                fut = null;
                throw EntryUnavailableException.instance("retry alter table wait");
            }
        }
        this.metrics.jsonQueryMetrics().markComplete();
        JsonQueryProcessor.sendConfirmation(state, keepAliveHeader);
    }

    private void executeCachedSelect(JsonQueryProcessorState state, RecordCursorFactory factory) throws PeerDisconnectedException, PeerIsSlowToReadException, QueryPausedException, SqlException {
        state.setCompilerNanos(0L);
        this.sqlExecutionContext.setCacheHit(true);
        this.executeSelect(state, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDdl(JsonQueryProcessorState state, CompiledQuery cq, CharSequence keepAliveHeader) throws PeerIsSlowToReadException, PeerDisconnectedException, SqlException {
        Operation op = cq.getOperation();
        try (OperationFuture fut = op.execute(this.sqlExecutionContext, state.getEventSubSequence());){
            int waitResult = fut.await(this.getAsyncWriterStartTimeout(state));
            if (waitResult != 2) {
                state.setOperation(op);
                op = null;
                throw EntryUnavailableException.instance("retry alter table wait");
            }
        }
        finally {
            Misc.free(op);
        }
        this.metrics.jsonQueryMetrics().markComplete();
        JsonQueryProcessor.sendConfirmation(state, keepAliveHeader);
    }

    private void executeExplain(JsonQueryProcessorState state, CompiledQuery cq, CharSequence keepAliveHeader) throws PeerDisconnectedException, PeerIsSlowToReadException, QueryPausedException, SqlException {
        this.executeSelect0(state, cq.getRecordCursorFactory(), false);
    }

    private void executeInsert(JsonQueryProcessorState state, CompiledQuery cq, CharSequence keepAliveHeader) throws PeerDisconnectedException, PeerIsSlowToReadException, SqlException {
        try (InsertOperation insert = cq.popInsertOperation();){
            insert.execute(this.sqlExecutionContext).await();
            this.metrics.jsonQueryMetrics().markComplete();
            JsonQueryProcessor.sendInsertConfirmation(state, keepAliveHeader);
        }
    }

    private void executeNewSelect(JsonQueryProcessorState state, CompiledQuery cq, CharSequence keepAliveHeader) throws PeerDisconnectedException, PeerIsSlowToReadException, QueryPausedException, SqlException {
        this.executeSelect(state, cq.getRecordCursorFactory());
    }

    private void executePseudoSelect(JsonQueryProcessorState state, CompiledQuery cq, CharSequence keepAliveHeader) throws PeerDisconnectedException, PeerIsSlowToReadException, QueryPausedException, SqlException {
        RecordCursorFactory factory = cq.getRecordCursorFactory();
        if (factory == null) {
            this.updateMetricsAndSendConfirmation(state, cq, keepAliveHeader);
            return;
        }
        this.executeSelect0(state, factory, false);
    }

    private void executeSelect(JsonQueryProcessorState state, RecordCursorFactory factory) throws PeerDisconnectedException, PeerIsSlowToReadException, QueryPausedException, SqlException {
        this.executeSelect0(state, factory, true);
    }

    private void executeSelect0(JsonQueryProcessorState state, RecordCursorFactory factory, boolean queryCacheable) throws PeerDisconnectedException, PeerIsSlowToReadException, SqlException, QueryPausedException {
        RecordCursor cursor;
        HttpConnectionContext context = state.getHttpConnectionContext();
        if (!state.of(factory, queryCacheable, this.sqlExecutionContext)) {
            JsonQueryProcessor.readyForNextRequest(context);
            return;
        }
        try {
            cursor = factory.getCursor(this.sqlExecutionContext);
        }
        catch (Throwable th) {
            state.clearFactory();
            throw th;
        }
        try {
            state.setCursor(cursor);
            this.doResumeSend(state, context);
            this.metrics.jsonQueryMetrics().markComplete();
        }
        catch (CairoException ex) {
            state.setQueryCacheable(queryCacheable && ex.isCacheable());
            throw ex;
        }
    }

    private void executeUpdate(JsonQueryProcessorState state, CompiledQuery cq, CharSequence keepAliveHeader) throws PeerDisconnectedException, PeerIsSlowToReadException, SqlException {
        this.circuitBreaker.resetTimer();
        this.sqlExecutionContext.initNow();
        OperationFuture fut = null;
        boolean isAsyncWait = false;
        try {
            fut = cq.execute(this.sqlExecutionContext, state.getEventSubSequence(), true);
            int waitResult = fut.await(this.getAsyncWriterStartTimeout(state));
            if (waitResult != 2) {
                isAsyncWait = true;
                state.setOperationFuture(fut);
                throw EntryUnavailableException.instance("retry update table wait");
            }
            long updatedCount = fut.getAffectedRowsCount();
            this.metrics.jsonQueryMetrics().markComplete();
            JsonQueryProcessor.sendUpdateConfirmation(state, keepAliveHeader, updatedCount);
        }
        catch (CairoException e) {
            if (e.isInterruption() || e.isOutOfMemory()) {
                Misc.free(cq.getUpdateOperation());
            }
            throw e;
        }
        finally {
            if (!isAsyncWait && fut != null) {
                fut.close();
            }
        }
    }

    private long getAsyncWriterStartTimeout(JsonQueryProcessorState state) {
        return Math.min(this.asyncWriterStartTimeout, state.getStatementTimeout());
    }

    private void internalError(HttpChunkedResponse response, long bytesSent, CharSequence message, int code, Throwable e, JsonQueryProcessorState state, Metrics metrics) throws PeerDisconnectedException, PeerIsSlowToReadException {
        int messagePosition;
        JsonQueryProcessor.logInternalError(e, state, metrics);
        int n = messagePosition = e instanceof CairoException ? ((CairoException)e).getPosition() : 0;
        if (bytesSent > 0L) {
            state.querySuffixWithError(response, code, message, messagePosition);
        } else {
            JsonQueryProcessor.sendException(response, state.getHttpConnectionContext(), messagePosition, message, state.getQuery(), this.configuration.getKeepAliveHeader(), code);
        }
    }

    private boolean parseUrl(JsonQueryProcessorState state, CharSequence keepAliveHeader) throws PeerDisconnectedException, PeerIsSlowToReadException {
        HttpConnectionContext context = state.getHttpConnectionContext();
        HttpRequestHeader header = context.getRequestHeader();
        DirectUtf8Sequence query = header.getUrlParam(HttpConstants.URL_PARAM_QUERY);
        if (query == null || query.size() == 0) {
            try {
                state.configure(header, null, 0L, Long.MAX_VALUE);
            }
            catch (Utf8Exception utf8Exception) {
                // empty catch block
            }
            state.info().$("Empty query header received. Sending empty reply.").$();
            JsonQueryProcessor.sendEmptyQueryNotice(state, null, keepAliveHeader);
            return false;
        }
        long skip = 0L;
        long stop = Long.MAX_VALUE;
        DirectUtf8Sequence limit = header.getUrlParam(HttpConstants.URL_PARAM_LIMIT);
        if (limit != null) {
            int sepPos = Chars.indexOf(limit.asAsciiCharSequence(), ',');
            try {
                if (sepPos > 0) {
                    skip = Numbers.parseLong(limit, 0, sepPos) - 1L;
                    if (sepPos + 1 < limit.size()) {
                        stop = Numbers.parseLong(limit, sepPos + 1, limit.size());
                    }
                } else {
                    stop = Numbers.parseLong(limit);
                }
            }
            catch (NumericException numericException) {
                // empty catch block
            }
        }
        if (stop < 0L) {
            stop = 0L;
        }
        if (skip < 0L) {
            skip = 0L;
        }
        if (stop - skip > this.configuration.getMaxQueryResponseRowLimit()) {
            stop = skip + this.configuration.getMaxQueryResponseRowLimit();
        }
        try {
            state.configure(header, query, skip, stop);
        }
        catch (Utf8Exception e) {
            state.info().$("Bad UTF8 encoding").$();
            JsonQueryProcessor.sendBadUtf8EncodingInRequestResponse(context.getChunkedResponse(), context, query, keepAliveHeader);
            return false;
        }
        return true;
    }

    private void retryQueryExecution(JsonQueryProcessorState state, OperationFuture fut) throws PeerIsSlowToReadException, PeerDisconnectedException, QueryPausedException, SqlException {
        int waitResult;
        try {
            waitResult = fut.await(0L);
        }
        catch (TableReferenceOutOfDateException e) {
            state.freeAsyncOperation();
            this.compileAndExecuteQuery(state);
            return;
        }
        if (waitResult != 2) {
            long timeout;
            long l = timeout = state.getStatementTimeout() > 0L ? state.getStatementTimeout() : this.asyncCommandTimeout;
            if (state.getExecutionTimeNanos() / 1000000L < timeout) {
                throw EntryUnavailableException.instance("wait for update query");
            }
            state.freeAsyncOperation();
            throw SqlTimeoutException.timeout("Query timeout. Please add HTTP header 'Statement-Timeout' with timeout in ms [timeout=").put(timeout).put("ms]");
        }
        state.freeAsyncOperation();
        if (state.getQueryType() == 14) {
            JsonQueryProcessor.sendUpdateConfirmation(state, this.configuration.getKeepAliveHeader(), fut.getAffectedRowsCount());
        } else {
            JsonQueryProcessor.sendConfirmation(state, this.configuration.getKeepAliveHeader());
        }
    }

    private void updateMetricsAndSendConfirmation(JsonQueryProcessorState state, CompiledQuery cq, CharSequence keepAliveHeader) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.metrics.jsonQueryMetrics().markComplete();
        JsonQueryProcessor.sendConfirmation(state, keepAliveHeader);
    }

    protected static void header(HttpChunkedResponse response, HttpConnectionContext context, CharSequence keepAliveHeader, int statusCode) throws PeerDisconnectedException, PeerIsSlowToReadException {
        response.status(statusCode, "application/json; charset=utf-8");
        response.headers().setKeepAlive(keepAliveHeader);
        context.getCookieHandler().setCookie(response.headers(), context.getSecurityContext());
        response.sendHeader();
    }

    static void sendBadUtf8EncodingInRequestResponse(HttpChunkedResponse response, HttpConnectionContext context, DirectUtf8Sequence query, CharSequence keepAliveHeader) throws PeerDisconnectedException, PeerIsSlowToReadException {
        JsonQueryProcessor.header(response, context, keepAliveHeader, 400);
        ((Utf8Sink)((Utf8Sink)((Utf8Sink)((Utf8Sink)response.putAscii('{').putAsciiQuoted("query")).putAscii(':').putQuoted(query == null ? "" : query.asAsciiCharSequence()).putAscii(',').putAsciiQuoted("error")).putAscii(':').putQuoted("Bad UTF8 encoding in query text").putAscii(',').putAsciiQuoted("position")).putAscii(':').put(0)).putAscii('}');
        response.sendChunk(true);
    }

    static void sendException(HttpChunkedResponse response, HttpConnectionContext context, int position, CharSequence message, CharSequence query, CharSequence keepAliveHeader, int code) throws PeerDisconnectedException, PeerIsSlowToReadException {
        JsonQueryProcessor.header(response, context, keepAliveHeader, code);
        JsonQueryProcessorState.prepareExceptionJson(response, position, message, query);
    }

    @FunctionalInterface
    public static interface QueryExecutor {
        public void execute(JsonQueryProcessorState var1, CompiledQuery var2, CharSequence var3) throws PeerDisconnectedException, PeerIsSlowToReadException, QueryPausedException, SqlException;
    }
}

