/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass;

import io.questdb.Metrics;
import io.questdb.ServerConfiguration;
import io.questdb.WorkerPoolManager;
import io.questdb.cairo.CairoEngine;
import io.questdb.cutlass.http.HttpCookieHandler;
import io.questdb.cutlass.http.HttpFullFatServerConfiguration;
import io.questdb.cutlass.http.HttpHeaderParserFactory;
import io.questdb.cutlass.http.HttpRequestHandler;
import io.questdb.cutlass.http.HttpRequestHandlerFactory;
import io.questdb.cutlass.http.HttpServer;
import io.questdb.cutlass.http.HttpServerConfiguration;
import io.questdb.cutlass.http.processors.HealthCheckProcessor;
import io.questdb.cutlass.http.processors.JsonQueryProcessor;
import io.questdb.cutlass.http.processors.LineHttpProcessorImpl;
import io.questdb.cutlass.http.processors.PrometheusMetricsProcessor;
import io.questdb.cutlass.line.tcp.LineTcpReceiver;
import io.questdb.cutlass.line.tcp.LineTcpReceiverConfiguration;
import io.questdb.cutlass.line.udp.AbstractLineProtoUdpReceiver;
import io.questdb.cutlass.line.udp.LineUdpReceiver;
import io.questdb.cutlass.line.udp.LineUdpReceiverConfiguration;
import io.questdb.cutlass.line.udp.LinuxMMLineUdpReceiver;
import io.questdb.cutlass.pgwire.DefaultPGCircuitBreakerRegistry;
import io.questdb.cutlass.pgwire.PGCircuitBreakerRegistry;
import io.questdb.cutlass.pgwire.PGConfiguration;
import io.questdb.cutlass.pgwire.PGHexTestsCircuitBreakRegistry;
import io.questdb.cutlass.pgwire.PGServer;
import io.questdb.griffin.SqlExecutionContextImpl;
import io.questdb.mp.WorkerPool;
import io.questdb.std.ObjList;
import io.questdb.std.Os;
import org.jetbrains.annotations.Nullable;

public class Services {
    public static final Services INSTANCE = new Services();

    protected Services() {
    }

    @Nullable
    public HttpServer createHttpServer(ServerConfiguration serverConfiguration, CairoEngine cairoEngine, WorkerPoolManager workerPoolManager) {
        HttpFullFatServerConfiguration httpServerConfiguration = serverConfiguration.getHttpServerConfiguration();
        if (!httpServerConfiguration.isEnabled()) {
            return null;
        }
        return this.createHttpServer(serverConfiguration, cairoEngine, workerPoolManager.getSharedNetworkPool(httpServerConfiguration, WorkerPoolManager.Requester.HTTP_SERVER), workerPoolManager.getSharedQueryWorkerCount());
    }

    @Nullable
    public HttpServer createHttpServer(ServerConfiguration serverConfiguration, CairoEngine cairoEngine, WorkerPool networkSharedPool, int sharedQueryWorkerCount) {
        HttpFullFatServerConfiguration httpServerConfiguration = serverConfiguration.getHttpServerConfiguration();
        if (!httpServerConfiguration.isEnabled()) {
            return null;
        }
        HttpCookieHandler cookieHandler = serverConfiguration.getFactoryProvider().getHttpCookieHandler();
        HttpHeaderParserFactory headerParserFactory = serverConfiguration.getFactoryProvider().getHttpHeaderParserFactory();
        HttpServer server = new HttpServer(httpServerConfiguration, networkSharedPool, serverConfiguration.getFactoryProvider().getHttpSocketFactory(), cookieHandler, headerParserFactory);
        HttpServer.HttpRequestHandlerBuilder jsonQueryProcessorBuilder = () -> new JsonQueryProcessor(httpServerConfiguration.getJsonQueryProcessorConfiguration(), cairoEngine, sharedQueryWorkerCount);
        HttpServer.HttpRequestHandlerBuilder ilpV2WriteProcessorBuilder = () -> new LineHttpProcessorImpl(cairoEngine, httpServerConfiguration.getRecvBufferSize(), httpServerConfiguration.getSendBufferSize(), httpServerConfiguration.getLineHttpProcessorConfiguration());
        HttpServer.addDefaultEndpoints(server, serverConfiguration, cairoEngine, sharedQueryWorkerCount, jsonQueryProcessorBuilder, ilpV2WriteProcessorBuilder);
        return server;
    }

    @Nullable
    public LineTcpReceiver createLineTcpReceiver(LineTcpReceiverConfiguration config, CairoEngine cairoEngine, WorkerPoolManager workerPoolManager) {
        if (!config.isEnabled()) {
            return null;
        }
        WorkerPool networkSharedPool = workerPoolManager.getSharedNetworkPool(config.getNetworkWorkerPoolConfiguration(), WorkerPoolManager.Requester.LINE_TCP_IO);
        WorkerPool writerPool = workerPoolManager.getInstanceWrite(config.getWriterWorkerPoolConfiguration(), WorkerPoolManager.Requester.LINE_TCP_WRITER);
        return new LineTcpReceiver(config, cairoEngine, networkSharedPool, writerPool);
    }

    @Nullable
    public AbstractLineProtoUdpReceiver createLineUdpReceiver(LineUdpReceiverConfiguration config, CairoEngine cairoEngine, WorkerPoolManager workerPoolManager) {
        if (!config.isEnabled()) {
            return null;
        }
        if (Os.isLinux()) {
            return new LinuxMMLineUdpReceiver(config, cairoEngine, workerPoolManager.getSharedPoolNetwork());
        }
        return new LineUdpReceiver(config, cairoEngine, workerPoolManager.getSharedPoolNetwork());
    }

    @Nullable
    public HttpServer createMinHttpServer(HttpServerConfiguration configuration, WorkerPoolManager workerPoolManager) {
        if (!configuration.isEnabled()) {
            return null;
        }
        WorkerPool networkSharedPool = workerPoolManager.getSharedNetworkPool(configuration, WorkerPoolManager.Requester.HTTP_MIN_SERVER);
        return this.createMinHttpServer(configuration, networkSharedPool);
    }

    @Nullable
    public HttpServer createMinHttpServer(final HttpServerConfiguration configuration, WorkerPool workerPool) {
        if (!configuration.isEnabled()) {
            return null;
        }
        HttpServer server = new HttpServer(configuration, workerPool, configuration.getFactoryProvider().getHttpMinSocketFactory());
        final Metrics metrics = configuration.getHttpContextConfiguration().getMetrics();
        server.bind(new HttpRequestHandlerFactory(){

            @Override
            public ObjList<String> getUrls() {
                return configuration.getContextPathStatus();
            }

            @Override
            public HttpRequestHandler newInstance() {
                return new HealthCheckProcessor(configuration);
            }
        }, true);
        if (metrics.isEnabled()) {
            final PrometheusMetricsProcessor.RequestStatePool pool = new PrometheusMetricsProcessor.RequestStatePool(configuration.getWorkerCount());
            server.registerClosable(pool);
            server.bind(new HttpRequestHandlerFactory(){

                @Override
                public ObjList<String> getUrls() {
                    return configuration.getContextPathMetrics();
                }

                @Override
                public HttpRequestHandler newInstance() {
                    return new PrometheusMetricsProcessor(metrics, configuration, pool);
                }
            });
        }
        return server;
    }

    public PGServer createPGWireServer(PGConfiguration configuration, CairoEngine cairoEngine, WorkerPoolManager workerPoolManager) {
        if (!configuration.isEnabled()) {
            return null;
        }
        WorkerPool networkSharedPool = workerPoolManager.getSharedNetworkPool(configuration, WorkerPoolManager.Requester.PG_WIRE_SERVER);
        PGCircuitBreakerRegistry registry = configuration.getDumpNetworkTraffic() ? PGHexTestsCircuitBreakRegistry.INSTANCE : new DefaultPGCircuitBreakerRegistry(configuration, cairoEngine.getConfiguration());
        return new PGServer(configuration, cairoEngine, networkSharedPool, registry, () -> new SqlExecutionContextImpl(cairoEngine, workerPoolManager.getSharedQueryWorkerCount()));
    }
}

