/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.sql.async;

import io.questdb.cairo.sql.async.WorkStealingStrategy;
import io.questdb.std.Os;
import java.util.concurrent.atomic.AtomicInteger;

public class AdaptiveWorkStealingStrategy
implements WorkStealingStrategy {
    private final int noStealingThreshold;
    private AtomicInteger startedCounter;

    public AdaptiveWorkStealingStrategy(int noStealingThreshold) {
        this.noStealingThreshold = noStealingThreshold;
    }

    @Override
    public WorkStealingStrategy of(AtomicInteger startedCounter) {
        this.startedCounter = startedCounter;
        return this;
    }

    @Override
    public boolean shouldSteal(int finishedCount) {
        for (int i = 0; i < this.noStealingThreshold; ++i) {
            Os.pause();
            if (this.startedCounter.get() - finishedCount < this.noStealingThreshold) continue;
            return false;
        }
        return true;
    }
}

