/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.pool;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.PartitionOverwriteControl;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TxnScoreboardPool;
import io.questdb.cairo.pool.AbstractMultiTenantPool;
import io.questdb.cairo.pool.PoolTenant;
import io.questdb.cairo.pool.ResourcePoolSupervisor;
import org.jetbrains.annotations.Nullable;

public class ReaderPool
extends AbstractMultiTenantPool<R> {
    private final TxnScoreboardPool txnScoreboardPool;
    private final MessageBus messageBus;
    private final PartitionOverwriteControl partitionOverwriteControl;
    private ReaderListener readerListener;

    public ReaderPool(CairoConfiguration configuration, TxnScoreboardPool scoreboardPool, MessageBus messageBus, PartitionOverwriteControl partitionOverwriteControl) {
        super(configuration, configuration.getReaderPoolMaxSegments(), configuration.getInactiveReaderTTL());
        this.txnScoreboardPool = scoreboardPool;
        this.messageBus = messageBus;
        this.partitionOverwriteControl = partitionOverwriteControl;
    }

    public ReaderPool(CairoConfiguration configuration, TxnScoreboardPool scoreboardPool, MessageBus messageBus) {
        this(configuration, scoreboardPool, messageBus, null);
    }

    public void attach(TableReader reader) {
        R rdr = (R)reader;
        rdr.attach();
    }

    public void detach(TableReader reader) {
        R rdr = (R)reader;
        rdr.detach();
    }

    @Override
    public TableReader getCopyOf(TableReader srcReader) {
        return this.getCopyOf((R)srcReader);
    }

    public int getDetachedRefCount(TableReader reader) {
        return ((R)reader).getDetachedRefCount();
    }

    public void incDetachedRefCount(TableReader reader) {
        ((R)reader).incrementDetachedRefCount();
    }

    @Override
    public boolean isCopyOfSupported() {
        return true;
    }

    public boolean isDetached(TableReader reader) {
        return ((R)reader).isDetached();
    }

    public void setTableReaderListener(ReaderListener readerListener) {
        this.readerListener = readerListener;
    }

    @Override
    protected byte getListenerSrc() {
        return 2;
    }

    @Override
    protected R newCopyOfTenant(R srcReader, AbstractMultiTenantPool.Entry<R> entry, int index, ResourcePoolSupervisor<R> supervisor) {
        return new R((AbstractMultiTenantPool<R>)this, entry, index, srcReader, this.txnScoreboardPool, this.messageBus, this.readerListener, this.partitionOverwriteControl, supervisor);
    }

    @Override
    protected R newTenant(TableToken tableToken, AbstractMultiTenantPool.Entry<R> entry, int index, ResourcePoolSupervisor<R> supervisor) {
        return new R((AbstractMultiTenantPool<R>)this, entry, index, tableToken, this.txnScoreboardPool, this.messageBus, this.readerListener, this.partitionOverwriteControl, supervisor);
    }

    public static class R
    extends TableReader
    implements PoolTenant<R> {
        private final int index;
        private final ReaderListener readerListener;
        private boolean detached;
        private int detachedRefCount;
        private AbstractMultiTenantPool.Entry<R> entry;
        private AbstractMultiTenantPool<R> pool;
        private ResourcePoolSupervisor<R> supervisor;

        public R(AbstractMultiTenantPool<R> pool, AbstractMultiTenantPool.Entry<R> entry, int index, TableToken tableToken, TxnScoreboardPool txnScoreboardPool, MessageBus messageBus, ReaderListener readerListener, PartitionOverwriteControl partitionOverwriteControl, ResourcePoolSupervisor<R> supervisor) {
            super(entry.getIndex() * 32 + index, pool.getConfiguration(), tableToken, txnScoreboardPool, messageBus, partitionOverwriteControl);
            this.pool = pool;
            this.entry = entry;
            this.index = index;
            this.readerListener = readerListener;
            this.supervisor = supervisor;
        }

        public R(AbstractMultiTenantPool<R> pool, AbstractMultiTenantPool.Entry<R> entry, int index, R srcReader, TxnScoreboardPool txnScoreboardPool, MessageBus messageBus, ReaderListener readerListener, PartitionOverwriteControl partitionOverwriteControl, ResourcePoolSupervisor<R> supervisor) {
            super(entry.getIndex() * 32 + index, pool.getConfiguration(), srcReader, txnScoreboardPool, messageBus, partitionOverwriteControl);
            this.pool = pool;
            this.entry = entry;
            this.index = index;
            this.readerListener = readerListener;
            this.supervisor = supervisor;
        }

        public void attach() {
            assert (this.detachedRefCount == 0);
            this.detached = false;
        }

        @Override
        public void close() {
            if (this.isOpen()) {
                if (!this.detached) {
                    if (this.supervisor != null) {
                        this.supervisor.onResourceReturned(this);
                        this.supervisor = null;
                    }
                    this.goPassive();
                    AbstractMultiTenantPool<R> pool = this.pool;
                    if (pool == null || this.entry == null || !pool.returnToPool(this)) {
                        super.close();
                    }
                } else {
                    --this.detachedRefCount;
                }
            }
        }

        public void detach() {
            this.detached = true;
            this.detachedRefCount = 0;
        }

        public int getDetachedRefCount() {
            return this.detachedRefCount;
        }

        @Override
        public AbstractMultiTenantPool.Entry<R> getEntry() {
            return this.entry;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        public ResourcePoolSupervisor<R> getSupervisor() {
            return this.supervisor;
        }

        @Override
        public void goodbye() {
            this.entry = null;
            this.pool = null;
        }

        public void incrementDetachedRefCount() {
            assert (this.detached);
            ++this.detachedRefCount;
        }

        public boolean isDetached() {
            return this.detached;
        }

        @Override
        public long openPartition(int partitionIndex) {
            if (this.readerListener != null) {
                this.readerListener.onOpenPartition(this.getTableToken(), partitionIndex);
            }
            return super.openPartition(partitionIndex);
        }

        @Override
        public void refresh(ResourcePoolSupervisor<R> supervisor) {
            this.supervisor = supervisor;
            try {
                this.goActive();
            }
            catch (Throwable ex) {
                this.close();
                throw ex;
            }
        }

        @Override
        public void refreshAt(@Nullable ResourcePoolSupervisor<R> supervisor, R srcReader) {
            this.supervisor = supervisor;
            try {
                this.goActiveAtTxn(srcReader);
            }
            catch (Throwable ex) {
                this.close();
                throw ex;
            }
        }
    }

    @FunctionalInterface
    public static interface ReaderListener {
        public void onOpenPartition(TableToken var1, int var2);
    }
}

