/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.metrics.AtomicLongGauge;
import io.questdb.metrics.Counter;
import io.questdb.metrics.MetricsRegistry;
import io.questdb.std.Mutable;

public class TableWriterMetrics
implements Mutable {
    private final Counter commitCounter;
    private final Counter committedRowCounter;
    private final Counter o3CommitCounter;
    private final Counter physicallyWrittenRowCounter;
    private final Counter rollbackCounter;
    private final AtomicLongGauge suspendedTablesGauge;

    public TableWriterMetrics(MetricsRegistry metricsRegistry) {
        this.commitCounter = metricsRegistry.newCounter("commits");
        this.o3CommitCounter = metricsRegistry.newCounter("o3_commits");
        this.committedRowCounter = metricsRegistry.newCounter("committed_rows");
        this.physicallyWrittenRowCounter = metricsRegistry.newCounter("physically_written_rows");
        this.rollbackCounter = metricsRegistry.newCounter("rollbacks");
        this.suspendedTablesGauge = metricsRegistry.newAtomicLongGauge("suspended_tables");
    }

    public void addCommittedRows(long rows) {
        this.committedRowCounter.add(rows);
    }

    public void addPhysicallyWrittenRows(long rows) {
        this.physicallyWrittenRowCounter.add(rows);
    }

    @Override
    public void clear() {
        this.commitCounter.reset();
        this.committedRowCounter.reset();
        this.o3CommitCounter.reset();
        this.physicallyWrittenRowCounter.reset();
        this.rollbackCounter.reset();
        this.suspendedTablesGauge.setValue(0L);
    }

    public void decSuspendedTables() {
        this.suspendedTablesGauge.dec();
    }

    public long getCommitCount() {
        return this.commitCounter.getValue();
    }

    public long getCommittedRows() {
        return this.committedRowCounter.getValue();
    }

    public long getO3CommitCount() {
        return this.o3CommitCounter.getValue();
    }

    public long getPhysicallyWrittenRows() {
        return this.physicallyWrittenRowCounter.getValue();
    }

    public long getRollbackCount() {
        return this.rollbackCounter.getValue();
    }

    public void incSuspendedTables() {
        this.suspendedTablesGauge.inc();
    }

    public void incrementCommits() {
        this.commitCounter.inc();
    }

    public void incrementO3Commits() {
        this.o3CommitCounter.inc();
    }

    public void incrementRollbacks() {
        this.rollbackCounter.inc();
    }
}

