/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.ColumnFilter;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.RecordSinkSPI;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.BitSet;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.ex.BytecodeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecordSinkFactory {
    private static final int FIELD_POOL_OFFSET = 3;
    private static final Log LOG = LogFactory.getLog(RecordSinkFactory.class);

    public static RecordSink getInstance(BytecodeAssembler asm, ColumnTypes columnTypes, @NotNull ColumnFilter columnFilter) {
        return RecordSinkFactory.getInstance(asm, columnTypes, columnFilter, null, null, null, null);
    }

    public static RecordSink getInstance(BytecodeAssembler asm, ColumnTypes columnTypes, @NotNull ColumnFilter columnFilter, @Nullable BitSet writeSymbolAsString) {
        return RecordSinkFactory.getInstance(asm, columnTypes, columnFilter, null, null, writeSymbolAsString, null);
    }

    public static RecordSink getInstance(BytecodeAssembler asm, ColumnTypes columnTypes, @NotNull ColumnFilter columnFilter, @Nullable BitSet writeSymbolAsString, @Nullable BitSet writeStringAsVarchar) {
        return RecordSinkFactory.getInstance(asm, columnTypes, columnFilter, null, null, writeSymbolAsString, writeStringAsVarchar);
    }

    public static RecordSink getInstance(BytecodeAssembler asm, ColumnTypes columnTypes, @NotNull ColumnFilter columnFilter, @Nullable ObjList<Function> keyFunctions, @Nullable BitSet writeSymbolAsString) {
        return RecordSinkFactory.getInstance(asm, columnTypes, columnFilter, keyFunctions, null, writeSymbolAsString, null);
    }

    public static RecordSink getInstance(BytecodeAssembler asm, ColumnTypes columnTypes, @NotNull ColumnFilter columnFilter, @Nullable IntList skewIndex, @Nullable BitSet writeSymbolAsString) {
        return RecordSinkFactory.getInstance(asm, columnTypes, columnFilter, null, skewIndex, writeSymbolAsString, null);
    }

    public static RecordSink getInstance(BytecodeAssembler asm, ColumnTypes columnTypes, @NotNull ColumnFilter columnFilter, @Nullable ObjList<Function> keyFunctions, @Nullable BitSet writeSymbolAsString, @Nullable IntList skewIndex) {
        return RecordSinkFactory.getInstance(asm, columnTypes, columnFilter, keyFunctions, skewIndex, writeSymbolAsString, null);
    }

    public static RecordSink getInstance(BytecodeAssembler asm, ColumnTypes columnTypes, @NotNull ColumnFilter columnFilter, @Nullable ObjList<Function> keyFunctions, @Nullable IntList skewIndex, @Nullable BitSet writeSymbolAsString, @Nullable BitSet writeStringAsVarchar) {
        Class<RecordSink> clazz = RecordSinkFactory.getInstanceClass(asm, columnTypes, columnFilter, keyFunctions, skewIndex, writeSymbolAsString, writeStringAsVarchar);
        return RecordSinkFactory.getInstance(clazz, keyFunctions);
    }

    public static RecordSink getInstance(Class<RecordSink> clazz, @Nullable ObjList<Function> keyFunctions) {
        try {
            RecordSink sink = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (keyFunctions != null) {
                sink.setFunctions(keyFunctions);
            }
            return sink;
        }
        catch (Exception e) {
            LOG.critical().$("could not create an instance of RecordSink, cause: ").$(e).$();
            throw BytecodeException.INSTANCE;
        }
    }

    public static Class<RecordSink> getInstanceClass(BytecodeAssembler asm, ColumnTypes columnTypes, @NotNull ColumnFilter columnFilter, @Nullable ObjList<Function> keyFunctions, @Nullable BitSet writeSymbolAsString) {
        return RecordSinkFactory.getInstanceClass(asm, columnTypes, columnFilter, keyFunctions, null, writeSymbolAsString, null);
    }

    private static void generateSetFunctions(BytecodeAssembler asm, int functionSize, int firstFieldIndex, int setFunctionsIndex, int setFunctionsSigIndex, int getIndex) {
        asm.startMethod(setFunctionsIndex, setFunctionsSigIndex, 3, 3);
        for (int i = 0; i < functionSize; ++i) {
            asm.aload(0);
            asm.aload(1);
            asm.iconst(i);
            asm.invokeVirtual(getIndex);
            asm.putfield(firstFieldIndex + i * 3);
        }
        asm.return_();
        asm.endMethodCode();
        asm.putShort(0);
        asm.putShort(0);
        asm.endMethod();
    }

    private static Class<RecordSink> getInstanceClass(BytecodeAssembler asm, ColumnTypes columnTypes, @NotNull ColumnFilter columnFilter, @Nullable ObjList<Function> keyFunctions, @Nullable IntList skewIndex, @Nullable BitSet writeSymbolAsString, @Nullable BitSet writeStringAsVarchar) {
        int i;
        asm.init(RecordSink.class);
        asm.setupPool();
        int thisClassIndex = asm.poolClass(asm.poolUtf8("io/questdb/cairo/sink"));
        int interfaceClassIndex = asm.poolClass(RecordSink.class);
        int rGetInt = asm.poolInterfaceMethod(Record.class, "getInt", "(I)I");
        int rGetIPv4 = asm.poolInterfaceMethod(Record.class, "getIPv4", "(I)I");
        int rGetGeoInt = asm.poolInterfaceMethod(Record.class, "getGeoInt", "(I)I");
        int rGetLong = asm.poolInterfaceMethod(Record.class, "getLong", "(I)J");
        int rGetGeoLong = asm.poolInterfaceMethod(Record.class, "getGeoLong", "(I)J");
        int rGetLong256 = asm.poolInterfaceMethod(Record.class, "getLong256A", "(I)Lio/questdb/std/Long256;");
        int rGetLong128Lo = asm.poolInterfaceMethod(Record.class, "getLong128Lo", "(I)J");
        int rGetLong128Hi = asm.poolInterfaceMethod(Record.class, "getLong128Hi", "(I)J");
        int rGetDate = asm.poolInterfaceMethod(Record.class, "getDate", "(I)J");
        int rGetTimestamp = asm.poolInterfaceMethod(Record.class, "getTimestamp", "(I)J");
        int rGetByte = asm.poolInterfaceMethod(Record.class, "getByte", "(I)B");
        int rGetGeoByte = asm.poolInterfaceMethod(Record.class, "getGeoByte", "(I)B");
        int rGetShort = asm.poolInterfaceMethod(Record.class, "getShort", "(I)S");
        int rGetGeoShort = asm.poolInterfaceMethod(Record.class, "getGeoShort", "(I)S");
        int rGetChar = asm.poolInterfaceMethod(Record.class, "getChar", "(I)C");
        int rGetBool = asm.poolInterfaceMethod(Record.class, "getBool", "(I)Z");
        int rGetFloat = asm.poolInterfaceMethod(Record.class, "getFloat", "(I)F");
        int rGetDouble = asm.poolInterfaceMethod(Record.class, "getDouble", "(I)D");
        int rGetStr = asm.poolInterfaceMethod(Record.class, "getStrA", "(I)Ljava/lang/CharSequence;");
        int rGetVarchar = asm.poolInterfaceMethod(Record.class, "getVarcharA", "(I)Lio/questdb/std/str/Utf8Sequence;");
        int rGetSym = asm.poolInterfaceMethod(Record.class, "getSymA", "(I)Ljava/lang/CharSequence;");
        int rGetBin = asm.poolInterfaceMethod(Record.class, "getBin", "(I)Lio/questdb/std/BinarySequence;");
        int rGetRecord = asm.poolInterfaceMethod(Record.class, "getRecord", "(I)Lio/questdb/cairo/sql/Record;");
        int rGetInterval = asm.poolInterfaceMethod(Record.class, "getInterval", "(I)Lio/questdb/std/Interval;");
        int rGetArray = asm.poolInterfaceMethod(Record.class, "getArray", "(II)Lio/questdb/cairo/arr/ArrayView;");
        int fGetInt = asm.poolInterfaceMethod(Function.class, "getInt", "(Lio/questdb/cairo/sql/Record;)I");
        int fGetIPv4 = asm.poolInterfaceMethod(Function.class, "getIPv4", "(Lio/questdb/cairo/sql/Record;)I");
        int fGetGeoInt = asm.poolInterfaceMethod(Function.class, "getGeoInt", "(Lio/questdb/cairo/sql/Record;)I");
        int fGetLong = asm.poolInterfaceMethod(Function.class, "getLong", "(Lio/questdb/cairo/sql/Record;)J");
        int fGetGeoLong = asm.poolInterfaceMethod(Function.class, "getGeoLong", "(Lio/questdb/cairo/sql/Record;)J");
        int fGetLong256 = asm.poolInterfaceMethod(Function.class, "getLong256A", "(Lio/questdb/cairo/sql/Record;)Lio/questdb/std/Long256;");
        int fGetLong128Lo = asm.poolInterfaceMethod(Function.class, "getLong128Lo", "(Lio/questdb/cairo/sql/Record;)J");
        int fGetLong128Hi = asm.poolInterfaceMethod(Function.class, "getLong128Hi", "(Lio/questdb/cairo/sql/Record;)J");
        int fGetDate = asm.poolInterfaceMethod(Function.class, "getDate", "(Lio/questdb/cairo/sql/Record;)J");
        int fGetTimestamp = asm.poolInterfaceMethod(Function.class, "getTimestamp", "(Lio/questdb/cairo/sql/Record;)J");
        int fGetByte = asm.poolInterfaceMethod(Function.class, "getByte", "(Lio/questdb/cairo/sql/Record;)B");
        int fGetGeoByte = asm.poolInterfaceMethod(Function.class, "getGeoByte", "(Lio/questdb/cairo/sql/Record;)B");
        int fGetShort = asm.poolInterfaceMethod(Function.class, "getShort", "(Lio/questdb/cairo/sql/Record;)S");
        int fGetGeoShort = asm.poolInterfaceMethod(Function.class, "getGeoShort", "(Lio/questdb/cairo/sql/Record;)S");
        int fGetChar = asm.poolInterfaceMethod(Function.class, "getChar", "(Lio/questdb/cairo/sql/Record;)C");
        int fGetBool = asm.poolInterfaceMethod(Function.class, "getBool", "(Lio/questdb/cairo/sql/Record;)Z");
        int fGetFloat = asm.poolInterfaceMethod(Function.class, "getFloat", "(Lio/questdb/cairo/sql/Record;)F");
        int fGetDouble = asm.poolInterfaceMethod(Function.class, "getDouble", "(Lio/questdb/cairo/sql/Record;)D");
        int fGetStr = asm.poolInterfaceMethod(Function.class, "getStrA", "(Lio/questdb/cairo/sql/Record;)Ljava/lang/CharSequence;");
        int fGetVarchar = asm.poolInterfaceMethod(Function.class, "getVarcharA", "(Lio/questdb/cairo/sql/Record;)Lio/questdb/std/str/Utf8Sequence;");
        int fGetSym = asm.poolInterfaceMethod(Function.class, "getSymbol", "(Lio/questdb/cairo/sql/Record;)Ljava/lang/CharSequence;");
        int fGetBin = asm.poolInterfaceMethod(Function.class, "getBin", "(Lio/questdb/cairo/sql/Record;)Lio/questdb/std/BinarySequence;");
        int fGetRecord = asm.poolInterfaceMethod(Function.class, "getRecord", "(Lio/questdb/cairo/sql/Record;)Lio/questdb/cairo/sql/Record;");
        int fGetInterval = asm.poolInterfaceMethod(Function.class, "getInterval", "(Lio/questdb/cairo/sql/Record;)Lio/questdb/std/Interval;");
        int fGetArray = asm.poolInterfaceMethod(Function.class, "getArray", "(Lio/questdb/cairo/sql/Record;)Lio/questdb/cairo/arr/ArrayView;");
        int wSkip = asm.poolInterfaceMethod(RecordSinkSPI.class, "skip", "(I)V");
        int wPutInt = asm.poolInterfaceMethod(RecordSinkSPI.class, "putInt", "(I)V");
        int wPutIPv4 = asm.poolInterfaceMethod(RecordSinkSPI.class, "putIPv4", "(I)V");
        int wPutLong = asm.poolInterfaceMethod(RecordSinkSPI.class, "putLong", "(J)V");
        int wPutLong256 = asm.poolInterfaceMethod(RecordSinkSPI.class, "putLong256", "(Lio/questdb/std/Long256;)V");
        int wPutLong128 = asm.poolInterfaceMethod(RecordSinkSPI.class, "putLong128", "(JJ)V");
        int wPutByte = asm.poolInterfaceMethod(RecordSinkSPI.class, "putByte", "(B)V");
        int wPutShort = asm.poolInterfaceMethod(RecordSinkSPI.class, "putShort", "(S)V");
        int wPutChar = asm.poolInterfaceMethod(RecordSinkSPI.class, "putChar", "(C)V");
        int wPutBool = asm.poolInterfaceMethod(RecordSinkSPI.class, "putBool", "(Z)V");
        int wPutFloat = asm.poolInterfaceMethod(RecordSinkSPI.class, "putFloat", "(F)V");
        int wPutDouble = asm.poolInterfaceMethod(RecordSinkSPI.class, "putDouble", "(D)V");
        int wPutStr = asm.poolInterfaceMethod(RecordSinkSPI.class, "putStr", "(Ljava/lang/CharSequence;)V");
        int wPutVarchar = asm.poolInterfaceMethod(RecordSinkSPI.class, "putVarchar", "(Lio/questdb/std/str/Utf8Sequence;)V");
        int wPutStrAsVarchar = asm.poolInterfaceMethod(RecordSinkSPI.class, "putVarchar", "(Ljava/lang/CharSequence;)V");
        int wPutDate = asm.poolInterfaceMethod(RecordSinkSPI.class, "putDate", "(J)V");
        int wPutTimestamp = asm.poolInterfaceMethod(RecordSinkSPI.class, "putTimestamp", "(J)V");
        int wPutBin = asm.poolInterfaceMethod(RecordSinkSPI.class, "putBin", "(Lio/questdb/std/BinarySequence;)V");
        int wPutRecord = asm.poolInterfaceMethod(RecordSinkSPI.class, "putRecord", "(Lio/questdb/cairo/sql/Record;)V");
        int wPutInterval = asm.poolInterfaceMethod(RecordSinkSPI.class, "putInterval", "(Lio/questdb/std/Interval;)V");
        int wPutArray = asm.poolInterfaceMethod(RecordSinkSPI.class, "putArray", "(Lio/questdb/cairo/arr/ArrayView;)V");
        int copyNameIndex = asm.poolUtf8("copy");
        int copySigIndex = asm.poolUtf8("(Lio/questdb/cairo/sql/Record;Lio/questdb/cairo/RecordSinkSPI;)V");
        int setFunctionsIndex = asm.poolUtf8("setFunctions");
        int setFunctionsSigIndex = asm.poolUtf8("(Lio/questdb/std/ObjList;)V");
        int getIndex = asm.poolMethod(ObjList.class, (CharSequence)"get", (CharSequence)"(I)Ljava/lang/Object;");
        int typeIndex = asm.poolUtf8("Lio/questdb/cairo/sql/Function;");
        int functionSize = keyFunctions != null ? keyFunctions.size() : 0;
        int firstFieldNameIndex = 0;
        int firstFieldIndex = 0;
        for (i = 0; i < functionSize; ++i) {
            int fieldNameIndex = asm.poolUtf8().putAscii("f").put(i).$();
            int nameAndType = asm.poolNameAndType(fieldNameIndex, typeIndex);
            int fieldIndex = asm.poolField(thisClassIndex, nameAndType);
            if (i != 0) continue;
            firstFieldNameIndex = fieldNameIndex;
            firstFieldIndex = fieldIndex;
        }
        asm.finishPool();
        asm.defineClass(thisClassIndex);
        asm.interfaceCount(1);
        asm.putShort(interfaceClassIndex);
        asm.fieldCount(functionSize);
        for (i = 0; i < functionSize; ++i) {
            asm.defineField(firstFieldNameIndex + i * 3, typeIndex);
        }
        asm.methodCount(3);
        asm.defineDefaultConstructor();
        asm.startMethod(copyNameIndex, copySigIndex, 7, 5);
        int n = columnFilter.getColumnCount();
        block55: for (i = 0; i < n; ++i) {
            int size;
            int index = columnFilter.getColumnIndex(i);
            int factor = columnFilter.getIndexFactor(index);
            index = index * factor - 1;
            int type = columnTypes.getColumnType(index);
            if (factor < 0 && (size = ColumnType.sizeOf(type)) > 0) {
                asm.aload(2);
                asm.iconst(size);
                asm.invokeInterface(wSkip, 1);
                continue;
            }
            boolean symAsString = writeSymbolAsString != null && writeSymbolAsString.get(index);
            boolean strAsVarchar = writeStringAsVarchar != null && writeStringAsVarchar.get(index);
            switch (factor * ColumnType.tagOf(type)) {
                case 5: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetInt, 1);
                    asm.invokeInterface(wPutInt, 1);
                    continue block55;
                }
                case 25: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetIPv4, 1);
                    asm.invokeInterface(wPutIPv4, 1);
                    continue block55;
                }
                case 12: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    if (symAsString) {
                        asm.invokeInterface(rGetSym, 1);
                        if (strAsVarchar) {
                            asm.invokeInterface(wPutStrAsVarchar, 1);
                            continue block55;
                        }
                        asm.invokeInterface(wPutStr, 1);
                        continue block55;
                    }
                    asm.invokeInterface(rGetInt, 1);
                    asm.invokeInterface(wPutInt, 1);
                    continue block55;
                }
                case 6: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetLong, 1);
                    asm.invokeInterface(wPutLong, 2);
                    continue block55;
                }
                case 7: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetDate, 1);
                    asm.invokeInterface(wPutDate, 2);
                    continue block55;
                }
                case 8: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetTimestamp, 1);
                    asm.invokeInterface(wPutTimestamp, 2);
                    continue block55;
                }
                case 2: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetByte, 1);
                    asm.invokeInterface(wPutByte, 1);
                    continue block55;
                }
                case 3: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetShort, 1);
                    asm.invokeInterface(wPutShort, 1);
                    continue block55;
                }
                case 4: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetChar, 1);
                    asm.invokeInterface(wPutChar, 1);
                    continue block55;
                }
                case 1: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetBool, 1);
                    asm.invokeInterface(wPutBool, 1);
                    continue block55;
                }
                case 9: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetFloat, 1);
                    asm.invokeInterface(wPutFloat, 1);
                    continue block55;
                }
                case 10: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetDouble, 1);
                    asm.invokeInterface(wPutDouble, 2);
                    continue block55;
                }
                case 11: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetStr, 1);
                    if (strAsVarchar) {
                        asm.invokeInterface(wPutStrAsVarchar, 1);
                        continue block55;
                    }
                    asm.invokeInterface(wPutStr, 1);
                    continue block55;
                }
                case 26: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetVarchar, 1);
                    asm.invokeInterface(wPutVarchar, 1);
                    continue block55;
                }
                case 18: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetBin, 1);
                    asm.invokeInterface(wPutBin, 1);
                    continue block55;
                }
                case 13: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetLong256, 1);
                    asm.invokeInterface(wPutLong256, 1);
                    continue block55;
                }
                case 22: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetRecord, 1);
                    asm.invokeInterface(wPutRecord, 1);
                    continue block55;
                }
                case 14: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetGeoByte, 1);
                    asm.invokeInterface(wPutByte, 1);
                    continue block55;
                }
                case 15: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetGeoShort, 1);
                    asm.invokeInterface(wPutShort, 1);
                    continue block55;
                }
                case 16: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetGeoInt, 1);
                    asm.invokeInterface(wPutInt, 1);
                    continue block55;
                }
                case 17: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetGeoLong, 1);
                    asm.invokeInterface(wPutLong, 2);
                    continue block55;
                }
                case 19: 
                case 24: {
                    int skewedIndex = RecordSinkFactory.getSkewedIndex(index, skewIndex);
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(skewedIndex);
                    asm.invokeInterface(rGetLong128Lo, 1);
                    asm.aload(1);
                    asm.iconst(skewedIndex);
                    asm.invokeInterface(rGetLong128Hi, 1);
                    asm.invokeInterface(wPutLong128, 4);
                    continue block55;
                }
                case 32: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetInterval, 1);
                    asm.invokeInterface(wPutInterval, 1);
                    continue block55;
                }
                case 27: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.iconst(type * factor);
                    asm.invokeInterface(rGetArray, 2);
                    asm.invokeInterface(wPutArray, 1);
                    continue block55;
                }
                case 33: {
                    continue block55;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected column type: " + ColumnType.nameOf(type));
                }
            }
        }
        boolean fnStrAsVarchar = false;
        block56: for (int i2 = 0; i2 < functionSize; ++i2) {
            Function func = keyFunctions.getQuick(i2);
            int type = func.getType();
            switch (ColumnType.tagOf(type)) {
                case 5: {
                    asm.aload(2);
                    asm.aload(0);
                    asm.getfield(firstFieldIndex + i2 * 3);
                    asm.aload(1);
                    asm.invokeInterface(fGetInt, 1);
                    asm.invokeInterface(wPutInt, 1);
                    continue block56;
                }
                case 25: {
                    asm.aload(2);
                    asm.aload(0);
                    asm.getfield(firstFieldIndex + i2 * 3);
                    asm.aload(1);
                    asm.invokeInterface(fGetIPv4, 1);
                    asm.invokeInterface(wPutIPv4, 1);
                    continue block56;
                }
                case 12: {
                    asm.aload(2);
                    asm.aload(0);
                    asm.getfield(firstFieldIndex + i2 * 3);
                    asm.aload(1);
                    asm.invokeInterface(fGetSym, 1);
                    if (fnStrAsVarchar) {
                        asm.invokeInterface(wPutStrAsVarchar, 1);
                        continue block56;
                    }
                    asm.invokeInterface(wPutStr, 1);
                    continue block56;
                }
                case 6: {
                    asm.aload(2);
                    asm.aload(0);
                    asm.getfield(firstFieldIndex + i2 * 3);
                    asm.aload(1);
                    asm.invokeInterface(fGetLong, 1);
                    asm.invokeInterface(wPutLong, 2);
                    continue block56;
                }
                case 7: {
                    asm.aload(2);
                    asm.aload(0);
                    asm.getfield(firstFieldIndex + i2 * 3);
                    asm.aload(1);
                    asm.invokeInterface(fGetDate, 1);
                    asm.invokeInterface(wPutDate, 2);
                    continue block56;
                }
                case 8: {
                    asm.aload(2);
                    asm.aload(0);
                    asm.getfield(firstFieldIndex + i2 * 3);
                    asm.aload(1);
                    asm.invokeInterface(fGetTimestamp, 1);
                    asm.invokeInterface(wPutTimestamp, 2);
                    continue block56;
                }
                case 2: {
                    asm.aload(2);
                    asm.aload(0);
                    asm.getfield(firstFieldIndex + i2 * 3);
                    asm.aload(1);
                    asm.invokeInterface(fGetByte, 1);
                    asm.invokeInterface(wPutByte, 1);
                    continue block56;
                }
                case 3: {
                    asm.aload(2);
                    asm.aload(0);
                    asm.getfield(firstFieldIndex + i2 * 3);
                    asm.aload(1);
                    asm.invokeInterface(fGetShort, 1);
                    asm.invokeInterface(wPutShort, 1);
                    continue block56;
                }
                case 4: {
                    asm.aload(2);
                    asm.aload(0);
                    asm.getfield(firstFieldIndex + i2 * 3);
                    asm.aload(1);
                    asm.invokeInterface(fGetChar, 1);
                    asm.invokeInterface(wPutChar, 1);
                    continue block56;
                }
                case 1: {
                    asm.aload(2);
                    asm.aload(0);
                    asm.getfield(firstFieldIndex + i2 * 3);
                    asm.aload(1);
                    asm.invokeInterface(fGetBool, 1);
                    asm.invokeInterface(wPutBool, 1);
                    continue block56;
                }
                case 9: {
                    asm.aload(2);
                    asm.aload(0);
                    asm.getfield(firstFieldIndex + i2 * 3);
                    asm.aload(1);
                    asm.invokeInterface(fGetFloat, 1);
                    asm.invokeInterface(wPutFloat, 1);
                    continue block56;
                }
                case 10: {
                    asm.aload(2);
                    asm.aload(0);
                    asm.getfield(firstFieldIndex + i2 * 3);
                    asm.aload(1);
                    asm.invokeInterface(fGetDouble, 1);
                    asm.invokeInterface(wPutDouble, 2);
                    continue block56;
                }
                case 11: {
                    asm.aload(2);
                    asm.aload(0);
                    asm.getfield(firstFieldIndex + i2 * 3);
                    asm.aload(1);
                    asm.invokeInterface(fGetStr, 1);
                    if (fnStrAsVarchar) {
                        asm.invokeInterface(wPutStrAsVarchar, 1);
                        continue block56;
                    }
                    asm.invokeInterface(wPutStr, 1);
                    continue block56;
                }
                case 26: {
                    asm.aload(2);
                    asm.aload(0);
                    asm.getfield(firstFieldIndex + i2 * 3);
                    asm.aload(1);
                    asm.invokeInterface(fGetVarchar, 1);
                    asm.invokeInterface(wPutVarchar, 1);
                    continue block56;
                }
                case 18: {
                    asm.aload(2);
                    asm.aload(0);
                    asm.getfield(firstFieldIndex + i2 * 3);
                    asm.aload(1);
                    asm.invokeInterface(fGetBin, 1);
                    asm.invokeInterface(wPutBin, 1);
                    continue block56;
                }
                case 13: {
                    asm.aload(2);
                    asm.aload(0);
                    asm.getfield(firstFieldIndex + i2 * 3);
                    asm.aload(1);
                    asm.invokeInterface(fGetLong256, 1);
                    asm.invokeInterface(wPutLong256, 1);
                    continue block56;
                }
                case 22: {
                    asm.aload(2);
                    asm.aload(0);
                    asm.getfield(firstFieldIndex + i2 * 3);
                    asm.aload(1);
                    asm.invokeInterface(fGetRecord, 1);
                    asm.invokeInterface(wPutRecord, 1);
                    continue block56;
                }
                case 14: {
                    asm.aload(2);
                    asm.aload(0);
                    asm.getfield(firstFieldIndex + i2 * 3);
                    asm.aload(1);
                    asm.invokeInterface(fGetGeoByte, 1);
                    asm.invokeInterface(wPutByte, 1);
                    continue block56;
                }
                case 15: {
                    asm.aload(2);
                    asm.aload(0);
                    asm.getfield(firstFieldIndex + i2 * 3);
                    asm.aload(1);
                    asm.invokeInterface(fGetGeoShort, 1);
                    asm.invokeInterface(wPutShort, 1);
                    continue block56;
                }
                case 16: {
                    asm.aload(2);
                    asm.aload(0);
                    asm.getfield(firstFieldIndex + i2 * 3);
                    asm.aload(1);
                    asm.invokeInterface(fGetGeoInt, 1);
                    asm.invokeInterface(wPutInt, 1);
                    continue block56;
                }
                case 17: {
                    asm.aload(2);
                    asm.aload(0);
                    asm.getfield(firstFieldIndex + i2 * 3);
                    asm.aload(1);
                    asm.invokeInterface(fGetGeoLong, 1);
                    asm.invokeInterface(wPutLong, 2);
                    continue block56;
                }
                case 19: 
                case 24: {
                    asm.aload(2);
                    asm.aload(0);
                    asm.getfield(firstFieldIndex + i2 * 3);
                    asm.aload(1);
                    asm.invokeInterface(fGetLong128Lo, 1);
                    asm.aload(0);
                    asm.getfield(firstFieldIndex + i2 * 3);
                    asm.aload(1);
                    asm.invokeInterface(fGetLong128Hi, 1);
                    asm.invokeInterface(wPutLong128, 4);
                    continue block56;
                }
                case 32: {
                    asm.aload(2);
                    asm.aload(0);
                    asm.getfield(firstFieldIndex + i2 * 3);
                    asm.aload(1);
                    asm.invokeInterface(fGetInterval, 1);
                    asm.invokeInterface(wPutInterval, 1);
                    continue block56;
                }
                case 27: {
                    asm.aload(2);
                    asm.aload(0);
                    asm.getfield(firstFieldIndex + i2 * 3);
                    asm.aload(1);
                    asm.invokeInterface(fGetArray, 1);
                    asm.invokeInterface(wPutArray, 1);
                    continue block56;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected function type: " + ColumnType.nameOf(type));
                }
            }
        }
        asm.return_();
        asm.endMethodCode();
        asm.putShort(0);
        asm.putShort(0);
        asm.endMethod();
        RecordSinkFactory.generateSetFunctions(asm, functionSize, firstFieldIndex, setFunctionsIndex, setFunctionsSigIndex, getIndex);
        asm.putShort(0);
        return asm.loadClass();
    }

    private static int getSkewedIndex(int src, @Nullable IntList skewIndex) {
        if (skewIndex == null) {
            return src;
        }
        return skewIndex.getQuick(src);
    }
}

