/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoColumn;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoTable;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnVersionReader;
import io.questdb.cairo.MetadataCacheReader;
import io.questdb.cairo.MetadataCacheWriter;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriterMetadata;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCMR;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.FlyweightMessageContainer;
import io.questdb.std.Misc;
import io.questdb.std.ObjHashSet;
import io.questdb.std.ObjList;
import io.questdb.std.QuietCloseable;
import io.questdb.std.SimpleReadWriteLock;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetadataCache
implements QuietCloseable {
    private static final Log LOG = LogFactory.getLog(MetadataCache.class);
    private static final Comparator<CairoColumn> comparator = Comparator.comparingInt(CairoColumn::getPosition);
    private final MetadataCacheReaderImpl cacheReader = new MetadataCacheReaderImpl();
    private final MetadataCacheWriterImpl cacheWriter = new MetadataCacheWriterImpl();
    private final CairoEngine engine;
    private final SimpleReadWriteLock rwLock = new SimpleReadWriteLock();
    private final CharSequenceObjHashMap<CairoTable> tableMap = new CharSequenceObjHashMap();
    private ColumnVersionReader columnVersionReader;
    private MemoryCMR metaMem = Vm.getCMRInstance();
    private long version;

    public MetadataCache(CairoEngine engine) {
        this.engine = engine;
    }

    @Override
    public void close() {
        this.metaMem = Misc.free(this.metaMem);
        this.tableMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStartupAsyncHydrator() {
        try {
            ObjHashSet<TableToken> tableTokensSet = new ObjHashSet<TableToken>();
            this.engine.getTableTokens(tableTokensSet, false);
            ObjList<TableToken> tableTokens = tableTokensSet.getList();
            LOG.info().$("metadata hydration started [tables=").$(tableTokens.size()).I$();
            int n = tableTokens.size();
            for (int i = 0; i < n; ++i) {
                try (MetadataCacheWriter ignore = this.writeLock();){
                    this.hydrateTableStartup(tableTokens.getQuick(i), false);
                    continue;
                }
            }
            try (MetadataCacheReader metadataRO = this.readLock();){
                LOG.info().$("metadata hydration completed [tables=").$(metadataRO.getTableCount()).I$();
            }
        }
        catch (CairoException e) {
            LogRecord l = e.isCritical() ? LOG.critical() : LOG.error();
            l.$safe(e.getFlyweightMessage()).$();
        }
        finally {
            Path.clearThreadLocals();
        }
    }

    public MetadataCacheReader readLock() {
        this.rwLock.readLock().lock();
        return this.cacheReader;
    }

    public MetadataCacheWriter writeLock() {
        this.rwLock.writeLock().lock();
        ++this.version;
        return this.cacheWriter;
    }

    @NotNull
    private ColumnVersionReader getColumnVersionReader() {
        if (this.columnVersionReader != null) {
            return this.columnVersionReader;
        }
        this.columnVersionReader = new ColumnVersionReader();
        return this.columnVersionReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hydrateTableStartup(@NotNull TableToken token, boolean throwError) {
        if (this.engine.isTableDropped(token)) {
            return;
        }
        Path path = Path.getThreadLocal(this.engine.getConfiguration().getDbRoot());
        path.concat(token.getDirName());
        boolean isSoftLink = Files.isSoftLink(path.$());
        path.concat("_meta").trimTo(path.size());
        CairoTable table = new CairoTable(token);
        try {
            this.metaMem.smallFile(this.engine.getConfiguration().getFilesFacade(), path.$(), 63);
            TableUtils.validateMeta(this.metaMem, null, 426);
            table.setMetadataVersion(Long.MIN_VALUE);
            long metadataVersion = this.metaMem.getLong(32L);
            CairoTable potentiallyExistingTable = this.tableMap.get(token.getTableName());
            if (potentiallyExistingTable != null && potentiallyExistingTable.getMetadataVersion() > metadataVersion) {
                LOG.debug().$("table in cache with newer version [table=").$(token).$(", version=").$(potentiallyExistingTable.getMetadataVersion()).I$();
                return;
            }
            int columnCount = this.metaMem.getInt(0L);
            LOG.debug().$("reading columns [table=").$(token).$(", count=").$(columnCount).I$();
            table.setMetadataVersion(metadataVersion);
            LOG.debug().$("set metadata version [table=").$(token).$(", version=").$(metadataVersion).I$();
            table.setPartitionBy(this.metaMem.getInt(4L));
            table.setMaxUncommittedRows(this.metaMem.getInt(20L));
            table.setO3MaxLag(this.metaMem.getLong(24L));
            int timestampWriterIndex = this.metaMem.getInt(8L);
            table.setTimestampIndex(-1);
            table.setTtlHoursOrMonths(TableUtils.getTtlHoursOrMonths(this.metaMem));
            table.setSoftLinkFlag(isSoftLink);
            TableUtils.buildColumnListFromMetadataFile(this.metaMem, columnCount, table.columnOrderList);
            boolean isMetaFormatUpToDate = TableUtils.isMetaFormatUpToDate(this.metaMem);
            int n = table.columnOrderList.size();
            for (int i = 0; i < n; i += 3) {
                int writerIndex = table.columnOrderList.get(i);
                if (writerIndex < 0) continue;
                CharSequence name = this.metaMem.getStrA(table.columnOrderList.get(i + 1));
                assert (name != null);
                int columnType = TableUtils.getColumnType(this.metaMem, writerIndex);
                if (columnType < 0) continue;
                String columnName = Chars.toString(name);
                CairoColumn column = new CairoColumn();
                LOG.debug().$("hydrating column [table=").$(token).$(", column=").$safe(columnName).I$();
                column.setName(columnName);
                column.setPosition(table.getColumnCount());
                column.setType(columnType);
                column.setIndexedFlag(TableUtils.isColumnIndexed(this.metaMem, writerIndex));
                column.setIndexBlockCapacity(TableUtils.getIndexBlockCapacity(this.metaMem, writerIndex));
                column.setSymbolTableStaticFlag(true);
                column.setDedupKeyFlag(TableUtils.isColumnDedupKey(this.metaMem, writerIndex));
                column.setWriterIndex(writerIndex);
                boolean isDesignated = writerIndex == timestampWriterIndex;
                column.setDesignatedFlag(isDesignated);
                if (isDesignated) {
                    table.setTimestampIndex(table.getColumnCount());
                }
                if (column.isDedupKey()) {
                    table.setDedupFlag(true);
                }
                if (columnType == 12) {
                    if (isMetaFormatUpToDate) {
                        column.setSymbolCapacity(TableUtils.getSymbolCapacity(this.metaMem, writerIndex));
                        column.setSymbolCached(TableUtils.isSymbolCached(this.metaMem, writerIndex));
                    } else {
                        LOG.debug().$("updating symbol capacity [table=").$(token).$(", column=").$safe(columnName).I$();
                        this.loadCapacities(column, token, path, this.engine.getConfiguration(), this.getColumnVersionReader());
                    }
                }
                table.upsertColumn(column);
            }
            this.tableMap.put(table.getTableName(), table);
            LOG.debug().$("hydrated metadata [table=").$(token).I$();
        }
        catch (Throwable e) {
            this.tableMap.remove(token.getTableName());
            LogRecord log = this.engine.isTableDropped(token) ? LOG.info() : LOG.critical();
            try {
                log.$("could not hydrate metadata [table=").$(token).$(", msg=");
                if (e instanceof FlyweightMessageContainer) {
                    log.$safe(((FlyweightMessageContainer)((Object)e)).getFlyweightMessage());
                } else {
                    log.$safe(e.getMessage());
                }
                log.$(", errno=").$(e instanceof CairoException ? ((CairoException)e).errno : 0);
            }
            finally {
                log.I$();
            }
            if (throwError) {
                throw e;
            }
        }
        finally {
            Misc.free(this.metaMem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCapacities(CairoColumn column, TableToken token, Path path, CairoConfiguration configuration, ColumnVersionReader columnVersionReader) {
        block21: {
            CharSequence columnName = column.getName();
            int writerIndex = column.getWriterIndex();
            try (ColumnVersionReader columnVersionReader2 = columnVersionReader;){
                byte isCached;
                int capacity;
                long columnNameTxn;
                LOG.debug().$("hydrating symbol metadata [table=").$(token).$(", column=").$safe(columnName).I$();
                path.trimTo(configuration.getDbRoot().length()).concat(token);
                int rootLen = path.size();
                path.concat("_cv");
                FilesFacade ff = configuration.getFilesFacade();
                try (ColumnVersionReader columnVersionReader3 = columnVersionReader;){
                    columnVersionReader.ofRO(ff, path.$());
                    columnVersionReader.readUnsafe();
                    columnNameTxn = columnVersionReader.getDefaultColumnNameTxn(writerIndex);
                }
                long capacityOffset = 0L;
                LPSZ offsetFileName = TableUtils.offsetFileName(path.trimTo(rootLen), columnName, columnNameTxn);
                long fd = TableUtils.openRO(ff, offsetFileName, LOG);
                try {
                    capacity = ff.readNonNegativeInt(fd, 0L);
                    isCached = ff.readNonNegativeByte(fd, 4L);
                }
                finally {
                    ff.close(fd);
                }
                if (capacity > 0 && isCached >= 0) {
                    column.setSymbolCapacity(capacity);
                    column.setSymbolCached(isCached != 0);
                    break block21;
                }
                if (capacity <= 0) {
                    throw CairoException.nonCritical().put("invalid capacity [table=").put(token.getTableName()).put(", column=").put(columnName).put(", capacityOffset=").put(0L).put(", capacity=").put(capacity).put(']');
                }
                throw CairoException.nonCritical().put("invalid cache flag [table=").put(token.getTableName()).put(", column=").put(columnName).put(", cacheFlagOffset=").put(4L).put(", cacheFlag=").put(isCached).put(']');
            }
            catch (CairoException ex) {
                LOG.error().$("could not load symbol metadata [table=").$(token).$(", column=").$safe(columnName).$(", errno=").$(ex.getErrno()).$(", message=").$safe(ex.getMessage()).I$();
            }
        }
    }

    private class MetadataCacheReaderImpl
    implements MetadataCacheReader,
    QuietCloseable {
        private MetadataCacheReaderImpl() {
        }

        @Override
        public void close() {
            MetadataCache.this.rwLock.readLock().unlock();
        }

        @Override
        @Nullable
        public CairoTable getTable(@NotNull TableToken tableToken) {
            return MetadataCache.this.tableMap.get(tableToken.getTableName());
        }

        @Override
        public int getTableCount() {
            return MetadataCache.this.tableMap.size();
        }

        @Override
        public long getVersion() {
            return MetadataCache.this.version;
        }

        @Override
        public boolean isVisibleTable(@NotNull CharSequence tableName) {
            CairoConfiguration configuration = MetadataCache.this.engine.getConfiguration();
            if (Chars.startsWith(tableName, configuration.getSystemTableNamePrefix())) {
                return false;
            }
            if (configuration.getTelemetryConfiguration().hideTables() && (Chars.equals(tableName, (CharSequence)"telemetry") || Chars.equals(tableName, (CharSequence)"telemetry_config"))) {
                return false;
            }
            if (Chars.equals(tableName, (CharSequence)"_query_trace")) {
                return false;
            }
            return TableUtils.isFinalTableName((String)tableName, configuration.getTempRenamePendingTablePrefix());
        }

        @Override
        public long snapshot(CharSequenceObjHashMap<CairoTable> localCache, long priorVersion) {
            int i;
            if (priorVersion >= this.getVersion()) {
                return priorVersion;
            }
            for (i = MetadataCache.this.tableMap.size() - 1; i >= 0; --i) {
                CairoTable latestTable = MetadataCache.this.tableMap.getAt(i);
                CairoTable cachedTable = localCache.get(latestTable.getTableName());
                if (cachedTable != null && cachedTable.getMetadataVersion() >= latestTable.getMetadataVersion() && cachedTable.getTableToken().getTableId() == latestTable.getTableToken().getTableId() || !this.isVisibleTable(latestTable.getTableName())) continue;
                localCache.put(latestTable.getTableName(), latestTable);
            }
            for (i = localCache.size() - 1; i >= 0; --i) {
                CairoTable cachedTable = localCache.getAt(i);
                CairoTable latestTable = MetadataCache.this.tableMap.get(cachedTable.getTableName());
                if (latestTable != null) continue;
                localCache.remove(cachedTable.getTableName());
            }
            return MetadataCache.this.version;
        }

        @Override
        public void toSink(@NotNull CharSink<?> sink) {
            sink.put("MetadataCache [");
            sink.put("tableCount=").put(MetadataCache.this.tableMap.size()).put(']');
            sink.put('\n');
            int n = MetadataCache.this.tableMap.size();
            for (int i = 0; i < n; ++i) {
                sink.put('\t');
                MetadataCache.this.tableMap.getAt(i).toSink(sink);
                sink.put('\n');
            }
        }
    }

    private class MetadataCacheWriterImpl
    extends MetadataCacheReaderImpl
    implements MetadataCacheWriter {
        private MetadataCacheWriterImpl() {
        }

        @Override
        public void clearCache() {
            MetadataCache.this.tableMap.clear();
        }

        @Override
        public void close() {
            MetadataCache.this.rwLock.writeLock().unlock();
        }

        @Override
        public void dropTable(@NotNull TableToken tableToken) {
            String tableName = tableToken.getTableName();
            CairoTable entry = MetadataCache.this.tableMap.get(tableName);
            if (entry != null && tableToken.equals(entry.getTableToken())) {
                MetadataCache.this.tableMap.remove(tableName);
                LOG.info().$("dropped [table=").$safe(tableName).I$();
            }
        }

        @Override
        public void hydrateTable(@NotNull TableWriterMetadata tableMetadata) {
            int i;
            if (MetadataCache.this.engine.isTableDropped(tableMetadata.getTableToken())) {
                return;
            }
            TableToken tableToken = tableMetadata.getTableToken();
            CairoTable table = new CairoTable(tableToken);
            long metadataVersion = tableMetadata.getMetadataVersion();
            table.setMetadataVersion(metadataVersion);
            LOG.debug().$("set metadata version [table=").$(tableToken).$(", version=").$(metadataVersion).I$();
            CairoTable potentiallyExistingTable = MetadataCache.this.tableMap.get(tableToken.getTableName());
            if (potentiallyExistingTable != null && potentiallyExistingTable.getMetadataVersion() > metadataVersion) {
                LOG.info().$("table in cache with newer version [table=").$(tableToken).$(", version=").$(potentiallyExistingTable.getMetadataVersion()).I$();
                return;
            }
            int columnCount = tableMetadata.getColumnCount();
            LOG.debug().$("reading columns [table=").$(tableToken).$(", count=").$(columnCount).I$();
            table.setPartitionBy(tableMetadata.getPartitionBy());
            table.setMaxUncommittedRows(tableMetadata.getMaxUncommittedRows());
            table.setO3MaxLag(tableMetadata.getO3MaxLag());
            int timestampWriterIndex = tableMetadata.getTimestampIndex();
            table.setTimestampIndex(-1);
            table.setTtlHoursOrMonths(tableMetadata.getTtlHoursOrMonths());
            Path tempPath = Path.getThreadLocal(MetadataCache.this.engine.getConfiguration().getDbRoot());
            table.setSoftLinkFlag(Files.isSoftLink(tempPath.concat(tableToken.getDirNameUtf8()).$()));
            for (i = 0; i < columnCount; ++i) {
                TableColumnMetadata columnMetadata = tableMetadata.getColumnMetadata(i);
                int columnType = columnMetadata.getColumnType();
                if (columnType < 0) continue;
                String columnName = columnMetadata.getColumnName();
                LOG.debug().$("hydrating column [table=").$(tableToken).$(", column=").$safe(columnName).I$();
                CairoColumn column = new CairoColumn();
                column.setName(columnName);
                column.setType(columnType);
                int replacingIndex = columnMetadata.getReplacingIndex();
                column.setPosition(replacingIndex > -1 ? replacingIndex : i);
                column.setIndexedFlag(columnMetadata.isSymbolIndexFlag());
                column.setIndexBlockCapacity(columnMetadata.getIndexValueBlockCapacity());
                column.setSymbolTableStaticFlag(columnMetadata.isSymbolTableStatic());
                column.setDedupKeyFlag(columnMetadata.isDedupKeyFlag());
                int writerIndex = columnMetadata.getWriterIndex();
                column.setWriterIndex(writerIndex);
                boolean isDesignated = writerIndex == timestampWriterIndex;
                column.setDesignatedFlag(isDesignated);
                if (isDesignated) {
                    table.setTimestampIndex(table.getColumnCount());
                }
                if (column.isDedupKey()) {
                    table.setDedupFlag(true);
                }
                if (ColumnType.isSymbol(column.getType())) {
                    LOG.debug().$("hydrating symbol metadata [table=").$(tableToken).$(", column=").$safe(columnName).I$();
                    column.setSymbolCapacity(tableMetadata.getSymbolCapacity(i));
                    column.setSymbolCached(tableMetadata.getSymbolCacheFlag(i));
                }
                table.upsertColumn(column);
            }
            table.columns.sort(comparator);
            int n = table.columns.size();
            for (i = 0; i < n; ++i) {
                table.columns.getQuick(i).setPosition(i);
                table.columnNameIndexMap.put(table.columns.getQuick(i).getName(), i);
            }
            MetadataCache.this.tableMap.put(table.getTableName(), table);
            LOG.info().$("hydrated [table=").$(table.getTableToken()).I$();
        }

        @Override
        public void hydrateTable(@NotNull TableToken token) {
            MetadataCache.this.hydrateTableStartup(token, true);
        }

        @Override
        public void renameTable(@NotNull TableToken fromTableToken, @NotNull TableToken toTableToken) {
            String tableName = fromTableToken.getTableName();
            int index = MetadataCache.this.tableMap.keyIndex(tableName);
            if (index < 0) {
                CairoTable fromTab = MetadataCache.this.tableMap.valueAt(index);
                MetadataCache.this.tableMap.removeAt(index);
                MetadataCache.this.tableMap.put(toTableToken.getTableName(), new CairoTable(toTableToken, fromTab));
            }
        }
    }
}

