/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.TableToken;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.std.FilesFacade;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class GrowOnlyTableNameRegistryStore
implements Closeable {
    public static final int OPERATION_ADD = 0;
    public static final int OPERATION_REMOVE = -1;
    protected static final long TABLE_NAME_ENTRY_RESERVED_LONGS = 8L;
    protected final MemoryMARW tableNameMemory = Vm.getCMARWInstance();
    private final FilesFacade ff;

    public GrowOnlyTableNameRegistryStore(FilesFacade ff) {
        this.ff = ff;
    }

    @Override
    public void close() {
        this.tableNameMemory.close(false);
    }

    public synchronized void logAddTable(TableToken tableToken) {
        this.writeEntry(tableToken, 0);
        this.tableNameMemory.sync(false);
    }

    public synchronized void logDropTable(TableToken tableToken) {
        this.writeEntry(tableToken, -1);
        this.tableNameMemory.sync(false);
    }

    public GrowOnlyTableNameRegistryStore of(Path rootPath, int version) {
        rootPath.concat("tables.d").putAscii('.').put(version);
        this.tableNameMemory.smallFile(this.ff, rootPath.$(), 0);
        this.tableNameMemory.putLong(0L);
        return this;
    }

    protected void writeEntry(TableToken tableToken, int operation) {
        this.tableNameMemory.putInt(operation);
        this.tableNameMemory.putStr(tableToken.getTableName());
        this.tableNameMemory.putStr(tableToken.getDirName());
        this.tableNameMemory.putInt(tableToken.getTableId());
        int tableType = tableToken.isMatView() ? 2 : (tableToken.isWal() ? 1 : 0);
        this.tableNameMemory.putInt(tableType);
        if (operation != -1) {
            int i = 0;
            while ((long)i < 8L) {
                this.tableNameMemory.putLong(0L);
                ++i;
            }
        }
        this.tableNameMemory.putLong(0L, this.tableNameMemory.getAppendOffset());
    }
}

