/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8Sequence;

public class GeoHashes {
    public static final byte BYTE_NULL = -1;
    public static final int INT_NULL = -1;
    public static final int MAX_STRING_LENGTH = 12;
    public static final long NULL = -1L;
    public static final short SHORT_NULL = -1;
    static final byte[] base32Indexes = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, -1, 17, 18, -1, 19, 20, -1, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, -1, 17, 18, -1, 19, 20, -1, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, -1, -1, -1, -1, -1};
    private static final char[] base32 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    public static void addNormalizedGeoPrefix(long hash, int prefixType, int columnType, LongList prefixes) throws NumericException {
        int bits = ColumnType.getGeoHashBits(prefixType);
        int columnSize = ColumnType.sizeOf(columnType);
        int columnBits = ColumnType.getGeoHashBits(columnType);
        if (hash == -1L || bits > columnBits) {
            throw NumericException.INSTANCE;
        }
        int shift = columnBits - bits;
        long norm = hash << shift;
        long mask = GeoHashes.bitmask(bits, shift);
        prefixes.add(norm);
        prefixes.add(mask |= 1L << columnSize * 8 - 1);
    }

    public static void append(long hash, int bits, CharSink<?> sink) {
        if (hash == -1L) {
            sink.putAscii("null");
        } else {
            sink.putAscii('\"');
            if (bits < 0) {
                GeoHashes.appendCharsUnsafe(hash, -bits, sink);
            } else {
                GeoHashes.appendBinaryStringUnsafe(hash, bits, sink);
            }
            sink.putAscii('\"');
        }
    }

    public static void appendBinary(long hash, int bits, CharSink<?> sink) {
        if (hash != -1L) {
            GeoHashes.appendBinaryStringUnsafe(hash, bits, sink);
        }
    }

    public static void appendBinaryStringUnsafe(long hash, int bits, CharSink<?> sink) {
        assert (bits > 0 && bits <= 60);
        for (int i = bits - 1; i >= 0; --i) {
            sink.putAscii((hash >> i & 1L) == 1L ? (char)'1' : '0');
        }
    }

    public static void appendChars(long hash, int chars, CharSink<?> sink) {
        if (hash != -1L) {
            GeoHashes.appendCharsUnsafe(hash, chars, sink);
        }
    }

    public static void appendCharsUnsafe(long hash, int chars, CharSink<?> sink) {
        assert (chars > 0 && chars <= 12);
        for (int i = chars - 1; i >= 0; --i) {
            sink.putAscii(base32[(int)(hash >> i * 5 & 0x1FL)]);
        }
    }

    public static void appendNoQuotes(long hash, int bits, CharSink<?> sink) {
        if (hash == -1L) {
            sink.putAscii("null");
        } else if (bits < 0) {
            GeoHashes.appendCharsUnsafe(hash, -bits, sink);
        } else {
            GeoHashes.appendBinaryStringUnsafe(hash, bits, sink);
        }
    }

    public static long bitmask(int count, int shift) {
        return (1L << count) - 1L << shift;
    }

    public static byte encodeByte(byte b) {
        return base32Indexes[b > 47 && b < 123 ? b - 48 : 11];
    }

    public static byte encodeChar(char c) {
        return base32Indexes[c > '/' && c < '{' ? c - 48 : 11];
    }

    public static long fromAscii(Utf8Sequence hash, int start, int end) throws NumericException {
        long geohash = 0L;
        for (int i = start; i < end; ++i) {
            geohash = GeoHashes.appendByte(geohash, GeoHashes.encodeByte(hash.byteAt(i)));
        }
        return geohash;
    }

    public static long fromAsciiTruncatingNl(long lo, long hi, int bits) throws NumericException {
        long p;
        if (lo == hi) {
            return -1L;
        }
        int byteCount = Math.min((int)(hi - lo), 12);
        int actualBits = 5 * byteCount;
        if (actualBits < bits || bits == 0) {
            throw NumericException.INSTANCE;
        }
        long geohash = 0L;
        long limit = p + (long)byteCount;
        for (p = lo; p < limit; ++p) {
            geohash = GeoHashes.appendByte(geohash, GeoHashes.encodeByte(Unsafe.getUnsafe().getByte(p)));
        }
        return GeoHashes.widen(geohash, actualBits, bits);
    }

    public static long fromBitString(CharSequence bits, int start) throws NumericException {
        return GeoHashes.fromBitString(bits, start, Math.min(bits.length(), 60 + start));
    }

    public static long fromBitStringNl(CharSequence bits, int start) throws NumericException {
        int len = bits.length();
        if (len - start <= 0) {
            return -1L;
        }
        return GeoHashes.fromBitString(bits, start, Math.min(bits.length(), 60 + start));
    }

    public static long fromCoordinatesDeg(double lat, double lon, int bits) throws NumericException {
        if (lat < -90.0 || lat > 90.0) {
            throw NumericException.INSTANCE;
        }
        if (lon < -180.0 || lon > 180.0) {
            throw NumericException.INSTANCE;
        }
        if (bits < 0 || bits > 60) {
            throw NumericException.INSTANCE;
        }
        return GeoHashes.fromCoordinatesDegUnsafe(lat, lon, bits);
    }

    public static long fromCoordinatesDegUnsafe(double lat, double lon, int bits) {
        long latq = (long)Math.scalb((lat + 90.0) / 180.0, 32);
        long lngq = (long)Math.scalb((lon + 180.0) / 360.0, 32);
        return Numbers.interleaveBits(latq, lngq) >>> 64 - bits;
    }

    public static long fromString(CharSequence hash) throws NumericException {
        return GeoHashes.fromString(hash, 0, hash.length());
    }

    public static long fromString(CharSequence hash, int start, int end) throws NumericException {
        long geohash = 0L;
        for (int i = start; i < end; ++i) {
            geohash = GeoHashes.appendByte(geohash, GeoHashes.encodeChar(hash.charAt(i)));
        }
        return geohash;
    }

    public static long fromStringNl(CharSequence geohash, int start, int length) throws NumericException {
        if (length <= 0 || geohash == null || geohash.length() == 0) {
            return -1L;
        }
        return GeoHashes.fromString(geohash, start, start + Math.min(length, 12));
    }

    public static long fromStringTruncatingNl(CharSequence hash, int start, int end, int toBits) throws NumericException {
        if (start == end) {
            return -1L;
        }
        int chars = Math.min(end - start, 12);
        int fromBits = 5 * chars;
        if (fromBits < toBits) {
            throw NumericException.INSTANCE;
        }
        return GeoHashes.widen(GeoHashes.fromString(hash, start, start + chars), fromBits, toBits);
    }

    public static int getBitFlags(int columnType) {
        if (!ColumnType.isGeoHash(columnType)) {
            return 0;
        }
        int bits = ColumnType.getGeoHashBits(columnType);
        if (bits > 0 && bits % 5 == 0) {
            return -bits / 5;
        }
        return bits;
    }

    public static long getGeoLong(int type, Function func, Record rec) {
        switch (ColumnType.tagOf(type)) {
            case 14: {
                return func.getGeoByte(rec);
            }
            case 15: {
                return func.getGeoShort(rec);
            }
            case 16: {
                return func.getGeoInt(rec);
            }
        }
        return func.getGeoLong(rec);
    }

    public static boolean isValidBits(CharSequence tok, int start) {
        int len = tok.length();
        for (int i = start; i < len; ++i) {
            char idx = tok.charAt(i);
            if (idx >= '0' && idx <= '1') continue;
            return false;
        }
        return start < len;
    }

    public static boolean isValidChars(CharSequence tok, int start) {
        int len = tok.length();
        for (int i = start; i < len; ++i) {
            char c = tok.charAt(i);
            if (GeoHashes.encodeChar(c) != -1) continue;
            return false;
        }
        return start < len;
    }

    public static String toString0(long hash, int columnType) {
        StringSink sink = Misc.getThreadLocalSink();
        if (hash == -1L) {
            return "null";
        }
        sink.put('#');
        int bits = ColumnType.getGeoHashBits(columnType);
        if (bits % 5 == 0) {
            GeoHashes.appendCharsUnsafe(hash, bits / 5, sink);
        } else {
            sink.put('#');
            GeoHashes.appendBinaryStringUnsafe(hash, bits, sink);
        }
        return ((Object)sink).toString();
    }

    public static long widen(long hash, int fromBits, int toBits) {
        return hash >> fromBits - toBits;
    }

    private static long appendByte(long hash, byte idx) throws NumericException {
        if (idx > -1) {
            return hash << 5 | (long)idx;
        }
        throw NumericException.INSTANCE;
    }

    private static long fromBitString(CharSequence bits, int start, int limit) throws NumericException {
        long result = 0L;
        block4: for (int i = start; i < limit; ++i) {
            switch (bits.charAt(i)) {
                case '0': {
                    result <<= 1;
                    continue block4;
                }
                case '1': {
                    result = result << 1 | 1L;
                    continue block4;
                }
                default: {
                    throw NumericException.INSTANCE;
                }
            }
        }
        return result;
    }
}

