/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.FileEventCallback;
import io.questdb.KqueueAccessor;
import io.questdb.cairo.CairoException;
import io.questdb.std.Files;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.filewatch.FileWatcher;
import io.questdb.std.str.Path;
import io.questdb.std.str.Utf8Sequence;

public class KqueueFileWatcher
extends FileWatcher {
    private final int bufferSize;
    private final long dirFd;
    private final long eventList;
    private final long evtDir;
    private final long evtFile;
    private final long evtPipe;
    private final long fileFd;
    private final long kq;
    private final long readEndFd;
    private final long writeEndFd;

    public KqueueFileWatcher(Utf8Sequence filePath, FileEventCallback callback) {
        super(callback);
        try (Path p = new Path();){
            p.of(filePath);
            this.fileFd = Files.openRO(p.$());
            if (this.fileFd < 0L) {
                throw CairoException.critical(Os.errno()).put("could not open file [path=").put(p).put(']');
            }
            this.dirFd = Files.openRONoCache(p.parent().$());
            if (this.dirFd < 0L) {
                int errno = Os.errno();
                Files.close(this.fileFd);
                throw CairoException.critical(errno).put("could not open directory [path=").put(p).put(']');
            }
        }
        try {
            this.evtFile = KqueueAccessor.evtAlloc(this.fileFd, (int)KqueueAccessor.EVFILT_VNODE, KqueueAccessor.EV_ADD | KqueueAccessor.EV_CLEAR, KqueueAccessor.NOTE_DELETE | KqueueAccessor.NOTE_WRITE | KqueueAccessor.NOTE_ATTRIB | KqueueAccessor.NOTE_EXTEND | KqueueAccessor.NOTE_LINK | KqueueAccessor.NOTE_RENAME | KqueueAccessor.NOTE_REVOKE, 0L);
            if (this.evtFile == 0L) {
                throw CairoException.critical(Os.errno()).put("could not allocate kevent for file");
            }
            this.evtDir = KqueueAccessor.evtAlloc(this.dirFd, (int)KqueueAccessor.EVFILT_VNODE, KqueueAccessor.EV_ADD | KqueueAccessor.EV_CLEAR, KqueueAccessor.NOTE_DELETE | KqueueAccessor.NOTE_WRITE | KqueueAccessor.NOTE_ATTRIB | KqueueAccessor.NOTE_EXTEND | KqueueAccessor.NOTE_LINK | KqueueAccessor.NOTE_RENAME | KqueueAccessor.NOTE_REVOKE, 0L);
            if (this.evtDir == 0L) {
                throw CairoException.critical(Os.errno()).put("could not allocate kevent for directory");
            }
            long fds = KqueueAccessor.pipe();
            if (fds < 0L) {
                throw CairoException.critical(Os.errno()).put("could not create pipe");
            }
            this.readEndFd = Files.createUniqueFd((int)(fds >>> 32));
            this.writeEndFd = Files.createUniqueFd((int)fds);
            this.evtPipe = KqueueAccessor.evtAlloc(this.readEndFd, (int)KqueueAccessor.EVFILT_READ, KqueueAccessor.EV_ADD | KqueueAccessor.EV_CLEAR, 0, 0L);
            this.kq = Files.createUniqueFd(KqueueAccessor.kqueue());
            if (this.kq < 0L) {
                throw CairoException.critical(Os.errno()).put("could create kqueue");
            }
            this.bufferSize = KqueueAccessor.SIZEOF_KEVENT;
            this.eventList = Unsafe.calloc(this.bufferSize, 36);
            int fileRes = KqueueAccessor.keventRegister(this.kq, this.evtFile, 1);
            if (fileRes < 0) {
                throw CairoException.critical(Os.errno()).put("could register file events in kqueue");
            }
            int dirRes = KqueueAccessor.keventRegister(this.kq, this.evtDir, 1);
            if (dirRes < 0) {
                throw CairoException.critical(Os.errno()).put("could register directory events in kqueue");
            }
            int pipeRes = KqueueAccessor.keventRegister(this.kq, this.evtPipe, 1);
            if (pipeRes < 0) {
                throw CairoException.critical(Os.errno()).put("could register pipe events in kqueue");
            }
        }
        catch (RuntimeException e) {
            this.cleanUp();
            throw e;
        }
    }

    private void cleanUp() {
        if (this.kq > 0L) {
            Files.close(this.kq);
        }
        if (this.fileFd > 0L) {
            Files.close(this.fileFd);
        }
        if (this.dirFd > 0L) {
            Files.close(this.dirFd);
        }
        if (this.readEndFd > 0L) {
            Files.close(this.readEndFd);
        }
        if (this.writeEndFd > 0L) {
            Files.close(this.writeEndFd);
        }
        if (this.eventList > 0L) {
            Unsafe.free(this.eventList, this.bufferSize, 36);
        }
        if (this.evtFile > 0L) {
            KqueueAccessor.evtFree(this.evtFile);
        }
        if (this.evtDir > 0L) {
            KqueueAccessor.evtFree(this.evtDir);
        }
        if (this.evtPipe > 0L) {
            KqueueAccessor.evtFree(this.evtPipe);
        }
    }

    @Override
    protected void _close() {
        this.cleanUp();
    }

    @Override
    protected void releaseWait() {
        KqueueAccessor.writePipe(this.writeEndFd);
    }

    @Override
    protected void waitForChange() {
        int res = KqueueAccessor.keventGetBlocking(this.kq, this.eventList, 1);
        if (res < 0) {
            throw CairoException.critical(Os.errno()).put("kevent error");
        }
        this.callback.onFileEvent();
    }
}

