/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.ai.converter.ResponseTextCleaner;
import org.springframework.util.Assert;

public class CompositeResponseTextCleaner
implements ResponseTextCleaner {
    private final List<ResponseTextCleaner> cleaners;

    public CompositeResponseTextCleaner(List<ResponseTextCleaner> cleaners) {
        Assert.notNull(cleaners, (String)"cleaners cannot be null");
        this.cleaners = new ArrayList<ResponseTextCleaner>(cleaners);
    }

    public CompositeResponseTextCleaner() {
        this(new ArrayList<ResponseTextCleaner>());
    }

    public CompositeResponseTextCleaner(ResponseTextCleaner ... cleaners) {
        this(Arrays.asList(cleaners));
    }

    @Override
    public String clean(String text) {
        String result = text;
        for (ResponseTextCleaner cleaner : this.cleaners) {
            result = cleaner.clean(result);
        }
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<ResponseTextCleaner> cleaners = new ArrayList<ResponseTextCleaner>();

        private Builder() {
        }

        public Builder addCleaner(ResponseTextCleaner cleaner) {
            Assert.notNull((Object)cleaner, (String)"cleaner cannot be null");
            this.cleaners.add(cleaner);
            return this;
        }

        public CompositeResponseTextCleaner build() {
            return new CompositeResponseTextCleaner(this.cleaners);
        }
    }
}

