/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.ai.controller;

import com.usthe.sureness.subject.SubjectSum;
import com.usthe.sureness.util.SurenessContextHolder;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.validation.Valid;
import org.apache.hertzbeat.ai.config.McpContextHolder;
import org.apache.hertzbeat.ai.pojo.dto.ChatRequestContext;
import org.apache.hertzbeat.ai.pojo.dto.ChatResponseChunk;
import org.apache.hertzbeat.ai.service.ConversationService;
import org.apache.hertzbeat.common.entity.ai.ChatConversation;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;

@Tag(name="AI Chat API")
@RestController
@RequestMapping(path={"/api/chat"}, produces={"application/json"})
public class ChatController {
    private static final Logger log = LoggerFactory.getLogger(ChatController.class);
    private final ConversationService conversationService;

    @Autowired
    public ChatController(ConversationService conversationService) {
        this.conversationService = conversationService;
    }

    @PostMapping(value={"/stream"}, produces={"text/event-stream"})
    @Operation(summary="Send a chat message with streaming response", description="Send a message to AI and get a streaming response with conversation tracking")
    public Flux<ServerSentEvent<ChatResponseChunk>> streamChat(@Valid @RequestBody ChatRequestContext context) {
        try {
            SubjectSum subject = SurenessContextHolder.getBindSubject();
            McpContextHolder.setSubject(subject);
            if (context.getMessage() == null || context.getMessage().trim().isEmpty()) {
                ChatResponseChunk errorResponse = ChatResponseChunk.builder().conversationId(context.getConversationId()).response("Error: Message cannot be empty").build();
                return Flux.just((Object)ServerSentEvent.builder((Object)errorResponse).event("error").build());
            }
            log.info("Received streaming chat request for conversation: {}", (Object)context.getConversationId());
            return this.conversationService.streamChat(context.getMessage(), context.getConversationId());
        }
        catch (Exception e) {
            log.error("Error in stream chat endpoint: ", (Throwable)e);
            ChatResponseChunk errorResponse = ChatResponseChunk.builder().conversationId(context.getConversationId()).response("An error occurred: " + e.getMessage()).build();
            return Flux.just((Object)ServerSentEvent.builder((Object)errorResponse).event("error").build());
        }
    }

    @PostMapping(path={"/conversations"})
    @Operation(summary="Create a new conversation", description="Create a new conversation")
    public ResponseEntity<Message<ChatConversation>> createConversation() {
        ChatConversation conversation = this.conversationService.createConversation();
        return ResponseEntity.ok((Object)Message.success((Object)conversation));
    }

    @GetMapping(path={"/conversations"})
    @Operation(summary="List all conversations", description="Get a list of all conversations")
    public ResponseEntity<Message<List<ChatConversation>>> listConversations() {
        List<ChatConversation> conversations = this.conversationService.getAllConversations();
        return ResponseEntity.ok((Object)Message.success(conversations));
    }

    @GetMapping(path={"/conversations/{conversationId}"})
    @Operation(summary="Get conversation history", description="Get detailed information and message history for a specific conversation")
    public ResponseEntity<Message<ChatConversation>> getConversation(@Parameter(description="Conversation ID", example="12345678") @PathVariable(value="conversationId") Long conversationId) {
        ChatConversation conversation = this.conversationService.getConversation(conversationId);
        return ResponseEntity.ok((Object)Message.success((Object)conversation));
    }

    @DeleteMapping(path={"/conversations/{conversationId}"})
    @Operation(summary="Delete conversation", description="Delete a specific conversation and all its messages")
    public ResponseEntity<Message<Void>> deleteConversation(@Parameter(description="Conversation ID", example="2345678") @PathVariable(value="conversationId") Long conversationId) {
        this.conversationService.deleteConversation(conversationId);
        return ResponseEntity.ok((Object)Message.success());
    }
}

