/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hertzbeat.alert.dao.AlertInhibitDao;
import org.apache.hertzbeat.alert.reduce.AlarmInhibitReduce;
import org.apache.hertzbeat.alert.service.AlertInhibitService;
import org.apache.hertzbeat.common.entity.alerter.AlertInhibit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional(rollbackFor={Exception.class})
public class AlertInhibitServiceImpl
implements AlertInhibitService {
    private static final Logger log = LoggerFactory.getLogger(AlertInhibitServiceImpl.class);
    @Autowired
    private AlertInhibitDao alertInhibitDao;
    @Autowired
    private AlarmInhibitReduce alarmInhibitReduce;

    @Override
    public void validate(AlertInhibit alertInhibit, boolean isModify) throws IllegalArgumentException {
    }

    @Override
    public void addAlertInhibit(AlertInhibit alertInhibit) throws RuntimeException {
        this.alertInhibitDao.save(alertInhibit);
        this.refreshAlertInhibitsCache();
    }

    @Override
    public void modifyAlertInhibit(AlertInhibit alertInhibit) throws RuntimeException {
        this.alertInhibitDao.save(alertInhibit);
        this.refreshAlertInhibitsCache();
    }

    @Override
    public AlertInhibit getAlertInhibit(long inhibitId) throws RuntimeException {
        return this.alertInhibitDao.findById(inhibitId).orElse(null);
    }

    @Override
    public void deleteAlertInhibits(Set<Long> inhibitIds) throws RuntimeException {
        this.alertInhibitDao.deleteAlertInhibitsByIdIn(inhibitIds);
        this.refreshAlertInhibitsCache();
    }

    @Override
    public Page<AlertInhibit> getAlertInhibits(List<Long> inhibitIds, String search, String sort, String order, int pageIndex, int pageSize) {
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            ArrayList<Object> andList = new ArrayList<Object>();
            if (inhibitIds != null && !inhibitIds.isEmpty()) {
                CriteriaBuilder.In inPredicate = criteriaBuilder.in((Expression)root.get("id"));
                Iterator iterator = inhibitIds.iterator();
                while (iterator.hasNext()) {
                    long id = (Long)iterator.next();
                    inPredicate.value((Object)id);
                }
                andList.add(inPredicate);
            }
            if (StringUtils.hasText((String)search)) {
                Predicate predicate = criteriaBuilder.or(new Predicate[]{criteriaBuilder.like(criteriaBuilder.lower((Expression)root.get("name")), "%" + search.toLowerCase() + "%")});
                andList.add(predicate);
            }
            Predicate[] predicates = new Predicate[andList.size()];
            return criteriaBuilder.and(andList.toArray(predicates));
        };
        Sort sortExp = Sort.by((Sort.Order[])new Sort.Order[]{new Sort.Order(Sort.Direction.fromString((String)order), sort)});
        PageRequest pageRequest = PageRequest.of((int)pageIndex, (int)pageSize, (Sort)sortExp);
        return this.alertInhibitDao.findAll(specification, (Pageable)pageRequest);
    }

    private void refreshAlertInhibitsCache() {
        this.alarmInhibitReduce.refreshInhibitRules(this.alertInhibitDao.findAlertInhibitsByEnableIsTrue());
    }
}

