/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.util;

import cn.afterturn.easypoi.cache.manager.POICacheManager;
import cn.afterturn.easypoi.exception.excel.ExcelExportException;
import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ooxml.POIXMLRelation;
import org.apache.poi.ooxml.POIXMLTypeLoader;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.ImageUtils;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFPictureData;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.xmlbeans.XmlObject;

public class PoiWatermarkUtil {
    public static void putWaterRemarkToExcel(Sheet sheet, String waterRemarkPath, String position) throws Exception {
        int pictureIdx = sheet.getWorkbook().addPicture(IOUtils.toByteArray((InputStream)POICacheManager.getFile(waterRemarkPath)), 6);
        OPCPackage opcpackage = ((XSSFWorkbook)sheet.getWorkbook()).getPackage();
        PackagePartName partname = PackagingURIHelper.createPartName((String)("/xl/drawings/vmlDrawing" + pictureIdx + ".vml"));
        PackagePart part = opcpackage.createPart(partname, "application/vnd.openxmlformats-officedocument.vmlDrawing");
        VmlDrawing vmldrawing = new VmlDrawing(part);
        Header header = sheet.getHeader();
        switch (position) {
            case "LEFT": {
                header.setLeft("&G");
                vmldrawing.setHeaderPos("LH");
                break;
            }
            case "CENTER": {
                header.setCenter("&G");
                vmldrawing.setHeaderPos("CH");
                break;
            }
            case "RIGHT": {
                header.setRight("&G");
                vmldrawing.setHeaderPos("RH");
                break;
            }
            default: {
                throw new ExcelExportException("\u8f93\u5165\u7684position\u53c2\u6570\u4e0d\u5408\u6cd5");
            }
        }
        XSSFPictureData picData = (XSSFPictureData)sheet.getWorkbook().getAllPictures().get(pictureIdx);
        String rIdPic = vmldrawing.addRelation(null, (POIXMLRelation)XSSFRelation.IMAGES, (POIXMLDocumentPart)picData).getRelationship().getId();
        ByteArrayInputStream is = new ByteArrayInputStream(picData.getData());
        Dimension imageDimension = ImageUtils.getImageDimension((InputStream)is, (int)picData.getPictureType());
        IOUtils.closeQuietly((Closeable)is);
        vmldrawing.setRIdPic(rIdPic);
        vmldrawing.setPictureTitle(waterRemarkPath);
        vmldrawing.setImageDimension(imageDimension);
        String rIdExtLink = ((XSSFSheet)sheet).addRelation(null, (POIXMLRelation)XSSFRelation.VML_DRAWINGS, (POIXMLDocumentPart)vmldrawing).getRelationship().getId();
        ((XSSFSheet)sheet).getCTWorksheet().addNewLegacyDrawingHF().setId(rIdExtLink);
    }

    public static void putWaterRemarkToExcel(Sheet sheet, String waterRemarkPath) throws Exception {
        PoiWatermarkUtil.putWaterRemarkToExcel(sheet, waterRemarkPath, "LEFT");
    }

    static class VmlDrawing
    extends POIXMLDocumentPart {
        String rIdPic = "";
        String pictureTitle = "";
        Dimension imageDimension = null;
        String headerPos = "";

        VmlDrawing(PackagePart part) {
            super(part);
        }

        void setRIdPic(String rIdPic) {
            this.rIdPic = rIdPic;
        }

        void setPictureTitle(String pictureTitle) {
            this.pictureTitle = pictureTitle;
        }

        void setHeaderPos(String headerPos) {
            this.headerPos = headerPos;
        }

        void setImageDimension(Dimension imageDimension) {
            this.imageDimension = imageDimension;
        }

        protected void commit() throws IOException {
            PackagePart part = this.getPackagePart();
            OutputStream out = part.getOutputStream();
            try {
                XmlObject doc = XmlObject.Factory.parse((String)("<xml xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:o=\"urn:schemas-microsoft-com:office:office\" xmlns:x=\"urn:schemas-microsoft-com:office:excel\"> <o:shapelayout v:ext=\"edit\">  <o:idmap v:ext=\"edit\" data=\"1\"/> </o:shapelayout><v:shapetype id=\"_x0000_t75\" coordsize=\"21600,21600\" o:spt=\"75\"  o:preferrelative=\"t\" path=\"m@4@5l@4@11@9@11@9@5xe\" filled=\"f\" stroked=\"f\">  <v:stroke joinstyle=\"miter\"/>  <v:formulas>   <v:f eqn=\"if lineDrawn pixelLineWidth 0\"/>   <v:f eqn=\"sum @0 1 0\"/>   <v:f eqn=\"sum 0 0 @1\"/>   <v:f eqn=\"prod @2 1 2\"/>   <v:f eqn=\"prod @3 21600 pixelWidth\"/>   <v:f eqn=\"prod @3 21600 pixelHeight\"/>   <v:f eqn=\"sum @0 0 1\"/>   <v:f eqn=\"prod @6 1 2\"/>   <v:f eqn=\"prod @7 21600 pixelWidth\"/>   <v:f eqn=\"sum @8 21600 0\"/>   <v:f eqn=\"prod @7 21600 pixelHeight\"/>   <v:f eqn=\"sum @10 21600 0\"/>  </v:formulas>  <v:path o:extrusionok=\"f\" gradientshapeok=\"t\" o:connecttype=\"rect\"/>  <o:lock v:ext=\"edit\" aspectratio=\"t\"/> </v:shapetype><v:shape id=\"" + this.headerPos + "\" o:spid=\"_x0000_s1025\" type=\"#_x0000_t75\"  style='position:absolute;margin-left:0;margin-top:0;width:" + (int)this.imageDimension.getWidth() + "px;height:" + (int)this.imageDimension.getHeight() + "px;z-index:1'>  <v:imagedata o:relid=\"" + this.rIdPic + "\" o:title=\"" + this.pictureTitle + "\"/>  <o:lock v:ext=\"edit\" rotation=\"t\"/> </v:shape></xml>"));
                doc.save(out, POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

