/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.structured;

import java.util.Optional;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.logging.structured.StructuredLoggingJsonMembersCustomizer;
import org.springframework.boot.logging.structured.StructuredLoggingJsonProperties;
import org.springframework.core.env.Environment;

class StructuredLoggingJsonMembersCustomizerBeanFactoryInitializationAotProcessor
implements BeanFactoryInitializationAotProcessor {
    private static final String ENVIRONMENT_BEAN_NAME = "environment";

    StructuredLoggingJsonMembersCustomizerBeanFactoryInitializationAotProcessor() {
    }

    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        Environment environment = (Environment)beanFactory.getBean(ENVIRONMENT_BEAN_NAME, Environment.class);
        return Optional.ofNullable(StructuredLoggingJsonProperties.get(environment)).map(StructuredLoggingJsonProperties::customizer).map(AotContribution::new).orElse(null);
    }

    private static final class AotContribution
    implements BeanFactoryInitializationAotContribution {
        private final Class<? extends StructuredLoggingJsonMembersCustomizer<?>> customizer;

        private AotContribution(Class<? extends StructuredLoggingJsonMembersCustomizer<?>> customizer) {
            this.customizer = customizer;
        }

        public void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
            generationContext.getRuntimeHints().reflection().registerType(this.customizer, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS});
        }
    }
}

