/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.Utils;

public class Deserializers<K, V>
implements AutoCloseable {
    public final Deserializer<K> keyDeserializer;
    public final Deserializer<V> valueDeserializer;

    public Deserializers(Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        this.keyDeserializer = Objects.requireNonNull(keyDeserializer, "Key deserializer provided to Deserializers should not be null");
        this.valueDeserializer = Objects.requireNonNull(valueDeserializer, "Value deserializer provided to Deserializers should not be null");
    }

    public Deserializers(ConsumerConfig config) {
        this(config, null, null);
    }

    public Deserializers(ConsumerConfig config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        String clientId = config.getString("client.id");
        if (keyDeserializer == null) {
            this.keyDeserializer = config.getConfiguredInstance("key.deserializer", Deserializer.class);
            this.keyDeserializer.configure(config.originals(Collections.singletonMap("client.id", clientId)), true);
        } else {
            config.ignore("key.deserializer");
            this.keyDeserializer = keyDeserializer;
        }
        if (valueDeserializer == null) {
            this.valueDeserializer = config.getConfiguredInstance("value.deserializer", Deserializer.class);
            this.valueDeserializer.configure(config.originals(Collections.singletonMap("client.id", clientId)), false);
        } else {
            config.ignore("value.deserializer");
            this.valueDeserializer = valueDeserializer;
        }
    }

    @Override
    public void close() {
        AtomicReference<Throwable> firstException = new AtomicReference<Throwable>();
        Utils.closeQuietly(this.keyDeserializer, "key deserializer", firstException);
        Utils.closeQuietly(this.valueDeserializer, "value deserializer", firstException);
        Throwable exception = firstException.get();
        if (exception != null) {
            if (exception instanceof InterruptException) {
                throw (InterruptException)exception;
            }
            throw new KafkaException("Failed to close deserializers", exception);
        }
    }

    public String toString() {
        return "Deserializers{keyDeserializer=" + this.keyDeserializer + ", valueDeserializer=" + this.valueDeserializer + '}';
    }
}

