/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.helix.model.Partition;

public class CustomizedStateOutput {
    private final Map<String, Map<String, Map<Partition, Map<String, String>>>> _customizedStateMap = new HashMap<String, Map<String, Map<Partition, Map<String, String>>>>();
    private final Map<String, Map<String, Map<Partition, Map<String, Long>>>> _startTimeMap = new HashMap<String, Map<String, Map<Partition, Map<String, Long>>>>();

    public void setCustomizedState(String stateType, String resourceName, Partition partition, String instanceName, String state, Long startTime) {
        this.setCurrentState(stateType, resourceName, partition, instanceName, state);
        this.setStartTime(stateType, resourceName, partition, instanceName, startTime);
    }

    private void setCurrentState(String stateType, String resourceName, Partition partition, String instanceName, String state) {
        this._customizedStateMap.computeIfAbsent(stateType, k -> new HashMap()).computeIfAbsent(resourceName, k -> new HashMap()).computeIfAbsent(partition, k -> new HashMap()).put(instanceName, state);
    }

    private void setStartTime(String stateType, String resourceName, Partition partition, String instanceName, Long startTime) {
        this._startTimeMap.computeIfAbsent(stateType, k -> new HashMap()).computeIfAbsent(resourceName, k -> new HashMap()).computeIfAbsent(partition, k -> new HashMap()).put(instanceName, startTime);
    }

    public Map<String, Map<Partition, Map<String, String>>> getCustomizedStateMap(String stateType) {
        if (this._customizedStateMap.containsKey(stateType)) {
            return Collections.unmodifiableMap(this._customizedStateMap.get(stateType));
        }
        return Collections.emptyMap();
    }

    private Map<String, Map<Partition, Map<String, Long>>> getStartTimeMap(String stateType) {
        return this._startTimeMap.getOrDefault(stateType, Collections.emptyMap());
    }

    public Map<Partition, Map<String, String>> getResourceCustomizedStateMap(String stateType, String resourceName) {
        if (this.getCustomizedStateMap(stateType).containsKey(resourceName)) {
            return Collections.unmodifiableMap(this.getCustomizedStateMap(stateType).get(resourceName));
        }
        return Collections.emptyMap();
    }

    public Map<String, String> getPartitionCustomizedStateMap(String stateType, String resourceName, Partition partition) {
        if (this.getCustomizedStateMap(stateType).containsKey(resourceName) && this.getResourceCustomizedStateMap(stateType, resourceName).containsKey(partition)) {
            return Collections.unmodifiableMap(this.getResourceCustomizedStateMap(stateType, resourceName).get(partition));
        }
        return Collections.emptyMap();
    }

    public String getPartitionCustomizedState(String stateType, String resourceName, Partition partition, String instanceName) {
        if (this.getCustomizedStateMap(stateType).containsKey(resourceName) && this.getResourceCustomizedStateMap(stateType, resourceName).containsKey(partition) && this.getPartitionCustomizedStateMap(stateType, resourceName, partition).containsKey(instanceName)) {
            return this.getPartitionCustomizedStateMap(stateType, resourceName, partition).get(instanceName);
        }
        return null;
    }

    public Map<Partition, Map<String, Long>> getResourceStartTimeMap(String stateType, String resourceName) {
        return Collections.unmodifiableMap(this.getStartTimeMap(stateType).getOrDefault(resourceName, Collections.emptyMap()));
    }

    public Set<String> getAllStateTypes() {
        return this._customizedStateMap.keySet();
    }
}

