/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import org.apache.hadoop.hdfs.server.federation.router.RemoteLocationContext;

public class RemoteResult<T extends RemoteLocationContext, R> {
    private final T loc;
    private final R result;
    private final boolean resultSet;
    private final IOException ioe;

    public RemoteResult(T location, R r) {
        this.loc = location;
        this.result = r;
        this.resultSet = true;
        this.ioe = null;
    }

    public RemoteResult(T location, IOException e) {
        this.loc = location;
        this.result = null;
        this.resultSet = false;
        this.ioe = e;
    }

    public T getLocation() {
        return this.loc;
    }

    public boolean hasResult() {
        return this.resultSet;
    }

    public R getResult() {
        return this.result;
    }

    public boolean hasException() {
        return this.getException() != null;
    }

    public IOException getException() {
        return this.ioe;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("loc=").append(this.getLocation());
        if (this.hasResult()) {
            sb.append(" result=").append(this.getResult());
        }
        if (this.hasException()) {
            sb.append(" exception=").append(this.getException());
        }
        return sb.toString();
    }
}

