/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.shaded.parquet.org.apache.thrift;

import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.s3.shaded.parquet.org.apache.thrift.AsyncProcessFunction;
import software.amazon.s3.shaded.parquet.org.apache.thrift.TApplicationException;
import software.amazon.s3.shaded.parquet.org.apache.thrift.TAsyncProcessor;
import software.amazon.s3.shaded.parquet.org.apache.thrift.TBase;
import software.amazon.s3.shaded.parquet.org.apache.thrift.TException;
import software.amazon.s3.shaded.parquet.org.apache.thrift.TProcessor;
import software.amazon.s3.shaded.parquet.org.apache.thrift.async.AsyncMethodCallback;
import software.amazon.s3.shaded.parquet.org.apache.thrift.protocol.TMessage;
import software.amazon.s3.shaded.parquet.org.apache.thrift.protocol.TProtocol;
import software.amazon.s3.shaded.parquet.org.apache.thrift.protocol.TProtocolException;
import software.amazon.s3.shaded.parquet.org.apache.thrift.protocol.TProtocolUtil;
import software.amazon.s3.shaded.parquet.org.apache.thrift.server.AbstractNonblockingServer;

public class TBaseAsyncProcessor<I>
implements TAsyncProcessor,
TProcessor {
    protected final Logger LOGGER = LoggerFactory.getLogger((String)this.getClass().getName());
    final I iface;
    final Map<String, AsyncProcessFunction<I, ? extends TBase, ?>> processMap;

    public TBaseAsyncProcessor(I iface, Map<String, AsyncProcessFunction<I, ? extends TBase, ?>> processMap) {
        this.iface = iface;
        this.processMap = processMap;
    }

    public Map<String, AsyncProcessFunction<I, ? extends TBase, ?>> getProcessMapView() {
        return Collections.unmodifiableMap(this.processMap);
    }

    @Override
    public void process(AbstractNonblockingServer.AsyncFrameBuffer fb) throws TException {
        TProtocol in = fb.getInputProtocol();
        TProtocol out = fb.getOutputProtocol();
        TMessage msg = in.readMessageBegin();
        AsyncProcessFunction<I, TBase, ?> fn = this.processMap.get(msg.name);
        if (fn == null) {
            TProtocolUtil.skip(in, (byte)12);
            in.readMessageEnd();
            TApplicationException x = new TApplicationException(1, "Invalid method name: '" + msg.name + "'");
            this.LOGGER.debug("Invalid method name", (Throwable)x);
            if (msg.type == 1) {
                out.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
                x.write(out);
                out.writeMessageEnd();
                out.getTransport().flush();
            }
            fb.responseReady();
            return;
        }
        TBase args = fn.getEmptyArgsInstance();
        try {
            args.read(in);
        }
        catch (TProtocolException e) {
            in.readMessageEnd();
            TApplicationException x = new TApplicationException(7, e.getMessage());
            this.LOGGER.debug("Could not retrieve function arguments", (Throwable)x);
            if (!fn.isOneway()) {
                out.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
                x.write(out);
                out.writeMessageEnd();
                out.getTransport().flush();
            }
            fb.responseReady();
            return;
        }
        in.readMessageEnd();
        if (fn.isOneway()) {
            fb.responseReady();
        }
        AsyncMethodCallback<?> resultHandler = fn.getResultHandler(fb, msg.seqid);
        try {
            fn.start(this.iface, args, resultHandler);
        }
        catch (Exception e) {
            this.LOGGER.debug("Exception handling function", (Throwable)e);
            resultHandler.onError(e);
        }
    }

    @Override
    public void process(TProtocol in, TProtocol out) throws TException {
    }
}

