/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.common.telemetry;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Clock;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Metric;
import software.amazon.s3.analyticsaccelerator.common.telemetry.MetricMeasurement;
import software.amazon.s3.analyticsaccelerator.common.telemetry.MetricMeasurementKind;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.OperationMeasurement;
import software.amazon.s3.analyticsaccelerator.common.telemetry.OperationSupplier;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryAction;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryDatapointAggregator;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryDatapointMeasurement;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryLevel;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryReporter;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetrySupplier;

public class DefaultTelemetry
implements Telemetry {
    @NonNull
    private final Clock epochClock;
    @NonNull
    private final Clock elapsedClock;
    @NonNull
    private final TelemetryReporter reporter;
    @NonNull
    private final Optional<TelemetryDatapointAggregator> aggregator;
    @NonNull
    private final TelemetryLevel level;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTelemetry.class);

    @Override
    public void flush() {
        this.reporter.flush();
    }

    @Override
    public void close() {
        Telemetry.super.close();
        this.aggregator.ifPresent(TelemetryDatapointAggregator::close);
        this.reporter.close();
    }

    @Override
    public void measure(@NonNull TelemetryLevel level, @NonNull OperationSupplier operationSupplier, @NonNull TelemetryAction operationCode) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        if (operationSupplier == null) {
            throw new NullPointerException("operationSupplier is marked non-null but is null");
        }
        if (operationCode == null) {
            throw new NullPointerException("operationCode is marked non-null but is null");
        }
        if (this.produceTelemetryFor(level)) {
            this.measureImpl(level, (Operation)operationSupplier.apply(), operationCode);
        } else {
            operationCode.apply();
        }
    }

    @Override
    public <T> T measure(@NonNull TelemetryLevel level, @NonNull OperationSupplier operationSupplier, @NonNull TelemetrySupplier<T> operationCode) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        if (operationSupplier == null) {
            throw new NullPointerException("operationSupplier is marked non-null but is null");
        }
        if (operationCode == null) {
            throw new NullPointerException("operationCode is marked non-null but is null");
        }
        if (this.produceTelemetryFor(level)) {
            return this.measureImpl(level, (Operation)operationSupplier.apply(), operationCode);
        }
        return operationCode.apply();
    }

    @Override
    public <T> CompletableFuture<T> measure(@NonNull TelemetryLevel level, @NonNull OperationSupplier operationSupplier, @NonNull CompletableFuture<T> operationCode) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        if (operationSupplier == null) {
            throw new NullPointerException("operationSupplier is marked non-null but is null");
        }
        if (operationCode == null) {
            throw new NullPointerException("operationCode is marked non-null but is null");
        }
        if (this.produceTelemetryFor(level)) {
            return this.measureImpl(level, (Operation)operationSupplier.apply(), operationCode);
        }
        return operationCode;
    }

    @Override
    public <T> T measureConditionally(@NonNull TelemetryLevel level, @NonNull OperationSupplier operationSupplier, @NonNull TelemetrySupplier<T> operationCode, @NonNull Predicate<T> shouldMeasure) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        if (operationSupplier == null) {
            throw new NullPointerException("operationSupplier is marked non-null but is null");
        }
        if (operationCode == null) {
            throw new NullPointerException("operationCode is marked non-null but is null");
        }
        if (shouldMeasure == null) {
            throw new NullPointerException("shouldMeasure is marked non-null but is null");
        }
        if (this.produceTelemetryFor(level)) {
            return this.measureConditionallyImpl(level, (Operation)operationSupplier.apply(), operationCode, shouldMeasure);
        }
        return operationCode.apply();
    }

    private void measureImpl(TelemetryLevel level, @NonNull Operation operation, TelemetryAction operationCode) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        OperationMeasurement.OperationMeasurementBuilder builder = this.startMeasurement(level, operation);
        try {
            operation.getContext().pushOperation(operation);
            operationCode.apply();
            this.completeMeasurement(builder, Optional.empty());
        }
        catch (Exception error) {
            this.completeMeasurement(builder, Optional.of(error));
            throw error;
        }
        finally {
            operation.getContext().popOperation(operation);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T measureImpl(TelemetryLevel level, @NonNull Operation operation, TelemetrySupplier<T> operationCode) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        OperationMeasurement.OperationMeasurementBuilder builder = this.startMeasurement(level, operation);
        try {
            operation.getContext().pushOperation(operation);
            T result = operationCode.apply();
            this.completeMeasurement(builder, Optional.empty());
            T t = result;
            return t;
        }
        catch (Throwable error) {
            this.completeMeasurement(builder, Optional.of(error));
            throw error;
        }
        finally {
            operation.getContext().popOperation(operation);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T measureConditionallyImpl(TelemetryLevel level, Operation operation, TelemetrySupplier<T> operationCode, Predicate<T> shouldMeasure) {
        OperationMeasurement.OperationMeasurementBuilder builder = this.startMeasurement(level, operation);
        try {
            operation.getContext().pushOperation(operation);
            T result = operationCode.apply();
            if (shouldMeasure.test(result)) {
                this.completeMeasurement(builder, Optional.empty());
            }
            T t = result;
            return t;
        }
        catch (Throwable error) {
            this.completeMeasurement(builder, Optional.of(error));
            throw error;
        }
        finally {
            operation.getContext().popOperation(operation);
        }
    }

    private <T> CompletableFuture<T> measureImpl(TelemetryLevel level, Operation operation, CompletableFuture<T> operationCode) {
        OperationMeasurement.OperationMeasurementBuilder builder = this.startMeasurement(level, operation);
        operationCode.whenComplete((result, error) -> this.completeMeasurement(builder, Optional.ofNullable(error)));
        return operationCode;
    }

    @Override
    public void measure(@NonNull Metric metric, double value) {
        if (metric == null) {
            throw new NullPointerException("metric is marked non-null but is null");
        }
        this.recordForAggregation(() -> (MetricMeasurement)((MetricMeasurement.MetricMeasurementBuilder)MetricMeasurement.builder().metric(metric).epochTimestampNanos(this.getEpochClock().getCurrentTimeNanos())).value(value).kind(MetricMeasurementKind.RAW).build());
    }

    @Override
    public <T> T measureJoin(@NonNull TelemetryLevel level, @NonNull OperationSupplier operationSupplier, @NonNull CompletableFuture<T> operationCode) throws IOException {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        if (operationSupplier == null) {
            throw new NullPointerException("operationSupplier is marked non-null but is null");
        }
        if (operationCode == null) {
            throw new NullPointerException("operationCode is marked non-null but is null");
        }
        if (operationCode.isDone()) {
            return this.handleCompletableFutureJoin(operationCode);
        }
        return (T)this.measure(level, operationSupplier, () -> this.handleCompletableFutureJoin(operationCode));
    }

    private <T> T handleCompletableFutureJoin(CompletableFuture<T> future) throws IOException {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof UncheckedIOException) {
                throw ((UncheckedIOException)cause).getCause();
            }
            throw new IOException("Error while getting data", e);
        }
    }

    private OperationMeasurement.OperationMeasurementBuilder startMeasurement(TelemetryLevel level, Operation operation) {
        OperationMeasurement.OperationMeasurementBuilder builder = OperationMeasurement.builder();
        long epochTimestampNanos = this.epochClock.getCurrentTimeNanos();
        builder.operation(operation);
        builder.level(level);
        builder.epochTimestampNanos(epochTimestampNanos);
        builder.elapsedStartTimeNanos(this.elapsedClock.getCurrentTimeNanos());
        this.recordOperationStart(epochTimestampNanos, operation);
        return builder;
    }

    private void completeMeasurement(OperationMeasurement.OperationMeasurementBuilder builder, Optional<Throwable> error) {
        builder.elapsedCompleteTimeNanos(this.elapsedClock.getCurrentTimeNanos());
        if (error.isPresent()) {
            builder.error(error.get());
        }
        OperationMeasurement operationMeasurement = (OperationMeasurement)builder.build();
        this.recordDatapoint(operationMeasurement);
        this.recordForAggregation(() -> operationMeasurement);
    }

    private void recordDatapoint(TelemetryDatapointMeasurement datapointMeasurement) {
        DefaultTelemetry.recordDatapoint(this.reporter, datapointMeasurement);
    }

    private void recordForAggregation(Supplier<TelemetryDatapointMeasurement> datapointMeasurement) {
        this.aggregator.ifPresent(aggregator -> DefaultTelemetry.recordDatapoint(aggregator, (TelemetryDatapointMeasurement)datapointMeasurement.get()));
    }

    private static void recordDatapoint(TelemetryReporter reporter, TelemetryDatapointMeasurement datapointMeasurement) {
        try {
            reporter.reportComplete(datapointMeasurement);
        }
        catch (Throwable error) {
            LOG.error(String.format("Unexpected error reporting measurement for `%s`.", datapointMeasurement.getDatapoint()), error);
        }
    }

    private void recordOperationStart(long epochTimestampNanos, Operation operation) {
        try {
            this.reporter.reportStart(epochTimestampNanos, operation);
        }
        catch (Throwable error) {
            LOG.error(String.format("Unexpected error reporting operation start of `%s`.", operation.toString()), error);
        }
    }

    private boolean produceTelemetryFor(TelemetryLevel level) {
        return level.getValue() >= this.level.getValue();
    }

    @Generated
    DefaultTelemetry(@NonNull Clock epochClock, @NonNull Clock elapsedClock, @NonNull TelemetryReporter reporter, @NonNull Optional<TelemetryDatapointAggregator> aggregator, @NonNull TelemetryLevel level) {
        if (epochClock == null) {
            throw new NullPointerException("epochClock is marked non-null but is null");
        }
        if (elapsedClock == null) {
            throw new NullPointerException("elapsedClock is marked non-null but is null");
        }
        if (reporter == null) {
            throw new NullPointerException("reporter is marked non-null but is null");
        }
        if (aggregator == null) {
            throw new NullPointerException("aggregator is marked non-null but is null");
        }
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        this.epochClock = epochClock;
        this.elapsedClock = elapsedClock;
        this.reporter = reporter;
        this.aggregator = aggregator;
        this.level = level;
    }

    @NonNull
    @Generated
    Clock getEpochClock() {
        return this.epochClock;
    }

    @NonNull
    @Generated
    Clock getElapsedClock() {
        return this.elapsedClock;
    }

    @NonNull
    @Generated
    TelemetryReporter getReporter() {
        return this.reporter;
    }

    @NonNull
    @Generated
    Optional<TelemetryDatapointAggregator> getAggregator() {
        return this.aggregator;
    }

    @NonNull
    @Generated
    public TelemetryLevel getLevel() {
        return this.level;
    }
}

