/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import software.amazon.s3.analyticsaccelerator.common.ObjectRange;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;

public abstract class SeekableInputStream
extends InputStream {
    public abstract void seek(long var1) throws IOException;

    public abstract long getPos();

    public abstract int readTail(byte[] var1, int var2, int var3) throws IOException;

    public abstract void readVectored(List<ObjectRange> var1, IntFunction<ByteBuffer> var2, Consumer<ByteBuffer> var3) throws IOException;

    public abstract void readFully(long var1, byte[] var3, int var4, int var5) throws IOException;

    protected void validatePositionedReadArgs(long position, byte[] buffer, int offset, int length) {
        Preconditions.checkNotNull(buffer, "Null destination buffer");
        Preconditions.checkArgument(length >= 0, "Length is negative");
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Offset is negative");
        }
        Preconditions.checkArgument(position >= 0L, "Position is negative");
        Preconditions.checkPositionIndex(length, buffer.length - offset, "Too many bytes for destination buffer : request length=" + length + ", with offset =" + offset + "; buffer capacity =" + (buffer.length - offset));
    }
}

