/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.yarn.api.records.ResourceUtilization;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ResourceUtilizationInfo {
    protected int nodePhysicalMemoryMB;
    protected int nodeVirtualMemoryMB;
    protected double nodeCPUUsage;
    protected int aggregatedContainersPhysicalMemoryMB;
    protected int aggregatedContainersVirtualMemoryMB;
    protected double containersCPUUsage;

    public ResourceUtilizationInfo() {
    }

    public ResourceUtilizationInfo(RMNode ni) {
        ResourceUtilization containerAggrUtilization;
        ResourceUtilization nodeUtilization = ni.getNodeUtilization();
        if (nodeUtilization != null) {
            this.nodePhysicalMemoryMB = nodeUtilization.getPhysicalMemory();
            this.nodeVirtualMemoryMB = nodeUtilization.getVirtualMemory();
            this.nodeCPUUsage = nodeUtilization.getCPU();
        }
        if ((containerAggrUtilization = ni.getAggregatedContainersUtilization()) != null) {
            this.aggregatedContainersPhysicalMemoryMB = containerAggrUtilization.getPhysicalMemory();
            this.aggregatedContainersVirtualMemoryMB = containerAggrUtilization.getVirtualMemory();
            this.containersCPUUsage = containerAggrUtilization.getCPU();
        }
    }

    public int getNodePhysicalMemoryMB() {
        return this.nodePhysicalMemoryMB;
    }

    public int getNodeVirtualMemoryMB() {
        return this.nodeVirtualMemoryMB;
    }

    public int getAggregatedContainersPhysicalMemoryMB() {
        return this.aggregatedContainersPhysicalMemoryMB;
    }

    public int getAggregatedContainersVirtualMemoryMB() {
        return this.aggregatedContainersVirtualMemoryMB;
    }

    public double getNodeCPUUsage() {
        return this.nodeCPUUsage;
    }

    public double getContainersCPUUsage() {
        return this.containersCPUUsage;
    }
}

