/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.distributed;

import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class ClusterNode {
    private int queueLength = 0;
    private int queueWaitTime = -1;
    private long timestamp;
    final NodeId nodeId;
    private int queueCapacity = 0;
    private final HashSet<String> labels;
    private Resource capability = Resources.none();
    private Resource allocatedResource = Resources.none();
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final ReentrantReadWriteLock.ReadLock readLock;

    public ClusterNode(NodeId nodeId) {
        this.nodeId = nodeId;
        this.labels = new HashSet();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.writeLock = lock.writeLock();
        this.readLock = lock.readLock();
        this.timestamp = System.currentTimeMillis();
    }

    public ClusterNode setProperties(Properties properties) {
        this.writeLock.lock();
        try {
            this.capability = properties.capability == null ? Resources.none() : properties.capability;
            this.allocatedResource = properties.allocatedResource == null ? Resources.none() : properties.allocatedResource;
            this.queueLength = properties.queueLength;
            this.queueWaitTime = properties.queueWaitTime;
            this.timestamp = properties.timestamp;
            if (properties.queueCapacityIsSet) {
                this.queueCapacity = properties.queueCapacity;
            }
            this.labels.clear();
            this.labels.addAll(properties.labels);
            ClusterNode clusterNode = this;
            return clusterNode;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Resource getAllocatedResource() {
        this.readLock.lock();
        try {
            Resource resource = this.allocatedResource;
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Resource getAvailableResource() {
        this.readLock.lock();
        try {
            Resource resource = Resources.subtractNonNegative((Resource)this.capability, (Resource)this.allocatedResource);
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Resource getCapability() {
        this.readLock.lock();
        try {
            Resource resource = this.capability;
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean hasLabel(String label) {
        this.readLock.lock();
        try {
            boolean bl = this.labels.contains(label);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public long getTimestamp() {
        this.readLock.lock();
        try {
            long l = this.timestamp;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getQueueLength() {
        this.readLock.lock();
        try {
            int n = this.queueLength;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getQueueWaitTime() {
        this.readLock.lock();
        try {
            int n = this.queueWaitTime;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getQueueCapacity() {
        this.readLock.lock();
        try {
            int n = this.queueCapacity;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compareAndIncrementAllocation(int incrementQLen, ResourceCalculator resourceCalculator, Resource requested) {
        this.writeLock.lock();
        try {
            Resource currAvailable = Resources.subtractNonNegative((Resource)this.capability, (Resource)this.allocatedResource);
            if (resourceCalculator.fitsIn(requested, currAvailable)) {
                this.allocatedResource = Resources.add((Resource)this.allocatedResource, (Resource)requested);
                boolean bl = true;
                return bl;
            }
            if (!resourceCalculator.fitsIn(requested, this.capability)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.compareAndIncrementAllocation(incrementQLen);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compareAndIncrementAllocation(int incrementQLen) {
        this.writeLock.lock();
        try {
            int added = this.queueLength + incrementQLen;
            if (added <= this.queueCapacity) {
                this.queueLength = added;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean isQueueFull() {
        this.readLock.lock();
        try {
            boolean bl = this.queueCapacity > 0 && this.queueLength >= this.queueCapacity;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public static final class Properties {
        private int queueLength = 0;
        private int queueWaitTime = -1;
        private long timestamp;
        private int queueCapacity = 0;
        private boolean queueCapacityIsSet = false;
        private final HashSet<String> labels = new HashSet();
        private Resource capability = null;
        private Resource allocatedResource = null;

        public static Properties newInstance() {
            return new Properties();
        }

        Properties setQueueLength(int qLength) {
            this.queueLength = qLength;
            return this;
        }

        Properties setQueueWaitTime(int wTime) {
            this.queueWaitTime = wTime;
            return this;
        }

        Properties updateTimestamp() {
            this.timestamp = System.currentTimeMillis();
            return this;
        }

        Properties setQueueCapacity(int capacity) {
            this.queueCapacity = capacity;
            this.queueCapacityIsSet = true;
            return this;
        }

        Properties setNodeLabels(Collection<String> labelsToAdd) {
            this.labels.clear();
            this.labels.addAll(labelsToAdd);
            return this;
        }

        Properties setCapability(Resource nodeCapability) {
            this.capability = nodeCapability;
            return this;
        }

        Properties setAllocatedResource(Resource allocResource) {
            this.allocatedResource = allocResource;
            return this;
        }

        private Properties() {
        }
    }
}

