/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsDriverException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AppendRequestParameters;
import org.apache.hadoop.fs.azurebfs.contracts.services.BlobAppendRequestParameters;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlobClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.BlobRenameHandler;
import org.apache.hadoop.fs.azurebfs.services.RenamePendingJsonFormat;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;

public class RenameAtomicity {
    private final TracingContext tracingContext;
    private Path src;
    private Path dst;
    private String srcEtag;
    private final AbfsBlobClient abfsClient;
    private final Path renameJsonPath;
    public static final String SUFFIX = "-RenamePending.json";
    private int preRenameRetryCount = 0;
    private int renamePendingJsonLen;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private static final Random RANDOM = new Random();

    public RenameAtomicity(Path src, Path dst, Path renameJsonPath, TracingContext tracingContext, String srcEtag, AbfsClient abfsClient) {
        this.src = src;
        this.dst = dst;
        this.abfsClient = (AbfsBlobClient)abfsClient;
        this.renameJsonPath = renameJsonPath;
        this.tracingContext = tracingContext;
        this.srcEtag = srcEtag;
    }

    public RenameAtomicity(Path renameJsonPath, int renamePendingJsonFileLen, TracingContext tracingContext, String srcEtag, AbfsClient abfsClient) {
        this.abfsClient = (AbfsBlobClient)abfsClient;
        this.renameJsonPath = renameJsonPath;
        this.tracingContext = tracingContext;
        this.srcEtag = srcEtag;
        this.renamePendingJsonLen = renamePendingJsonFileLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo() throws AzureBlobFileSystemException {
        byte[] buffer = this.readRenamePendingJson(this.renameJsonPath, this.renamePendingJsonLen);
        String contents = new String(buffer, Charset.defaultCharset());
        try {
            RenamePendingJsonFormat renamePendingJsonFormatObj;
            try {
                renamePendingJsonFormatObj = (RenamePendingJsonFormat)this.objectMapper.readValue(contents, RenamePendingJsonFormat.class);
            }
            catch (JsonProcessingException e) {
                this.deleteRenamePendingJson();
                return;
            }
            if (renamePendingJsonFormatObj != null && StringUtils.isNotEmpty((CharSequence)renamePendingJsonFormatObj.getOldFolderName()) && StringUtils.isNotEmpty((CharSequence)renamePendingJsonFormatObj.getNewFolderName()) && StringUtils.isNotEmpty((CharSequence)renamePendingJsonFormatObj.getETag())) {
                this.src = new Path(renamePendingJsonFormatObj.getOldFolderName());
                this.dst = new Path(renamePendingJsonFormatObj.getNewFolderName());
                this.srcEtag = renamePendingJsonFormatObj.getETag();
                BlobRenameHandler blobRenameHandler = new BlobRenameHandler(this.src.toUri().getPath(), this.dst.toUri().getPath(), this.abfsClient, this.srcEtag, true, true, this.tracingContext);
                blobRenameHandler.execute(true);
            }
        }
        finally {
            this.deleteRenamePendingJson();
        }
    }

    @VisibleForTesting
    byte[] readRenamePendingJson(Path path, int len) throws AzureBlobFileSystemException {
        byte[] bytes = new byte[len];
        this.abfsClient.read(path.toUri().getPath(), 0L, bytes, 0, len, null, null, null, this.tracingContext);
        return bytes;
    }

    public static String generateBlockId() {
        byte[] blockIdByteArray = new byte[60];
        RANDOM.nextBytes(blockIdByteArray);
        return new String(Base64.encodeBase64((byte[])blockIdByteArray), StandardCharsets.UTF_8);
    }

    @VisibleForTesting
    void createRenamePendingJson(Path path, byte[] bytes) throws AzureBlobFileSystemException {
        AbfsRestOperation putBlobOp = this.abfsClient.createPath(path.toUri().getPath(), true, true, null, false, null, null, this.tracingContext);
        String eTag = AzureBlobFileSystemStore.extractEtagHeader(putBlobOp.getResult());
        String blockId = RenameAtomicity.generateBlockId();
        String blockList = AbfsBlobClient.generateBlockListXml(blockId);
        byte[] buffer = blockList.getBytes(StandardCharsets.UTF_8);
        String computedMd5 = null;
        if (this.abfsClient.isFullBlobChecksumValidationEnabled()) {
            computedMd5 = this.abfsClient.computeMD5Hash(buffer, 0, buffer.length);
        }
        AppendRequestParameters appendRequestParameters = new AppendRequestParameters(0L, 0, bytes.length, AppendRequestParameters.Mode.APPEND_MODE, false, null, this.abfsClient.getAbfsConfiguration().isExpectHeaderEnabled(), new BlobAppendRequestParameters(blockId, eTag), this.abfsClient.isChecksumValidationEnabled() ? this.abfsClient.computeMD5Hash(bytes, 0, bytes.length) : null);
        this.abfsClient.append(path.toUri().getPath(), bytes, appendRequestParameters, null, null, this.tracingContext);
        this.abfsClient.flush(buffer, path.toUri().getPath(), true, null, null, eTag, null, this.tracingContext, computedMd5);
    }

    @VisibleForTesting
    public int preRename() throws AzureBlobFileSystemException {
        String makeRenamePendingFileContents = this.makeRenamePendingFileContents(this.srcEtag);
        try {
            this.createRenamePendingJson(this.renameJsonPath, makeRenamePendingFileContents.getBytes(StandardCharsets.UTF_8));
            return makeRenamePendingFileContents.length();
        }
        catch (AzureBlobFileSystemException e) {
            if (this.isPreRenameRetriableException(e)) {
                ++this.preRenameRetryCount;
                if (this.preRenameRetryCount == 1) {
                    return this.preRename();
                }
            }
            throw e;
        }
    }

    private boolean isPreRenameRetriableException(IOException e) {
        while (e != null) {
            if (e instanceof AbfsRestOperationException) {
                AbfsRestOperationException ex = (AbfsRestOperationException)e;
                return ex.getStatusCode() == 404 || ex.getStatusCode() == 412;
            }
            e = (IOException)e.getCause();
        }
        return false;
    }

    public void postRename() throws AzureBlobFileSystemException {
        this.deleteRenamePendingJson();
    }

    private void deleteRenamePendingJson() throws AzureBlobFileSystemException {
        try {
            this.abfsClient.deleteBlobPath(this.renameJsonPath, null, this.tracingContext);
        }
        catch (AzureBlobFileSystemException e) {
            if (e instanceof AbfsRestOperationException && ((AbfsRestOperationException)e).getStatusCode() == 404) {
                return;
            }
            throw e;
        }
    }

    private String makeRenamePendingFileContents(String eTag) throws AzureBlobFileSystemException {
        RenamePendingJsonFormat renamePendingJsonFormat = new RenamePendingJsonFormat();
        renamePendingJsonFormat.setOldFolderName(this.src.toUri().getPath());
        renamePendingJsonFormat.setNewFolderName(this.dst.toUri().getPath());
        renamePendingJsonFormat.setETag(eTag);
        try {
            return this.objectMapper.writeValueAsString((Object)renamePendingJsonFormat);
        }
        catch (JsonProcessingException e) {
            throw new AbfsDriverException((Exception)((Object)e));
        }
    }
}

