/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.finance.portfolio;

import java.util.List;
import org.ojalgo.ProgrammingError;
import org.ojalgo.finance.portfolio.EquilibriumModel;
import org.ojalgo.finance.portfolio.FinancePortfolio;
import org.ojalgo.finance.portfolio.MarketEquilibrium;
import org.ojalgo.matrix.BasicMatrix;

public final class FixedReturnsPortfolio
extends EquilibriumModel {
    private final BasicMatrix myReturns;

    public FixedReturnsPortfolio(FinancePortfolio.Context aContext) {
        super(aContext);
        this.myReturns = aContext.getAssetReturns();
    }

    public FixedReturnsPortfolio(MarketEquilibrium aMarketEquilibrium, BasicMatrix returnsVector) {
        super(aMarketEquilibrium);
        this.myReturns = returnsVector;
    }

    private FixedReturnsPortfolio(MarketEquilibrium aMarketEquilibrium) {
        super(aMarketEquilibrium);
        this.myReturns = null;
        ProgrammingError.throwForIllegalInvocation();
    }

    public void calibrate(FinancePortfolio targetWeights) {
        this.calibrate(targetWeights.getWeights());
    }

    public void calibrate(List<? extends Number> targetWeights) {
        this.calibrate((BasicMatrix)FinancePortfolio.MATRIX_FACTORY.columns(targetWeights), this.myReturns);
    }

    @Override
    protected BasicMatrix calculateAssetReturns() {
        return this.myReturns;
    }

    @Override
    protected BasicMatrix calculateAssetWeights() {
        return this.calculateAssetWeights(this.myReturns);
    }
}

