/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.webapp;

import com.google.inject.Inject;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.router.Router;
import org.apache.hadoop.yarn.server.router.webapp.RouterBlock;
import org.apache.hadoop.yarn.server.webapp.WebPageUtils;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class NavBlock
extends RouterBlock {
    private Router router;

    @Inject
    public NavBlock(Router router, View.ViewContext ctx) {
        super(router, ctx);
        this.router = router;
    }

    public void render(HtmlBlock.Block html) {
        String federationText = this.isYarnFederationEnabled() ? "Federation" : "LocalCluster";
        Hamlet.UL mainList = (Hamlet.UL)((Hamlet.UL)html.div("#nav").h3("Cluster").ul().li().a(this.url(new String[]{""}), "About").__()).li().a(this.url(new String[]{"federation"}), federationText).__();
        List<String> subClusterIds = this.getActiveSubClusterIds();
        this.initNodesMenu((Hamlet.UL<Hamlet.DIV<Hamlet>>)mainList, subClusterIds);
        this.initNodeLabelsMenu((Hamlet.UL<Hamlet.DIV<Hamlet>>)mainList, subClusterIds);
        this.initApplicationsMenu((Hamlet.UL<Hamlet.DIV<Hamlet>>)mainList, subClusterIds);
        Hamlet.DIV sectionBefore = (Hamlet.DIV)mainList.__();
        Configuration conf = new Configuration();
        Hamlet.UL tools = WebPageUtils.appendToolSection((Hamlet.DIV)sectionBefore, (Configuration)conf);
        if (tools == null) {
            return;
        }
        ((Hamlet.DIV)tools.__()).__();
    }
}

