/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.resourceestimator.translator.impl;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.resourceestimator.common.api.RecurrenceId;
import org.apache.hadoop.resourceestimator.common.api.ResourceSkyline;
import org.apache.hadoop.resourceestimator.translator.api.JobMetaData;
import org.apache.hadoop.resourceestimator.translator.api.SingleLineParser;
import org.apache.hadoop.resourceestimator.translator.exceptions.DataFieldNotFoundException;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeSingleLineParser
implements SingleLineParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeSingleLineParser.class);

    private void aggregateSkyline(ResourceSkyline resourceSkyline, RecurrenceId recurrenceId, Map<RecurrenceId, List<ResourceSkyline>> skylineRecords) {
        List<ResourceSkyline> resourceSkylines = skylineRecords.get(recurrenceId);
        if (resourceSkylines == null) {
            resourceSkylines = new ArrayList<ResourceSkyline>();
            skylineRecords.put(recurrenceId, resourceSkylines);
        }
        resourceSkylines.add(resourceSkyline);
    }

    @Override
    public void parseLine(String logLine, Map<String, JobMetaData> jobMetas, Map<RecurrenceId, List<ResourceSkyline>> skylineRecords) throws DataFieldNotFoundException, ParseException {
        Configuration config = new Configuration();
        config.addResource(new Path("resourceestimator-config.xml"));
        int timeInterval = config.getInt("resourceestimator.timeInterval", 5);
        long containerMemAlloc = 1024L;
        int containerCpuAlloc = 1;
        String[] splitString = logLine.split("\\s+");
        String pipelineId = splitString[0];
        String jobId = splitString[5];
        String[] skylineUnits = splitString[7].split("\\|");
        JobMetaData appMeta = new JobMetaData(0L);
        RecurrenceId recurrenceId = new RecurrenceId(pipelineId, jobId);
        appMeta.setRecurrenceId(recurrenceId);
        ResourceSkyline resourceSkyline = appMeta.getResourceSkyline();
        TreeMap resourceOverTime = new TreeMap();
        RLESparseResourceAllocation skylineList = new RLESparseResourceAllocation(resourceOverTime, (ResourceCalculator)new DefaultResourceCalculator());
        resourceSkyline.setSkylineList(skylineList);
        for (String elem : skylineUnits) {
            int numContainers = Integer.parseInt(elem.split("\\:")[0]);
            Resource containerAlloc = Resource.newInstance((long)(containerMemAlloc * (long)numContainers), (int)(containerCpuAlloc * numContainers));
            ReservationInterval riAdd = new ReservationInterval(Long.parseLong(elem.split("\\:")[1]), Long.parseLong(elem.split("\\:")[1]) + (long)timeInterval);
            resourceSkyline.getSkylineList().addInterval(riAdd, containerAlloc);
        }
        resourceSkyline.setContainerSpec(Resource.newInstance((long)containerMemAlloc, (int)containerCpuAlloc));
        appMeta.setJobFinishTime(appMeta.getResourceSkyline().getSkylineList().getLatestNonNullTime());
        resourceSkyline.setJobInputDataSize(0.0);
        resourceSkyline.setJobId(jobId);
        this.aggregateSkyline(resourceSkyline, recurrenceId, skylineRecords);
    }
}

