/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.processor;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.ams.ApplicationMasterServiceContext;
import org.apache.hadoop.yarn.ams.ApplicationMasterServiceProcessor;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.PlacementConstraintManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPlacementProcessor
implements ApplicationMasterServiceProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPlacementProcessor.class);
    protected ApplicationMasterServiceProcessor nextAMSProcessor;
    protected AbstractYarnScheduler scheduler;
    private PlacementConstraintManager constraintManager;

    public void init(ApplicationMasterServiceContext amsContext, ApplicationMasterServiceProcessor nextProcessor) {
        this.nextAMSProcessor = nextProcessor;
        this.scheduler = (AbstractYarnScheduler)((RMContextImpl)amsContext).getScheduler();
        this.constraintManager = ((RMContextImpl)amsContext).getPlacementConstraintManager();
    }

    public void registerApplicationMaster(ApplicationAttemptId applicationAttemptId, RegisterApplicationMasterRequest request, RegisterApplicationMasterResponse response) throws IOException, YarnException {
        Map appPlacementConstraints = request.getPlacementConstraints();
        this.processPlacementConstraints(applicationAttemptId.getApplicationId(), appPlacementConstraints);
        this.nextAMSProcessor.registerApplicationMaster(applicationAttemptId, request, response);
    }

    private void processPlacementConstraints(ApplicationId applicationId, Map<Set<String>, PlacementConstraint> appPlacementConstraints) {
        if (appPlacementConstraints != null && !appPlacementConstraints.isEmpty()) {
            LOG.info("Constraints added for application [{}] against tags [{}]", (Object)applicationId, appPlacementConstraints);
            this.constraintManager.registerApplication(applicationId, appPlacementConstraints);
        }
    }

    public void finishApplicationMaster(ApplicationAttemptId applicationAttemptId, FinishApplicationMasterRequest request, FinishApplicationMasterResponse response) {
        this.constraintManager.unregisterApplication(applicationAttemptId.getApplicationId());
        this.nextAMSProcessor.finishApplicationMaster(applicationAttemptId, request, response);
    }
}

