/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlock;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStream;
import org.apache.hadoop.fs.azurebfs.services.AzureBlockManager;
import org.apache.hadoop.fs.store.DataBlocks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureDFSBlockManager
extends AzureBlockManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbfsOutputStream.class);

    public AzureDFSBlockManager(AbfsOutputStream abfsOutputStream, DataBlocks.BlockFactory blockFactory, int blockSize) {
        super(abfsOutputStream, blockFactory, blockSize);
        LOG.trace("Created a new DFS Block Manager for AbfsOutputStream instance {} for path {}", (Object)abfsOutputStream.getStreamID(), (Object)abfsOutputStream.getPath());
    }

    @Override
    protected synchronized AbfsBlock createBlockInternal(long position) throws IOException {
        if (this.getActiveBlock() == null) {
            this.setBlockCount(this.getBlockCount() + 1L);
            AbfsBlock activeBlock = new AbfsBlock(this.getAbfsOutputStream(), position);
            if (this.getAbfsOutputStream().isChecksumValidationEnabled()) {
                this.getAbfsOutputStream().getMessageDigest().reset();
            }
            this.setActiveBlock(activeBlock);
        }
        return this.getActiveBlock();
    }

    @Override
    public synchronized AbfsBlock getActiveBlock() {
        return super.getActiveBlock();
    }

    @Override
    protected synchronized boolean hasActiveBlock() {
        return super.hasActiveBlock();
    }

    @Override
    public void close() {
        super.close();
        LOG.debug("AzureDFSBlockManager closed.");
    }
}

