/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActor;
import org.apache.hadoop.hdfs.server.datanode.DNConf;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.VersionInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDatanodeRegister {
    public static final Logger LOG = LoggerFactory.getLogger(TestDatanodeRegister.class);
    private static final InetSocketAddress INVALID_ADDR = new InetSocketAddress("127.0.0.1", 1);
    private BPServiceActor actor;
    NamespaceInfo fakeNsInfo;
    DNConf mockDnConf;

    @Before
    public void setUp() throws IOException {
        this.mockDnConf = (DNConf)Mockito.mock(DNConf.class);
        ((DNConf)Mockito.doReturn((Object)VersionInfo.getVersion()).when((Object)this.mockDnConf)).getMinimumNameNodeVersion();
        DataNode mockDN = (DataNode)Mockito.mock(DataNode.class);
        ((DataNode)Mockito.doReturn((Object)true).when((Object)mockDN)).shouldRun();
        ((DataNode)Mockito.doReturn((Object)this.mockDnConf).when((Object)mockDN)).getDnConf();
        BPOfferService mockBPOS = (BPOfferService)Mockito.mock(BPOfferService.class);
        ((BPOfferService)Mockito.doReturn((Object)mockDN).when((Object)mockBPOS)).getDataNode();
        this.actor = new BPServiceActor("test", "test", INVALID_ADDR, null, mockBPOS);
        this.fakeNsInfo = (NamespaceInfo)Mockito.mock(NamespaceInfo.class);
        ((NamespaceInfo)Mockito.doReturn((Object)VersionInfo.getVersion()).when((Object)this.fakeNsInfo)).getSoftwareVersion();
        ((NamespaceInfo)Mockito.doReturn((Object)HdfsServerConstants.NAMENODE_LAYOUT_VERSION).when((Object)this.fakeNsInfo)).getLayoutVersion();
        DatanodeProtocolClientSideTranslatorPB fakeDnProt = (DatanodeProtocolClientSideTranslatorPB)Mockito.mock(DatanodeProtocolClientSideTranslatorPB.class);
        Mockito.when((Object)fakeDnProt.versionRequest()).thenReturn((Object)this.fakeNsInfo);
        this.actor.setNameNode(fakeDnProt);
    }

    @Test
    public void testSoftwareVersionDifferences() throws Exception {
        Assert.assertEquals((Object)VersionInfo.getVersion(), (Object)this.actor.retrieveNamespaceInfo().getSoftwareVersion());
        ((NamespaceInfo)Mockito.doReturn((Object)"4.0.0").when((Object)this.fakeNsInfo)).getSoftwareVersion();
        ((DNConf)Mockito.doReturn((Object)"3.0.0").when((Object)this.mockDnConf)).getMinimumNameNodeVersion();
        Assert.assertEquals((Object)"4.0.0", (Object)this.actor.retrieveNamespaceInfo().getSoftwareVersion());
        ((NamespaceInfo)Mockito.doReturn((Object)"3.0.0").when((Object)this.fakeNsInfo)).getSoftwareVersion();
        ((DNConf)Mockito.doReturn((Object)"4.0.0").when((Object)this.mockDnConf)).getMinimumNameNodeVersion();
        try {
            this.actor.retrieveNamespaceInfo();
            Assert.fail((String)"Should have thrown an exception for NN with too-low version");
        }
        catch (IncorrectVersionException ive) {
            GenericTestUtils.assertExceptionContains((String)"The reported NameNode version is too low", (Throwable)ive);
            LOG.info("Got expected exception", (Throwable)ive);
        }
    }

    @Test
    public void testDifferentLayoutVersions() throws Exception {
        Assert.assertEquals((long)HdfsServerConstants.NAMENODE_LAYOUT_VERSION, (long)this.actor.retrieveNamespaceInfo().getLayoutVersion());
        ((NamespaceInfo)Mockito.doReturn((Object)(HdfsServerConstants.NAMENODE_LAYOUT_VERSION * 1000)).when((Object)this.fakeNsInfo)).getLayoutVersion();
        try {
            this.actor.retrieveNamespaceInfo();
        }
        catch (IOException e) {
            Assert.fail((String)"Should not fail to retrieve NS info from DN with different layout version");
        }
    }

    @Test
    public void testDNShutdwonBeforeRegister() throws Exception {
        InetSocketAddress nnADDR = new InetSocketAddress("localhost", 5020);
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.datanode.address", "0.0.0.0:0");
        conf.set("dfs.datanode.http.address", "0.0.0.0:0");
        conf.set("dfs.datanode.ipc.address", "0.0.0.0:0");
        FileSystem.setDefaultUri((Configuration)conf, (String)("hdfs://" + nnADDR.getHostName() + ":" + nnADDR.getPort()));
        ArrayList locations = new ArrayList();
        DataNode dn = new DataNode((Configuration)conf, locations, null, null);
        BPOfferService bpos = new BPOfferService("test_ns", (List)Lists.newArrayList((Object[])new String[]{"nn0"}), (List)Lists.newArrayList((Object[])new InetSocketAddress[]{nnADDR}), Collections.nCopies(1, null), dn);
        DatanodeProtocolClientSideTranslatorPB fakeDnProt = (DatanodeProtocolClientSideTranslatorPB)Mockito.mock(DatanodeProtocolClientSideTranslatorPB.class);
        Mockito.when((Object)fakeDnProt.versionRequest()).thenReturn((Object)this.fakeNsInfo);
        BPServiceActor localActor = new BPServiceActor("test", "test", INVALID_ADDR, null, bpos);
        localActor.setNameNode(fakeDnProt);
        try {
            NamespaceInfo nsInfo = localActor.retrieveNamespaceInfo();
            bpos.setNamespaceInfo(nsInfo);
            localActor.stop();
            localActor.register(nsInfo);
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"DN shut down before block pool registered", (Object)e.getMessage());
        }
    }

    @Test
    public void testInvalidConfigurationValue() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.datanode.failed.volumes.tolerated", -2);
        LambdaTestUtils.intercept(HadoopIllegalArgumentException.class, (String)"Invalid value configured for dfs.datanode.failed.volumes.tolerated - -2 should be greater than or equal to -1", () -> TestDatanodeRegister.lambda$testInvalidConfigurationValue$0((Configuration)conf));
    }

    private static /* synthetic */ DataNode lambda$testInvalidConfigurationValue$0(Configuration conf) throws Exception {
        return new DataNode(conf, new ArrayList(), null, null);
    }
}

