/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableManager;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.order.DestinationOrder;
import org.apache.hadoop.hdfs.server.federation.router.NameserviceManager;
import org.apache.hadoop.hdfs.server.federation.router.RemoteMethod;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterAdminServer;
import org.apache.hadoop.hdfs.server.federation.router.RouterClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.impl.DisabledNameserviceStoreImpl;
import org.apache.hadoop.hdfs.server.federation.store.impl.MountTableStoreImpl;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.DisableNameserviceRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.DisableNameserviceResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.EnableNameserviceRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.EnableNameserviceResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetDisabledNameservicesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetDisabledNameservicesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Time;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.FieldSetter;

public class TestRouterAdmin {
    private static StateStoreDFSCluster cluster;
    private static MiniRouterDFSCluster.RouterContext routerContext;
    public static final String RPC_BEAN = "Hadoop:service=Router,name=FederationRPC";
    private static List<MountTable> mockMountTable;
    private static StateStoreService stateStore;
    private static RouterRpcClient mockRpcClient;

    @BeforeClass
    public static void globalSetUp() throws Exception {
        cluster = new StateStoreDFSCluster(false, 1);
        Configuration conf = new RouterConfigBuilder().stateStore().admin().rpc().build();
        conf.setBoolean("dfs.federation.router.admin.mount.check.enable", true);
        cluster.addRouterOverrides(conf);
        cluster.startRouters();
        routerContext = cluster.getRandomRouter();
        mockMountTable = cluster.generateMockMountTable();
        Router router = routerContext.getRouter();
        stateStore = router.getStateStore();
        ActiveNamenodeResolver membership = router.getNamenodeResolver();
        membership.registerNamenode(FederationTestUtils.createNamenodeReport("ns0", "nn1", HAServiceProtocol.HAServiceState.ACTIVE));
        membership.registerNamenode(FederationTestUtils.createNamenodeReport("ns1", "nn1", HAServiceProtocol.HAServiceState.ACTIVE));
        stateStore.refreshCaches(true);
        TestRouterAdmin.setUpMocks();
    }

    private static void setUpMocks() throws IOException, NoSuchFieldException {
        RouterRpcServer spyRpcServer = (RouterRpcServer)Mockito.spy((Object)routerContext.getRouter().createRpcServer());
        FieldSetter.setField((Object)routerContext.getRouter(), (Field)Router.class.getDeclaredField("rpcServer"), (Object)spyRpcServer);
        ((RouterRpcServer)Mockito.doReturn(null).when((Object)spyRpcServer)).getFileInfo(Mockito.anyString());
        mockRpcClient = (RouterRpcClient)Mockito.spy((Object)spyRpcServer.getRPCClient());
        FieldSetter.setField((Object)spyRpcServer, (Field)RouterRpcServer.class.getDeclaredField("rpcClient"), (Object)mockRpcClient);
        RemoteLocation remoteLocation0 = new RemoteLocation("ns0", "/testdir", null);
        RemoteLocation remoteLocation1 = new RemoteLocation("ns1", "/", null);
        HashMap<RemoteLocation, HdfsFileStatus> mockResponse0 = new HashMap<RemoteLocation, HdfsFileStatus>();
        HashMap<RemoteLocation, HdfsFileStatus> mockResponse1 = new HashMap<RemoteLocation, HdfsFileStatus>();
        mockResponse0.put(remoteLocation0, new HdfsFileStatus.Builder().build());
        ((RouterRpcClient)Mockito.doReturn(mockResponse0).when((Object)mockRpcClient)).invokeConcurrent((Collection)Mockito.eq((Object)Lists.newArrayList((Object[])new RemoteLocation[]{remoteLocation0})), (RemoteMethod)Mockito.any(RemoteMethod.class), Mockito.eq((boolean)false), Mockito.eq((boolean)false), (Class)Mockito.eq(HdfsFileStatus.class));
        mockResponse1.put(remoteLocation1, new HdfsFileStatus.Builder().build());
        ((RouterRpcClient)Mockito.doReturn(mockResponse1).when((Object)mockRpcClient)).invokeConcurrent((Collection)Mockito.eq((Object)Lists.newArrayList((Object[])new RemoteLocation[]{remoteLocation1})), (RemoteMethod)Mockito.any(RemoteMethod.class), Mockito.eq((boolean)false), Mockito.eq((boolean)false), (Class)Mockito.eq(HdfsFileStatus.class));
    }

    @AfterClass
    public static void tearDown() {
        cluster.stopRouter(routerContext);
    }

    @Before
    public void testSetup() throws Exception {
        Assert.assertTrue((boolean)FederationStateStoreTestUtils.synchronizeRecords(stateStore, mockMountTable, MountTable.class));
        routerContext.resetAdminClient();
    }

    @Test
    public void testAddMountTable() throws IOException {
        MountTable newEntry = MountTable.newInstance((String)"/testpath", Collections.singletonMap("ns0", "/testdir"), (long)Time.now(), (long)Time.now());
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTable = client.getMountTableManager();
        List<MountTable> records = this.getMountTableEntries(mountTable);
        Assert.assertEquals((long)records.size(), (long)mockMountTable.size());
        AddMountTableEntryRequest addRequest = AddMountTableEntryRequest.newInstance((MountTable)newEntry);
        AddMountTableEntryResponse addResponse = mountTable.addMountTableEntry(addRequest);
        Assert.assertTrue((boolean)addResponse.getStatus());
        List<MountTable> records2 = this.getMountTableEntries(mountTable);
        Assert.assertEquals((long)records2.size(), (long)(mockMountTable.size() + 1));
    }

    @Test
    public void testAddDuplicateMountTable() throws IOException {
        MountTable newEntry = MountTable.newInstance((String)"/testpath", Collections.singletonMap("ns0", "/testdir"), (long)Time.now(), (long)Time.now());
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTable = client.getMountTableManager();
        List<MountTable> entries1 = this.getMountTableEntries(mountTable);
        Assert.assertEquals((long)entries1.size(), (long)mockMountTable.size());
        AddMountTableEntryRequest addRequest = AddMountTableEntryRequest.newInstance((MountTable)newEntry);
        AddMountTableEntryResponse addResponse = mountTable.addMountTableEntry(addRequest);
        Assert.assertTrue((boolean)addResponse.getStatus());
        List<MountTable> entries2 = this.getMountTableEntries(mountTable);
        Assert.assertEquals((long)entries2.size(), (long)(mockMountTable.size() + 1));
        AddMountTableEntryResponse addResponse2 = mountTable.addMountTableEntry(addRequest);
        Assert.assertFalse((boolean)addResponse2.getStatus());
    }

    @Test
    public void testAddReadOnlyMountTable() throws IOException {
        MountTable newEntry = MountTable.newInstance((String)"/readonly", Collections.singletonMap("ns0", "/testdir"), (long)Time.now(), (long)Time.now());
        newEntry.setReadOnly(true);
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTable = client.getMountTableManager();
        List<MountTable> records = this.getMountTableEntries(mountTable);
        Assert.assertEquals((long)records.size(), (long)mockMountTable.size());
        AddMountTableEntryRequest addRequest = AddMountTableEntryRequest.newInstance((MountTable)newEntry);
        AddMountTableEntryResponse addResponse = mountTable.addMountTableEntry(addRequest);
        Assert.assertTrue((boolean)addResponse.getStatus());
        List<MountTable> records2 = this.getMountTableEntries(mountTable);
        Assert.assertEquals((long)records2.size(), (long)(mockMountTable.size() + 1));
        MountTable record = this.getMountTableEntry("/readonly");
        Assert.assertEquals((Object)"/readonly", (Object)record.getSourcePath());
        Assert.assertTrue((boolean)record.isReadOnly());
        RemoveMountTableEntryRequest removeRequest = RemoveMountTableEntryRequest.newInstance((String)"/readonly");
        RemoveMountTableEntryResponse removeResponse = mountTable.removeMountTableEntry(removeRequest);
        Assert.assertTrue((boolean)removeResponse.getStatus());
    }

    @Test
    public void testAddOrderMountTable() throws IOException {
        this.testAddOrderMountTable(DestinationOrder.HASH);
        this.testAddOrderMountTable(DestinationOrder.LOCAL);
        this.testAddOrderMountTable(DestinationOrder.RANDOM);
        this.testAddOrderMountTable(DestinationOrder.HASH_ALL);
    }

    private void testAddOrderMountTable(DestinationOrder order) throws IOException {
        String mnt = "/" + order;
        MountTable newEntry = MountTable.newInstance((String)mnt, Collections.singletonMap("ns0", "/testdir"), (long)Time.now(), (long)Time.now());
        newEntry.setDestOrder(order);
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTable = client.getMountTableManager();
        AddMountTableEntryRequest addRequest = AddMountTableEntryRequest.newInstance((MountTable)newEntry);
        AddMountTableEntryResponse addResponse = mountTable.addMountTableEntry(addRequest);
        Assert.assertTrue((boolean)addResponse.getStatus());
        MountTable record = this.getMountTableEntry(mnt);
        Assert.assertEquals((Object)mnt, (Object)record.getSourcePath());
        Assert.assertEquals((Object)order, (Object)record.getDestOrder());
        RemoveMountTableEntryRequest removeRequest = RemoveMountTableEntryRequest.newInstance((String)mnt);
        RemoveMountTableEntryResponse removeResponse = mountTable.removeMountTableEntry(removeRequest);
        Assert.assertTrue((boolean)removeResponse.getStatus());
    }

    @Test
    public void testRemoveMountTable() throws IOException {
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTable = client.getMountTableManager();
        List<MountTable> entries1 = this.getMountTableEntries(mountTable);
        Assert.assertEquals((long)entries1.size(), (long)mockMountTable.size());
        RemoveMountTableEntryRequest removeRequest = RemoveMountTableEntryRequest.newInstance((String)"/");
        mountTable.removeMountTableEntry(removeRequest);
        List<MountTable> entries2 = this.getMountTableEntries(mountTable);
        Assert.assertEquals((long)entries2.size(), (long)(mockMountTable.size() - 1));
    }

    @Test
    public void testEditMountTable() throws IOException {
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTable = client.getMountTableManager();
        MountTable entry = this.getMountTableEntry("/");
        Assert.assertEquals(Collections.singletonList(new RemoteLocation("ns0", "/", "/")), (Object)entry.getDestinations());
        MountTable updatedEntry = MountTable.newInstance((String)"/", Collections.singletonMap("ns1", "/"), (long)Time.now(), (long)Time.now());
        UpdateMountTableEntryRequest updateRequest = UpdateMountTableEntryRequest.newInstance((MountTable)updatedEntry);
        mountTable.updateMountTableEntry(updateRequest);
        entry = this.getMountTableEntry("/");
        Assert.assertEquals(Collections.singletonList(new RemoteLocation("ns1", "/", "/")), (Object)entry.getDestinations());
    }

    @Test
    public void testGetMountTable() throws IOException {
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTable = client.getMountTableManager();
        List<MountTable> entries = this.getMountTableEntries(mountTable);
        Assert.assertEquals((long)mockMountTable.size(), (long)entries.size());
        int matches = 0;
        for (MountTable e : entries) {
            for (MountTable entry : mockMountTable) {
                Assert.assertEquals((long)e.getDestinations().size(), (long)1L);
                Assert.assertNotNull((Object)e.getDateCreated());
                Assert.assertNotNull((Object)e.getDateModified());
                if (!entry.getSourcePath().equals(e.getSourcePath())) continue;
                ++matches;
            }
        }
        Assert.assertEquals((long)matches, (long)mockMountTable.size());
    }

    @Test
    public void testGetSingleMountTableEntry() throws IOException {
        MountTable entry = this.getMountTableEntry("/ns0");
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)entry.getSourcePath(), (Object)"/ns0");
    }

    @Test
    public void testVerifyFileInDestinations() throws IOException {
        MountTable newEntry = MountTable.newInstance((String)"/testpath", Collections.singletonMap("ns0", "/testdir"), (long)Time.now(), (long)Time.now());
        RouterAdminServer adminServer = routerContext.getRouter().getAdminServer();
        List result = adminServer.verifyFileInDestinations(newEntry);
        Assert.assertEquals((long)0L, (long)result.size());
        newEntry = MountTable.newInstance((String)"/testpath", Collections.singletonMap("ns0", "/testdir1"), (long)Time.now(), (long)Time.now());
        result = adminServer.verifyFileInDestinations(newEntry);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"ns0", result.get(0));
    }

    private MountTable getMountTableEntry(String mount) throws IOException {
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesRequest request = GetMountTableEntriesRequest.newInstance((String)mount);
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTable = client.getMountTableManager();
        List<MountTable> results = this.getMountTableEntries(mountTable, request);
        if (results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    private List<MountTable> getMountTableEntries(MountTableManager mountTable) throws IOException {
        GetMountTableEntriesRequest request = GetMountTableEntriesRequest.newInstance((String)"/");
        return this.getMountTableEntries(mountTable, request);
    }

    private List<MountTable> getMountTableEntries(MountTableManager mountTable, GetMountTableEntriesRequest request) throws IOException {
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesResponse response = mountTable.getMountTableEntries(request);
        return response.getEntries();
    }

    @Test
    public void testNameserviceManager() throws IOException {
        RouterClient client = routerContext.getAdminClient();
        NameserviceManager nsManager = client.getNameserviceManager();
        Set<String> disabled = this.getDisabledNameservices(nsManager);
        Assert.assertTrue((boolean)disabled.isEmpty());
        DisableNameserviceRequest disableReq = DisableNameserviceRequest.newInstance((String)"ns0");
        DisableNameserviceResponse disableResp = nsManager.disableNameservice(disableReq);
        Assert.assertTrue((boolean)disableResp.getStatus());
        disabled = this.getDisabledNameservices(nsManager);
        Assert.assertEquals((long)1L, (long)disabled.size());
        Assert.assertTrue((boolean)disabled.contains("ns0"));
        EnableNameserviceRequest enableReq = EnableNameserviceRequest.newInstance((String)"ns0");
        EnableNameserviceResponse enableResp = nsManager.enableNameservice(enableReq);
        Assert.assertTrue((boolean)enableResp.getStatus());
        disabled = this.getDisabledNameservices(nsManager);
        Assert.assertTrue((boolean)disabled.isEmpty());
        disableReq = DisableNameserviceRequest.newInstance((String)"nsunknown");
        disableResp = nsManager.disableNameservice(disableReq);
        Assert.assertFalse((boolean)disableResp.getStatus());
    }

    private DisableNameserviceResponse testNameserviceManagerUser(String username) throws Exception {
        UserGroupInformation user = UserGroupInformation.createRemoteUser((String)username);
        return (DisableNameserviceResponse)user.doAs(() -> {
            RouterClient client = routerContext.getAdminClient();
            NameserviceManager nameservices = client.getNameserviceManager();
            DisableNameserviceRequest disableReq = DisableNameserviceRequest.newInstance((String)"ns0");
            return nameservices.disableNameservice(disableReq);
        });
    }

    @Test
    public void testNameserviceManagerUnauthorized() throws Exception {
        String username = "baduser";
        LambdaTestUtils.intercept(IOException.class, (String)(username + " is not a super user"), () -> this.testNameserviceManagerUser(username));
    }

    @Test
    public void testNameserviceManagerWithRules() throws Exception {
        String username = RouterAdminServer.getSuperUser() + "@Example.com";
        DisableNameserviceResponse disableResp = this.testNameserviceManagerUser(username);
        Assert.assertTrue((boolean)disableResp.getStatus());
    }

    private Set<String> getDisabledNameservices(NameserviceManager nsManager) throws IOException {
        stateStore.loadCache(DisabledNameserviceStoreImpl.class, true);
        GetDisabledNameservicesRequest getReq = GetDisabledNameservicesRequest.newInstance();
        GetDisabledNameservicesResponse response = nsManager.getDisabledNameservices(getReq);
        return response.getNameservices();
    }
}

