/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.application;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnHelper;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.GenericConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.LongConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ValueConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.Attribute;

public enum ApplicationColumnPrefix implements ColumnPrefix<ApplicationTable>
{
    IS_RELATED_TO(ApplicationColumnFamily.INFO, "s"),
    RELATES_TO(ApplicationColumnFamily.INFO, "r"),
    INFO(ApplicationColumnFamily.INFO, "i"),
    EVENT(ApplicationColumnFamily.INFO, "e"),
    CONFIG(ApplicationColumnFamily.CONFIGS, null),
    METRIC(ApplicationColumnFamily.METRICS, null, new LongConverter());

    private final ColumnFamily<ApplicationTable> columnFamily;
    private final String columnPrefix;
    private final byte[] columnPrefixBytes;
    private final ValueConverter valueConverter;

    private ApplicationColumnPrefix(ColumnFamily<ApplicationTable> columnFamily, String columnPrefix) {
        this(columnFamily, columnPrefix, GenericConverter.getInstance());
    }

    private ApplicationColumnPrefix(ColumnFamily<ApplicationTable> columnFamily, String columnPrefix, ValueConverter converter) {
        this.valueConverter = converter;
        this.columnFamily = columnFamily;
        this.columnPrefix = columnPrefix;
        this.columnPrefixBytes = (byte[])(columnPrefix == null ? null : Bytes.toBytes((String)Separator.SPACE.encode(columnPrefix)));
    }

    private String getColumnPrefix() {
        return this.columnPrefix;
    }

    @Override
    public byte[] getColumnPrefixBytes(byte[] qualifierPrefix) {
        return ColumnHelper.getColumnQualifier(this.columnPrefixBytes, qualifierPrefix);
    }

    @Override
    public byte[] getColumnPrefixBytes(String qualifierPrefix) {
        return ColumnHelper.getColumnQualifier(this.columnPrefixBytes, qualifierPrefix);
    }

    @Override
    public byte[] getColumnFamilyBytes() {
        return this.columnFamily.getBytes();
    }

    @Override
    public byte[] getColumnPrefixInBytes() {
        return this.columnPrefixBytes != null ? (byte[])this.columnPrefixBytes.clone() : null;
    }

    @Override
    public Attribute[] getCombinedAttrsWithAggr(Attribute ... attributes) {
        return attributes;
    }

    @Override
    public boolean supplementCellTimeStamp() {
        return false;
    }

    @Override
    public ValueConverter getValueConverter() {
        return this.valueConverter;
    }
}

