/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.startupprogress;

import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgressMetrics;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgressTestHelper;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestStartupProgressMetrics {
    private StartupProgress startupProgress;
    private StartupProgressMetrics metrics;

    @Before
    public void setUp() {
        MetricsAsserts.mockMetricsSystem();
        this.startupProgress = new StartupProgress();
        this.metrics = new StartupProgressMetrics(this.startupProgress);
    }

    @Test
    public void testInitialState() {
        MetricsRecordBuilder builder = MetricsAsserts.getMetrics((MetricsSource)this.metrics, (boolean)true);
        MetricsAsserts.assertCounter((String)"ElapsedTime", (long)0L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertGauge((String)"PercentComplete", (float)0.0f, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertCounter((String)"LoadingFsImageCount", (long)0L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertCounter((String)"LoadingFsImageElapsedTime", (long)0L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertCounter((String)"LoadingFsImageTotal", (long)0L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertGauge((String)"LoadingFsImagePercentComplete", (float)0.0f, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertCounter((String)"LoadingEditsCount", (long)0L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertCounter((String)"LoadingEditsElapsedTime", (long)0L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertCounter((String)"LoadingEditsTotal", (long)0L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertGauge((String)"LoadingEditsPercentComplete", (float)0.0f, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertCounter((String)"SavingCheckpointCount", (long)0L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertCounter((String)"SavingCheckpointElapsedTime", (long)0L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertCounter((String)"SavingCheckpointTotal", (long)0L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertGauge((String)"SavingCheckpointPercentComplete", (float)0.0f, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertCounter((String)"SafeModeCount", (long)0L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertCounter((String)"SafeModeElapsedTime", (long)0L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertCounter((String)"SafeModeTotal", (long)0L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertGauge((String)"SafeModePercentComplete", (float)0.0f, (MetricsRecordBuilder)builder);
    }

    @Test
    public void testRunningState() {
        StartupProgressTestHelper.setStartupProgressForRunningState(this.startupProgress);
        MetricsRecordBuilder builder = MetricsAsserts.getMetrics((MetricsSource)this.metrics, (boolean)true);
        Assert.assertTrue((MetricsAsserts.getLongCounter((String)"ElapsedTime", (MetricsRecordBuilder)builder) >= 0L ? 1 : 0) != 0);
        MetricsAsserts.assertGauge((String)"PercentComplete", (float)0.375f, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertCounter((String)"LoadingFsImageCount", (long)100L, (MetricsRecordBuilder)builder);
        Assert.assertTrue((MetricsAsserts.getLongCounter((String)"LoadingFsImageElapsedTime", (MetricsRecordBuilder)builder) >= 0L ? 1 : 0) != 0);
        MetricsAsserts.assertCounter((String)"LoadingFsImageTotal", (long)100L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertGauge((String)"LoadingFsImagePercentComplete", (float)1.0f, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertCounter((String)"LoadingEditsCount", (long)100L, (MetricsRecordBuilder)builder);
        Assert.assertTrue((MetricsAsserts.getLongCounter((String)"LoadingEditsElapsedTime", (MetricsRecordBuilder)builder) >= 0L ? 1 : 0) != 0);
        MetricsAsserts.assertCounter((String)"LoadingEditsTotal", (long)200L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertGauge((String)"LoadingEditsPercentComplete", (float)0.5f, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertCounter((String)"SavingCheckpointCount", (long)0L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertCounter((String)"SavingCheckpointElapsedTime", (long)0L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertCounter((String)"SavingCheckpointTotal", (long)0L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertGauge((String)"SavingCheckpointPercentComplete", (float)0.0f, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertCounter((String)"SafeModeCount", (long)0L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertCounter((String)"SafeModeElapsedTime", (long)0L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertCounter((String)"SafeModeTotal", (long)0L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertGauge((String)"SafeModePercentComplete", (float)0.0f, (MetricsRecordBuilder)builder);
    }

    @Test
    public void testFinalState() {
        StartupProgressTestHelper.setStartupProgressForFinalState(this.startupProgress);
        MetricsRecordBuilder builder = MetricsAsserts.getMetrics((MetricsSource)this.metrics, (boolean)true);
        Assert.assertTrue((MetricsAsserts.getLongCounter((String)"ElapsedTime", (MetricsRecordBuilder)builder) >= 0L ? 1 : 0) != 0);
        MetricsAsserts.assertGauge((String)"PercentComplete", (float)1.0f, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertCounter((String)"LoadingFsImageCount", (long)100L, (MetricsRecordBuilder)builder);
        Assert.assertTrue((MetricsAsserts.getLongCounter((String)"LoadingFsImageElapsedTime", (MetricsRecordBuilder)builder) >= 0L ? 1 : 0) != 0);
        MetricsAsserts.assertCounter((String)"LoadingFsImageTotal", (long)100L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertGauge((String)"LoadingFsImagePercentComplete", (float)1.0f, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertCounter((String)"LoadingEditsCount", (long)200L, (MetricsRecordBuilder)builder);
        Assert.assertTrue((MetricsAsserts.getLongCounter((String)"LoadingEditsElapsedTime", (MetricsRecordBuilder)builder) >= 0L ? 1 : 0) != 0);
        MetricsAsserts.assertCounter((String)"LoadingEditsTotal", (long)200L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertGauge((String)"LoadingEditsPercentComplete", (float)1.0f, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertCounter((String)"SavingCheckpointCount", (long)300L, (MetricsRecordBuilder)builder);
        Assert.assertTrue((MetricsAsserts.getLongCounter((String)"SavingCheckpointElapsedTime", (MetricsRecordBuilder)builder) >= 0L ? 1 : 0) != 0);
        MetricsAsserts.assertCounter((String)"SavingCheckpointTotal", (long)300L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertGauge((String)"SavingCheckpointPercentComplete", (float)1.0f, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertCounter((String)"SafeModeCount", (long)400L, (MetricsRecordBuilder)builder);
        Assert.assertTrue((MetricsAsserts.getLongCounter((String)"SafeModeElapsedTime", (MetricsRecordBuilder)builder) >= 0L ? 1 : 0) != 0);
        MetricsAsserts.assertCounter((String)"SafeModeTotal", (long)400L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertGauge((String)"SafeModePercentComplete", (float)1.0f, (MetricsRecordBuilder)builder);
    }
}

