/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NNThroughputBenchmark;
import org.apache.hadoop.util.ExitUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestNNThroughputBenchmark {
    @BeforeClass
    public static void setUp() {
        ExitUtil.disableSystemExit();
    }

    @After
    public void cleanUp() {
        FileUtil.fullyDeleteContents((File)new File(MiniDFSCluster.getBaseDirectory()));
    }

    @Test
    public void testNNThroughput() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.blocksize", 16);
        File nameDir = new File(MiniDFSCluster.getBaseDirectory(), "name");
        conf.set("dfs.namenode.name.dir", nameDir.getAbsolutePath());
        DFSTestUtil.formatNameNode((Configuration)conf);
        NNThroughputBenchmark.runBenchmark((Configuration)conf, new String[]{"-op", "all"});
    }

    @Test(timeout=120000L)
    public void testNNThroughputWithFsOption() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.blocksize", 16);
        File nameDir = new File(MiniDFSCluster.getBaseDirectory(), "name");
        conf.set("dfs.namenode.name.dir", nameDir.getAbsolutePath());
        DFSTestUtil.formatNameNode((Configuration)conf);
        NNThroughputBenchmark.runBenchmark((Configuration)conf, new String[]{"-fs", "file:///", "-op", "all"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testNNThroughputAgainstRemoteNN() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.fs-limits.min-block-size", 16);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            HdfsConfiguration benchConf = new HdfsConfiguration();
            benchConf.setInt("dfs.blocksize", 16);
            FileSystem.setDefaultUri((Configuration)benchConf, (URI)cluster.getURI());
            NNThroughputBenchmark.runBenchmark((Configuration)benchConf, new String[]{"-op", "all"});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testNNThroughputRemoteAgainstNNWithFsOption() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.fs-limits.min-block-size", 16);
        conf.setInt("dfs.blocksize", 16);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            HdfsConfiguration benchConf = new HdfsConfiguration();
            benchConf.setInt("dfs.blocksize", 16);
            NNThroughputBenchmark.runBenchmark((Configuration)benchConf, new String[]{"-fs", cluster.getURI().toString(), "-op", "all"});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testNNThroughputForAppendOp() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.fs-limits.min-block-size", 16);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            HdfsConfiguration benchConf = new HdfsConfiguration();
            benchConf.setInt("dfs.blocksize", 16);
            FileSystem.setDefaultUri((Configuration)benchConf, (URI)cluster.getURI());
            NNThroughputBenchmark.runBenchmark((Configuration)benchConf, new String[]{"-op", "create", "-keepResults", "-files", "3", "-close"});
            FSNamesystem fsNamesystem = cluster.getNamesystem();
            DirectoryListing listing = fsNamesystem.getListing("/", HdfsFileStatus.EMPTY_NAME, false);
            HdfsFileStatus[] partialListing = listing.getPartialListing();
            NNThroughputBenchmark.runBenchmark((Configuration)benchConf, new String[]{"-op", "append", "-files", "3", "-useExisting"});
            listing = fsNamesystem.getListing("/", HdfsFileStatus.EMPTY_NAME, false);
            HdfsFileStatus[] partialListingAfter = listing.getPartialListing();
            Assert.assertEquals((long)partialListing.length, (long)partialListingAfter.length);
            for (int i = 0; i < partialListing.length; ++i) {
                Assert.assertNotEquals((long)partialListing[i].getModificationTime(), (long)partialListingAfter[i].getModificationTime());
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test(timeout=120000L)
    public void testNNThroughputForBlockReportOp() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.fs-limits.min-block-size", 16);
        conf.setInt("dfs.blocksize", 16);
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();){
            cluster.waitActive();
            HdfsConfiguration benchConf = new HdfsConfiguration();
            benchConf.setInt("dfs.namenode.fs-limits.min-block-size", 16);
            benchConf.setInt("dfs.blocksize", 16);
            NNThroughputBenchmark.runBenchmark((Configuration)benchConf, new String[]{"-fs", cluster.getURI().toString(), "-op", "blockReport", "-datanodes", "3", "-reports", "2"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testNNThroughputWithBaseDir() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.fs-limits.min-block-size", 16);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            HdfsConfiguration benchConf = new HdfsConfiguration();
            benchConf.setInt("dfs.blocksize", 16);
            FileSystem.setDefaultUri((Configuration)benchConf, (URI)cluster.getURI());
            DistributedFileSystem fs = cluster.getFileSystem();
            NNThroughputBenchmark.runBenchmark((Configuration)benchConf, new String[]{"-op", "create", "-keepResults", "-files", "3", "-baseDirName", "/nnThroughputBenchmark1", "-close"});
            Assert.assertTrue((boolean)fs.exists(new Path("/nnThroughputBenchmark1")));
            Assert.assertFalse((boolean)fs.exists(new Path("/nnThroughputBenchmark")));
            NNThroughputBenchmark.runBenchmark((Configuration)benchConf, new String[]{"-op", "all", "-baseDirName", "/nnThroughputBenchmark1"});
            Assert.assertTrue((boolean)fs.exists(new Path("/nnThroughputBenchmark1")));
            Assert.assertFalse((boolean)fs.exists(new Path("/nnThroughputBenchmark")));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

