/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.io.MD5Hash;

public class ConsistentHashRing {
    private static final String SEPARATOR = "/";
    private static final String VIRTUAL_NODE_FORMAT = "%s/%d";
    private SortedMap<String, String> ring = new TreeMap<String, String>();
    private Map<String, Integer> entryToVirtualNodes = new HashMap<String, Integer>();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();

    public ConsistentHashRing(Set<String> locations) {
        for (String location : locations) {
            this.addLocation(location);
        }
    }

    public void addLocation(String location) {
        this.addLocation(location, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocation(String location, int numVirtualNodes) {
        this.writeLock.lock();
        try {
            this.entryToVirtualNodes.put(location, numVirtualNodes);
            for (int i = 0; i < numVirtualNodes; ++i) {
                String key = String.format(VIRTUAL_NODE_FORMAT, location, i);
                String hash = this.getHash(key);
                this.ring.put(hash, key);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocation(String location) {
        this.writeLock.lock();
        try {
            Integer numVirtualNodes = this.entryToVirtualNodes.remove(location);
            for (int i = 0; i < numVirtualNodes; ++i) {
                String key = String.format(VIRTUAL_NODE_FORMAT, location, i);
                String hash = this.getHash(key);
                this.ring.remove(hash);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocation(String item) {
        this.readLock.lock();
        try {
            String virtualNode;
            int index;
            if (this.ring.isEmpty()) {
                String string = null;
                return string;
            }
            String hash = this.getHash(item);
            if (!this.ring.containsKey(hash)) {
                SortedMap<String, String> tailMap = this.ring.tailMap(hash);
                String string = hash = tailMap.isEmpty() ? this.ring.firstKey() : tailMap.firstKey();
            }
            if ((index = (virtualNode = (String)this.ring.get(hash)).lastIndexOf(SEPARATOR)) >= 0) {
                String string = virtualNode.substring(0, index);
                return string;
            }
            String string = virtualNode;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getHash(String key) {
        return MD5Hash.digest((String)key).toString();
    }

    public Set<String> getLocations() {
        return this.entryToVirtualNodes.keySet();
    }
}

