/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.util.Locale;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.util.ConfigurationHelper;
import software.amazon.awssdk.services.s3.model.ChecksumAlgorithm;

public final class ChecksumSupport {
    public static final String NONE = "NONE";
    public static final String CRC32C = "CRC32C";
    public static final String CRC64NVME = "CRC64NVME";
    private static final Set<ChecksumAlgorithm> SUPPORTED_CHECKSUM_ALGORITHMS = ImmutableSet.of((Object)ChecksumAlgorithm.CRC32, (Object)ChecksumAlgorithm.CRC32_C, (Object)ChecksumAlgorithm.CRC64_NVME, (Object)ChecksumAlgorithm.SHA1, (Object)ChecksumAlgorithm.SHA256);

    private ChecksumSupport() {
    }

    public static ChecksumAlgorithm getChecksumAlgorithm(Configuration conf) {
        return (ChecksumAlgorithm)ConfigurationHelper.resolveEnum((Configuration)conf, (String)"fs.s3a.create.checksum.algorithm", ChecksumAlgorithm.class, configValue -> {
            String val;
            switch (val = configValue == null ? NONE : configValue.toUpperCase(Locale.ROOT)) {
                case "": 
                case "NONE": {
                    return null;
                }
                case "CRC32C": {
                    return ChecksumAlgorithm.CRC32_C;
                }
                case "CRC64NVME": {
                    return ChecksumAlgorithm.CRC64_NVME;
                }
            }
            throw new IllegalArgumentException("Checksum algorithm is not supported: " + configValue);
        });
    }
}

