/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.router;

import java.util.Map;
import org.apache.hadoop.shaded.org.codehaus.jettison.json.JSONException;
import org.apache.hadoop.shaded.org.codehaus.jettison.json.JSONObject;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContext;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyException;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.policies.router.AbstractRouterPolicy;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;

public class LoadBasedRouterPolicy
extends AbstractRouterPolicy {
    @Override
    public void reinitialize(FederationPolicyInitializationContext policyContext) throws FederationPolicyInitializationException {
        WeightedPolicyInfo tempPolicy = this.getPolicyInfo();
        super.reinitialize(policyContext);
        for (Float weight : this.getPolicyInfo().getRouterPolicyWeights().values()) {
            if (weight.floatValue() == 0.0f || weight.floatValue() == 1.0f) continue;
            this.setPolicyInfo(tempPolicy);
            throw new FederationPolicyInitializationException(this.getClass().getCanonicalName() + " policy expects all weights to be either \"0\" or \"1\"");
        }
    }

    @Override
    protected SubClusterId chooseSubCluster(String queue, Map<SubClusterId, SubClusterInfo> preSelectSubclusters) throws YarnException {
        Map<SubClusterIdInfo, Float> weights = this.getPolicyInfo().getRouterPolicyWeights();
        SubClusterIdInfo chosen = null;
        long currBestMem = -1L;
        for (Map.Entry<SubClusterId, SubClusterInfo> entry : preSelectSubclusters.entrySet()) {
            long availableMemory;
            SubClusterIdInfo id = new SubClusterIdInfo(entry.getKey());
            if (!weights.containsKey(id) || !(weights.get(id).floatValue() > 0.0f) || (availableMemory = this.getAvailableMemory(entry.getValue())) <= currBestMem) continue;
            currBestMem = availableMemory;
            chosen = id;
        }
        if (chosen == null) {
            throw new FederationPolicyException("Zero Active Subcluster with weight 1.");
        }
        return chosen.toId();
    }

    private long getAvailableMemory(SubClusterInfo value) throws YarnException {
        try {
            long mem = -1L;
            JSONObject obj = new JSONObject(value.getCapability());
            mem = obj.getJSONObject("clusterMetrics").getLong("availableMB");
            return mem;
        }
        catch (JSONException j) {
            throw new YarnException("FederationSubClusterInfo cannot be parsed", (Throwable)j);
        }
    }
}

