/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.shaded.dev.failsafe.internal;

import software.amazon.s3.shaded.dev.failsafe.CircuitBreakerOpenException;
import software.amazon.s3.shaded.dev.failsafe.ExecutionContext;
import software.amazon.s3.shaded.dev.failsafe.internal.CircuitBreakerImpl;
import software.amazon.s3.shaded.dev.failsafe.spi.ExecutionResult;
import software.amazon.s3.shaded.dev.failsafe.spi.PolicyExecutor;

public class CircuitBreakerExecutor<R>
extends PolicyExecutor<R> {
    private final CircuitBreakerImpl<R> circuitBreaker;

    public CircuitBreakerExecutor(CircuitBreakerImpl<R> circuitBreaker, int policyIndex) {
        super(circuitBreaker, policyIndex);
        this.circuitBreaker = circuitBreaker;
    }

    @Override
    protected ExecutionResult<R> preExecute() {
        return this.circuitBreaker.tryAcquirePermit() ? null : ExecutionResult.exception(new CircuitBreakerOpenException(this.circuitBreaker));
    }

    @Override
    public void onSuccess(ExecutionResult<R> result) {
        this.circuitBreaker.recordSuccess();
    }

    @Override
    protected ExecutionResult<R> onFailure(ExecutionContext<R> context, ExecutionResult<R> result) {
        this.circuitBreaker.recordExecutionFailure(context);
        return result;
    }
}

