/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Buffer;
import org.apache.hadoop.shaded.org.glassfish.grizzly.ConnectionProbe;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import org.apache.hadoop.shaded.org.glassfish.grizzly.localization.LogMessages;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.NIOConnection;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.SelectorRunner;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.transport.UDPNIOTransport;

public class UDPNIOConnection
extends NIOConnection {
    private static final Logger LOGGER = Grizzly.logger(UDPNIOConnection.class);
    private SocketAddress localSocketAddress;
    private SocketAddress peerSocketAddress;

    public UDPNIOConnection(UDPNIOTransport transport, DatagramChannel channel) {
        super(transport);
        this.channel = channel;
        this.resetProperties();
    }

    public boolean isConnected() {
        return this.channel != null && ((DatagramChannel)this.channel).isConnected();
    }

    @Override
    protected void setSelectionKey(SelectionKey selectionKey) {
        super.setSelectionKey(selectionKey);
    }

    @Override
    protected void setSelectorRunner(SelectorRunner selectorRunner) {
        super.setSelectorRunner(selectorRunner);
    }

    protected boolean notifyReady() {
        return this.connectCloseSemaphor.compareAndSet(null, NOTIFICATION_INITIALIZED);
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.peerSocketAddress;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.localSocketAddress;
    }

    protected final void resetProperties() {
        if (this.channel != null) {
            this.setReadBufferSize(this.transport.getReadBufferSize());
            this.setWriteBufferSize(this.transport.getWriteBufferSize());
            int transportMaxAsyncWriteQueueSize = ((UDPNIOTransport)this.transport).getAsyncQueueIO().getWriter().getMaxPendingBytesPerConnection();
            this.setMaxAsyncWriteQueueSize(transportMaxAsyncWriteQueueSize == -2 ? this.getWriteBufferSize() * 4 : transportMaxAsyncWriteQueueSize);
            this.localSocketAddress = ((DatagramChannel)this.channel).socket().getLocalSocketAddress();
            this.peerSocketAddress = ((DatagramChannel)this.channel).socket().getRemoteSocketAddress();
        }
    }

    @Override
    public void setReadBufferSize(int readBufferSize) {
        DatagramSocket socket = ((DatagramChannel)this.channel).socket();
        try {
            int socketReadBufferSize = socket.getReceiveBufferSize();
            if (readBufferSize != -1) {
                if (readBufferSize > socketReadBufferSize) {
                    socket.setReceiveBufferSize(readBufferSize);
                }
                super.setReadBufferSize(readBufferSize);
            } else {
                super.setReadBufferSize(socketReadBufferSize);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_CONNECTION_SET_READBUFFER_SIZE_EXCEPTION(), e);
        }
    }

    @Override
    public void setWriteBufferSize(int writeBufferSize) {
        DatagramSocket socket = ((DatagramChannel)this.channel).socket();
        try {
            int socketWriteBufferSize = socket.getSendBufferSize();
            if (writeBufferSize != -1) {
                if (writeBufferSize > socketWriteBufferSize) {
                    socket.setSendBufferSize(writeBufferSize);
                }
                super.setWriteBufferSize(writeBufferSize);
            } else {
                super.setWriteBufferSize(socketWriteBufferSize);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_CONNECTION_SET_WRITEBUFFER_SIZE_EXCEPTION(), e);
        }
    }

    protected final void onConnect() throws IOException {
        UDPNIOConnection.notifyProbesConnect(this);
    }

    protected final void onRead(Buffer data, int size) {
        if (size > 0) {
            UDPNIOConnection.notifyProbesRead(this, data, size);
        }
        this.checkEmptyRead(size);
    }

    protected final void onWrite(Buffer data, int size) {
        UDPNIOConnection.notifyProbesWrite(this, data, size);
    }

    void setMonitoringProbes(ConnectionProbe[] monitoringProbes) {
        this.monitoringConfig.addProbes(monitoringProbes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UDPNIOConnection");
        sb.append("{localSocketAddress=").append(this.localSocketAddress);
        sb.append(", peerSocketAddress=").append(this.peerSocketAddress);
        sb.append('}');
        return sb.toString();
    }
}

