/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.recovery;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.timeline.recovery.TimelineStateStore;

public class MemoryTimelineStateStore
extends TimelineStateStore {
    private TimelineStateStore.TimelineServiceState state;

    @Override
    protected void initStorage(Configuration conf) throws IOException {
    }

    @Override
    protected void startStorage() throws IOException {
        this.state = new TimelineStateStore.TimelineServiceState();
    }

    @Override
    protected void closeStorage() throws IOException {
        this.state = null;
    }

    @Override
    public TimelineStateStore.TimelineServiceState loadState() throws IOException {
        TimelineStateStore.TimelineServiceState result = new TimelineStateStore.TimelineServiceState();
        result.tokenState.putAll(this.state.tokenState);
        result.tokenMasterKeyState.addAll(this.state.tokenMasterKeyState);
        result.latestSequenceNumber = this.state.latestSequenceNumber;
        return result;
    }

    @Override
    public void storeToken(TimelineDelegationTokenIdentifier tokenId, Long renewDate) throws IOException {
        if (this.state.tokenState.containsKey(tokenId)) {
            throw new IOException("token " + tokenId + " was stored twice");
        }
        this.state.tokenState.put(tokenId, renewDate);
        this.state.latestSequenceNumber = tokenId.getSequenceNumber();
    }

    @Override
    public void updateToken(TimelineDelegationTokenIdentifier tokenId, Long renewDate) throws IOException {
        if (!this.state.tokenState.containsKey(tokenId)) {
            throw new IOException("token " + tokenId + " not in store");
        }
        this.state.tokenState.put(tokenId, renewDate);
    }

    @Override
    public void removeToken(TimelineDelegationTokenIdentifier tokenId) throws IOException {
        this.state.tokenState.remove(tokenId);
    }

    @Override
    public void storeTokenMasterKey(DelegationKey key) throws IOException {
        if (this.state.tokenMasterKeyState.contains(key)) {
            throw new IOException("token master key " + key + " was stored twice");
        }
        this.state.tokenMasterKeyState.add(key);
    }

    @Override
    public void removeTokenMasterKey(DelegationKey key) throws IOException {
        this.state.tokenMasterKeyState.remove(key);
    }
}

