/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.distributed;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoteNode;
import org.apache.hadoop.yarn.server.metrics.OpportunisticSchedulerMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.distributed.NodeQueueLoadMonitor;
import org.apache.hadoop.yarn.server.scheduler.OpportunisticContainerAllocator;
import org.apache.hadoop.yarn.server.scheduler.OpportunisticContainerContext;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.server.security.BaseContainerTokenSecretManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CentralizedOpportunisticContainerAllocator
extends OpportunisticContainerAllocator {
    private static final Logger LOG = LoggerFactory.getLogger(CentralizedOpportunisticContainerAllocator.class);
    private NodeQueueLoadMonitor nodeQueueLoadMonitor;
    private OpportunisticSchedulerMetrics metrics = OpportunisticSchedulerMetrics.getMetrics();

    public CentralizedOpportunisticContainerAllocator(BaseContainerTokenSecretManager tokenSecretManager) {
        super(tokenSecretManager);
    }

    public CentralizedOpportunisticContainerAllocator(BaseContainerTokenSecretManager tokenSecretManager, int maxAllocationsPerAMHeartbeat, NodeQueueLoadMonitor nodeQueueLoadMonitor) {
        super(tokenSecretManager, maxAllocationsPerAMHeartbeat);
        this.nodeQueueLoadMonitor = nodeQueueLoadMonitor;
    }

    @VisibleForTesting
    void setNodeQueueLoadMonitor(NodeQueueLoadMonitor nodeQueueLoadMonitor) {
        this.nodeQueueLoadMonitor = nodeQueueLoadMonitor;
    }

    public List<Container> allocateContainers(ResourceBlacklistRequest blackList, List<ResourceRequest> oppResourceReqs, ApplicationAttemptId applicationAttemptId, OpportunisticContainerContext opportContext, long rmIdentifier, String appSubmitter) throws YarnException {
        this.updateBlacklist(blackList, opportContext);
        opportContext.addToOutstandingReqs(oppResourceReqs);
        HashSet<String> nodeBlackList = new HashSet<String>(opportContext.getBlacklist());
        ArrayList<Container> allocatedContainers = new ArrayList<Container>();
        int maxAllocationsPerAMHeartbeat = this.getMaxAllocationsPerAMHeartbeat();
        ArrayList<Map<Resource, List<OpportunisticContainerAllocator.Allocation>>> allocations = new ArrayList<Map<Resource, List<OpportunisticContainerAllocator.Allocation>>>();
        for (SchedulerRequestKey schedulerKey : opportContext.getOutstandingOpReqs().descendingKeySet()) {
            int remAllocs = -1;
            if (maxAllocationsPerAMHeartbeat > 0 && (remAllocs = maxAllocationsPerAMHeartbeat - this.getTotalAllocations(allocations)) <= 0) {
                LOG.info("Not allocating more containers as we have reached max allocations per AM heartbeat {}", (Object)maxAllocationsPerAMHeartbeat);
                break;
            }
            Map<Resource, List<OpportunisticContainerAllocator.Allocation>> allocation = this.allocatePerSchedulerKey(rmIdentifier, opportContext, schedulerKey, applicationAttemptId, appSubmitter, nodeBlackList, remAllocs);
            if (allocation.size() <= 0) continue;
            allocations.add(allocation);
        }
        this.matchAllocation(allocations, allocatedContainers, opportContext);
        return allocatedContainers;
    }

    private Map<Resource, List<OpportunisticContainerAllocator.Allocation>> allocatePerSchedulerKey(long rmIdentifier, OpportunisticContainerContext appContext, SchedulerRequestKey schedKey, ApplicationAttemptId appAttId, String userName, Set<String> blackList, int maxAllocations) throws YarnException {
        HashMap<Resource, List<OpportunisticContainerAllocator.Allocation>> allocations = new HashMap<Resource, List<OpportunisticContainerAllocator.Allocation>>();
        int totalAllocated = 0;
        for (OpportunisticContainerAllocator.EnrichedResourceRequest enrichedAsk : ((Map)appContext.getOutstandingOpReqs().get(schedKey)).values()) {
            int remainingAllocs = -1;
            if (maxAllocations > 0 && (remainingAllocs = maxAllocations - totalAllocated) <= 0) {
                LOG.info("Not allocating more containers as max allocations per AM heartbeat {} has reached", (Object)this.getMaxAllocationsPerAMHeartbeat());
                break;
            }
            totalAllocated += this.allocateContainersPerRequest(rmIdentifier, appContext.getAppParams(), appContext.getContainerIdGenerator(), blackList, appAttId, userName, allocations, enrichedAsk, remainingAllocs);
            ResourceRequest anyAsk = enrichedAsk.getRequest();
            if (allocations.isEmpty()) continue;
            LOG.info("Opportunistic allocation requested for [priority={}, allocationRequestId={}, num_containers={}, capability={}] allocated = {}", new Object[]{anyAsk.getPriority(), anyAsk.getAllocationRequestId(), anyAsk.getNumContainers(), anyAsk.getCapability(), allocations.keySet()});
        }
        return allocations;
    }

    private int allocateContainersPerRequest(long rmIdentifier, OpportunisticContainerAllocator.AllocationParams appParams, OpportunisticContainerAllocator.ContainerIdGenerator idCounter, Set<String> blacklist, ApplicationAttemptId id, String userName, Map<Resource, List<OpportunisticContainerAllocator.Allocation>> allocations, OpportunisticContainerAllocator.EnrichedResourceRequest enrichedAsk, int maxAllocations) throws YarnException {
        List<Container> allocatedContainers;
        int numContainers;
        ResourceRequest anyAsk = enrichedAsk.getRequest();
        int totalAllocated = 0;
        int maxToAllocate = anyAsk.getNumContainers() - (allocations.isEmpty() ? 0 : allocations.get(anyAsk.getCapability()).size());
        if (maxAllocations >= 0) {
            maxToAllocate = Math.min(maxAllocations, maxToAllocate);
        }
        if (maxToAllocate > 0) {
            Map nodeLocations = enrichedAsk.getNodeMap();
            for (Map.Entry nodeLocation : nodeLocations.entrySet()) {
                numContainers = ((AtomicInteger)nodeLocation.getValue()).get();
                numContainers = Math.min(numContainers, maxToAllocate);
                allocatedContainers = this.allocateNodeLocal(enrichedAsk, (String)nodeLocation.getKey(), numContainers, rmIdentifier, appParams, idCounter, blacklist, id, userName, allocations);
                totalAllocated += allocatedContainers.size();
                if ((maxToAllocate -= allocatedContainers.size()) > 0) continue;
                break;
            }
        }
        if (maxToAllocate > 0) {
            Map rackLocations = enrichedAsk.getRackMap();
            for (Map.Entry rack : rackLocations.entrySet()) {
                numContainers = ((AtomicInteger)rack.getValue()).get();
                numContainers = Math.min(numContainers, maxToAllocate);
                allocatedContainers = this.allocateRackLocal(enrichedAsk, (String)rack.getKey(), numContainers, rmIdentifier, appParams, idCounter, blacklist, id, userName, allocations);
                totalAllocated += allocatedContainers.size();
                if ((maxToAllocate -= allocatedContainers.size()) > 0) continue;
                break;
            }
        }
        if (maxToAllocate > 0) {
            List<Container> allocatedContainers2 = this.allocateAny(enrichedAsk, maxToAllocate, rmIdentifier, appParams, idCounter, blacklist, id, userName, allocations);
            totalAllocated += allocatedContainers2.size();
        }
        return totalAllocated;
    }

    private List<Container> allocateNodeLocal(OpportunisticContainerAllocator.EnrichedResourceRequest enrichedAsk, String nodeLocation, int toAllocate, long rmIdentifier, OpportunisticContainerAllocator.AllocationParams appParams, OpportunisticContainerAllocator.ContainerIdGenerator idCounter, Set<String> blacklist, ApplicationAttemptId id, String userName, Map<Resource, List<OpportunisticContainerAllocator.Allocation>> allocations) throws YarnException {
        RMNode node;
        ArrayList<Container> allocatedContainers = new ArrayList<Container>();
        ResourceRequest resourceRequest = enrichedAsk.getRequest();
        while (toAllocate > 0 && (node = this.nodeQueueLoadMonitor.selectLocalNode(nodeLocation, blacklist, resourceRequest.getCapability())) != null) {
            --toAllocate;
            Container container = this.createContainer(rmIdentifier, appParams, idCounter, id, userName, allocations, nodeLocation, resourceRequest, this.convertToRemoteNode(node));
            allocatedContainers.add(container);
            LOG.info("Allocated [{}] as opportunistic at location [{}]", (Object)container.getId(), (Object)nodeLocation);
            this.metrics.incrNodeLocalOppContainers();
        }
        return allocatedContainers;
    }

    private List<Container> allocateRackLocal(OpportunisticContainerAllocator.EnrichedResourceRequest enrichedAsk, String rackLocation, int toAllocate, long rmIdentifier, OpportunisticContainerAllocator.AllocationParams appParams, OpportunisticContainerAllocator.ContainerIdGenerator idCounter, Set<String> blacklist, ApplicationAttemptId id, String userName, Map<Resource, List<OpportunisticContainerAllocator.Allocation>> allocations) throws YarnException {
        RMNode node;
        ArrayList<Container> allocatedContainers = new ArrayList<Container>();
        ResourceRequest resourceRequest = enrichedAsk.getRequest();
        while (toAllocate > 0 && (node = this.nodeQueueLoadMonitor.selectRackLocalNode(rackLocation, blacklist, resourceRequest.getCapability())) != null) {
            --toAllocate;
            Container container = this.createContainer(rmIdentifier, appParams, idCounter, id, userName, allocations, rackLocation, resourceRequest, this.convertToRemoteNode(node));
            allocatedContainers.add(container);
            this.metrics.incrRackLocalOppContainers();
            LOG.info("Allocated [{}] as opportunistic at location [{}]", (Object)container.getId(), (Object)rackLocation);
        }
        return allocatedContainers;
    }

    private List<Container> allocateAny(OpportunisticContainerAllocator.EnrichedResourceRequest enrichedAsk, int toAllocate, long rmIdentifier, OpportunisticContainerAllocator.AllocationParams appParams, OpportunisticContainerAllocator.ContainerIdGenerator idCounter, Set<String> blacklist, ApplicationAttemptId id, String userName, Map<Resource, List<OpportunisticContainerAllocator.Allocation>> allocations) throws YarnException {
        RMNode node;
        ArrayList<Container> allocatedContainers = new ArrayList<Container>();
        ResourceRequest resourceRequest = enrichedAsk.getRequest();
        while (toAllocate > 0 && (node = this.nodeQueueLoadMonitor.selectAnyNode(blacklist, resourceRequest.getCapability())) != null) {
            --toAllocate;
            Container container = this.createContainer(rmIdentifier, appParams, idCounter, id, userName, allocations, "*", resourceRequest, this.convertToRemoteNode(node));
            allocatedContainers.add(container);
            this.metrics.incrOffSwitchOppContainers();
            LOG.info("Allocated [{}] as opportunistic at location [{}]", (Object)container.getId(), (Object)"*");
        }
        return allocatedContainers;
    }

    private RemoteNode convertToRemoteNode(RMNode rmNode) {
        if (rmNode != null) {
            RemoteNode rNode = RemoteNode.newInstance((NodeId)rmNode.getNodeID(), (String)rmNode.getHttpAddress());
            rNode.setRackName(rmNode.getRackName());
            return rNode;
        }
        return null;
    }
}

