/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MultiFileInputFormat;
import org.apache.hadoop.mapred.MultiFileSplit;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMultiFileInputFormat {
    private static JobConf job = new JobConf();
    private static final Logger LOG = LoggerFactory.getLogger(TestMultiFileInputFormat.class);
    private static final int MAX_SPLIT_COUNT = 10000;
    private static final int SPLIT_COUNT_INCR = 6000;
    private static final int MAX_BYTES = 1024;
    private static final int MAX_NUM_FILES = 10000;
    private static final int NUM_FILES_INCR = 8000;
    private Random rand = new Random(System.currentTimeMillis());
    private HashMap<String, Long> lengths = new HashMap();

    private Path initFiles(FileSystem fs, int numFiles, int numBytes) throws IOException {
        Path dir = new Path(System.getProperty("test.build.data", ".") + "/mapred");
        Path multiFileDir = new Path(dir, "test.multifile");
        fs.delete(multiFileDir, true);
        fs.mkdirs(multiFileDir);
        LOG.info("Creating " + numFiles + " file(s) in " + multiFileDir);
        for (int i = 0; i < numFiles; ++i) {
            Path path = new Path(multiFileDir, "file_" + i);
            FSDataOutputStream out = fs.create(path);
            if (numBytes == -1) {
                numBytes = this.rand.nextInt(1024);
            }
            for (int j = 0; j < numBytes; ++j) {
                out.write(this.rand.nextInt());
            }
            out.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created file " + path + " with length " + numBytes);
            }
            this.lengths.put(path.getName(), new Long(numBytes));
        }
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{multiFileDir});
        return multiFileDir;
    }

    @Test
    public void testFormat() throws IOException {
        LOG.info("Test started");
        LOG.info("Max split count           = 10000");
        LOG.info("Split count increment     = 6000");
        LOG.info("Max bytes per file        = 1024");
        LOG.info("Max number of files       = 10000");
        LOG.info("Number of files increment = 8000");
        DummyMultiFileInputFormat format = new DummyMultiFileInputFormat();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)job);
        for (int numFiles = 1; numFiles < 10000; numFiles += 4000 + this.rand.nextInt(4000)) {
            Path dir = this.initFiles((FileSystem)fs, numFiles, -1);
            BitSet bits = new BitSet(numFiles);
            for (int i = 1; i < 10000; i += this.rand.nextInt(6000) + 1) {
                LOG.info("Running for Num Files=" + numFiles + ", split count=" + i);
                MultiFileSplit[] splits = (MultiFileSplit[])format.getSplits(job, i);
                bits.clear();
                for (MultiFileSplit split : splits) {
                    long splitLength = 0L;
                    for (Path p : split.getPaths()) {
                        long length = fs.getContentSummary(p).getLength();
                        Assert.assertEquals((long)length, (long)this.lengths.get(p.getName()));
                        splitLength += length;
                        String name = p.getName();
                        int index = Integer.parseInt(name.substring(name.lastIndexOf("file_") + 5));
                        Assert.assertFalse((boolean)bits.get(index));
                        bits.set(index);
                    }
                    Assert.assertEquals((long)splitLength, (long)split.getLength());
                }
            }
            Assert.assertEquals((long)bits.cardinality(), (long)numFiles);
            fs.delete(dir, true);
        }
        LOG.info("Test Finished");
    }

    @Test
    public void testFormatWithLessPathsThanSplits() throws Exception {
        DummyMultiFileInputFormat format = new DummyMultiFileInputFormat();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)job);
        this.initFiles((FileSystem)fs, 0, -1);
        Assert.assertEquals((long)0L, (long)format.getSplits(job, 2).length);
        this.initFiles((FileSystem)fs, 2, 500);
        Assert.assertEquals((long)2L, (long)format.getSplits(job, 4).length);
    }

    private class DummyMultiFileInputFormat
    extends MultiFileInputFormat<Text, Text> {
        private DummyMultiFileInputFormat() {
        }

        public RecordReader<Text, Text> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
            return null;
        }
    }
}

