/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.zookeeper.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.shaded.org.apache.zookeeper.data.Id;
import org.apache.hadoop.shaded.org.apache.zookeeper.proto.ReplyHeader;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.ServerCnxn;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.auth.ProviderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationHelper.class);
    public static final String ENFORCE_AUTH_ENABLED = "zookeeper.enforce.auth.enabled";
    public static final String ENFORCE_AUTH_SCHEMES = "zookeeper.enforce.auth.schemes";
    public static final String SESSION_REQUIRE_CLIENT_SASL_AUTH = "zookeeper.sessionRequireClientSASLAuth";
    public static final String SASL_AUTH_SCHEME = "sasl";
    private boolean enforceAuthEnabled;
    private List<String> enforceAuthSchemes = new ArrayList<String>();
    private boolean saslAuthRequired;

    public AuthenticationHelper() {
        this.initConfigurations();
    }

    private void initConfigurations() {
        if (Boolean.parseBoolean(System.getProperty(SESSION_REQUIRE_CLIENT_SASL_AUTH, "false"))) {
            this.enforceAuthEnabled = true;
            this.enforceAuthSchemes.add(SASL_AUTH_SCHEME);
        } else {
            this.enforceAuthEnabled = Boolean.parseBoolean(System.getProperty(ENFORCE_AUTH_ENABLED, "false"));
            String enforceAuthSchemesProp = System.getProperty(ENFORCE_AUTH_SCHEMES);
            if (enforceAuthSchemesProp != null) {
                Arrays.stream(enforceAuthSchemesProp.split(",")).forEach(s -> this.enforceAuthSchemes.add(s.trim()));
            }
        }
        LOG.info("{} = {}", (Object)ENFORCE_AUTH_ENABLED, (Object)this.enforceAuthEnabled);
        LOG.info("{} = {}", (Object)ENFORCE_AUTH_SCHEMES, this.enforceAuthSchemes);
        this.validateConfiguredProperties();
        this.saslAuthRequired = this.enforceAuthEnabled && this.enforceAuthSchemes.contains(SASL_AUTH_SCHEME);
    }

    private void validateConfiguredProperties() {
        if (this.enforceAuthEnabled) {
            if (this.enforceAuthSchemes.isEmpty()) {
                String msg = "zookeeper.enforce.auth.enabled is true zookeeper.enforce.auth.schemes must be  configured.";
                LOG.error(msg);
                throw new IllegalArgumentException(msg);
            }
            this.enforceAuthSchemes.forEach(scheme -> {
                if (ProviderRegistry.getProvider(scheme) == null) {
                    String msg = "Authentication scheme " + scheme + " is not available.";
                    LOG.error(msg);
                    throw new IllegalArgumentException(msg);
                }
            });
        }
    }

    private boolean isCnxnAuthenticated(ServerCnxn cnxn) {
        for (Id id : cnxn.getAuthInfo()) {
            if (!this.enforceAuthSchemes.contains(id.getScheme())) continue;
            return true;
        }
        return false;
    }

    public boolean isEnforceAuthEnabled() {
        return this.enforceAuthEnabled;
    }

    public boolean enforceAuthentication(ServerCnxn connection, int xid) throws IOException {
        if (this.isEnforceAuthEnabled() && !this.isCnxnAuthenticated(connection)) {
            LOG.error("Client authentication scheme(s) {} does not match with any of the expected authentication scheme {}, closing session.", this.getAuthSchemes(connection), this.enforceAuthSchemes);
            ReplyHeader replyHeader = new ReplyHeader(xid, 0L, KeeperException.Code.SESSIONCLOSEDREQUIRESASLAUTH.intValue());
            connection.sendResponse(replyHeader, null, "response");
            connection.sendCloseSession();
            connection.disableRecv();
            return false;
        }
        return true;
    }

    private List<String> getAuthSchemes(ServerCnxn connection) {
        return connection.getAuthInfo().stream().map(Id::getScheme).collect(Collectors.toList());
    }

    public boolean isSaslAuthRequired() {
        return this.saslAuthRequired;
    }
}

