/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3.response;

import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.Nfs3FileAttributes;
import org.apache.hadoop.nfs.nfs3.response.NFS3Response;
import org.apache.hadoop.nfs.nfs3.response.WccData;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.Verifier;

public class MKDIR3Response
extends NFS3Response {
    private final FileHandle objFileHandle;
    private final Nfs3FileAttributes objAttr;
    private final WccData dirWcc;

    public MKDIR3Response(int status) {
        this(status, null, null, new WccData(null, null));
    }

    public MKDIR3Response(int status, FileHandle handle, Nfs3FileAttributes attr, WccData dirWcc) {
        super(status);
        this.objFileHandle = handle;
        this.objAttr = attr;
        this.dirWcc = dirWcc;
    }

    public FileHandle getObjFileHandle() {
        return this.objFileHandle;
    }

    public Nfs3FileAttributes getObjAttr() {
        return this.objAttr;
    }

    public WccData getDirWcc() {
        return this.dirWcc;
    }

    public static MKDIR3Response deserialize(XDR xdr) {
        int status = xdr.readInt();
        FileHandle objFileHandle = new FileHandle();
        Nfs3FileAttributes objAttr = null;
        if (status == 0) {
            xdr.readBoolean();
            objFileHandle.deserialize(xdr);
            xdr.readBoolean();
            objAttr = Nfs3FileAttributes.deserialize(xdr);
        }
        WccData dirWcc = WccData.deserialize(xdr);
        return new MKDIR3Response(status, objFileHandle, objAttr, dirWcc);
    }

    @Override
    public XDR serialize(XDR out, int xid, Verifier verifier) {
        super.serialize(out, xid, verifier);
        if (this.getStatus() == 0) {
            out.writeBoolean(true);
            this.objFileHandle.serialize(out);
            out.writeBoolean(true);
            this.objAttr.serialize(out);
        }
        this.dirWcc.serialize(out);
        return out;
    }
}

