/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.util.List;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.tools.rumen.LoggedTaskAttempt;
import org.apache.hadoop.tools.rumen.TaskInfo;

public abstract class TaskAttemptInfo {
    protected final TaskStatus.State state;
    protected final TaskInfo taskInfo;
    protected final List<List<Integer>> allSplits;

    protected TaskAttemptInfo(TaskStatus.State state, TaskInfo taskInfo, List<List<Integer>> allSplits) {
        if (state != TaskStatus.State.SUCCEEDED && state != TaskStatus.State.FAILED) {
            throw new IllegalArgumentException("status cannot be " + state);
        }
        this.state = state;
        this.taskInfo = taskInfo;
        this.allSplits = allSplits;
    }

    protected TaskAttemptInfo(TaskStatus.State state, TaskInfo taskInfo) {
        this(state, taskInfo, LoggedTaskAttempt.SplitVectorKind.getNullSplitsVector());
    }

    public TaskStatus.State getRunState() {
        return this.state;
    }

    public abstract long getRuntime();

    public TaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    public List<Integer> getSplitVector(LoggedTaskAttempt.SplitVectorKind kind) {
        return kind.get(this.allSplits);
    }
}

