/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidIngressServiceException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AppendRequestParameters;
import org.apache.hadoop.fs.azurebfs.contracts.services.BlobAppendRequestParameters;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlobClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlock;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientHandler;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStream;
import org.apache.hadoop.fs.azurebfs.services.AbfsPerfInfo;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AzureBlobBlockManager;
import org.apache.hadoop.fs.azurebfs.services.AzureBlockManager;
import org.apache.hadoop.fs.azurebfs.services.AzureIngressHandler;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.store.DataBlocks;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureBlobIngressHandler
extends AzureIngressHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbfsOutputStream.class);
    private volatile String eTag;
    private final AzureBlobBlockManager blobBlockManager;
    private final AbfsBlobClient blobClient;
    private final AbfsClientHandler clientHandler;

    public AzureBlobIngressHandler(AbfsOutputStream abfsOutputStream, DataBlocks.BlockFactory blockFactory, int bufferSize, String eTag, AbfsClientHandler clientHandler, AzureBlockManager blockManager) throws AzureBlobFileSystemException {
        super(abfsOutputStream);
        this.eTag = eTag;
        this.blobBlockManager = blockManager instanceof AzureBlobBlockManager ? (AzureBlobBlockManager)blockManager : new AzureBlobBlockManager(abfsOutputStream, blockFactory, bufferSize);
        this.clientHandler = clientHandler;
        this.blobClient = clientHandler.getBlobClient();
        LOG.trace("Created a new BlobIngress Handler for AbfsOutputStream instance {} for path {}", (Object)abfsOutputStream.getStreamID(), (Object)abfsOutputStream.getPath());
    }

    @Override
    protected int bufferData(AbfsBlock block, byte[] data, int off, int length) throws IOException {
        LOG.trace("Buffering data of length {} to block at offset {}", (Object)length, (Object)off);
        return block.write(data, off, length);
    }

    @Override
    protected AbfsRestOperation remoteWrite(AbfsBlock blockToUpload, DataBlocks.BlockUploadData uploadData, AppendRequestParameters reqParams, TracingContext tracingContext) throws IOException {
        AbfsRestOperation op;
        BlobAppendRequestParameters blobParams = new BlobAppendRequestParameters(blockToUpload.getBlockId(), this.getETag());
        reqParams.setBlobParams(blobParams);
        String threadIdStr = String.valueOf(Thread.currentThread().getId());
        TracingContext tracingContextAppend = new TracingContext(tracingContext);
        tracingContextAppend.setIngressHandler("B T " + threadIdStr);
        tracingContextAppend.setPosition(String.valueOf(blockToUpload.getOffset()));
        try {
            LOG.trace("Starting remote write for block with ID {} and offset {}", (Object)blockToUpload.getBlockId(), (Object)blockToUpload.getOffset());
            op = this.getClient().append(this.getAbfsOutputStream().getPath(), uploadData.toByteArray(), reqParams, this.getAbfsOutputStream().getCachedSasTokenString(), this.getAbfsOutputStream().getContextEncryptionAdapter(), tracingContextAppend);
            this.blobBlockManager.updateEntry(blockToUpload);
        }
        catch (AbfsRestOperationException ex) {
            LOG.error("Error in remote write requiring handler switch for path {}", (Object)this.getAbfsOutputStream().getPath(), (Object)ex);
            if (this.shouldIngressHandlerBeSwitched(ex)) {
                throw this.getIngressHandlerSwitchException(ex);
            }
            LOG.error("Error in remote write for path {} and offset {}", new Object[]{this.getAbfsOutputStream().getPath(), blockToUpload.getOffset(), ex});
            throw ex;
        }
        return op;
    }

    @Override
    protected synchronized AbfsRestOperation remoteFlush(long offset, boolean retainUncommitedData, boolean isClose, String leaseId, TracingContext tracingContext) throws IOException {
        AbfsRestOperation op;
        AzureBlobBlockManager blobBlockManager = (AzureBlobBlockManager)this.getBlockManager();
        if (this.getAbfsOutputStream().isAppendBlob()) {
            return null;
        }
        if (!blobBlockManager.hasBlocksToCommit()) {
            return null;
        }
        try {
            String blockListXml = AbfsBlobClient.generateBlockListXml(blobBlockManager.getBlockIdToCommit());
            TracingContext tracingContextFlush = new TracingContext(tracingContext);
            tracingContextFlush.setIngressHandler("B");
            tracingContextFlush.setPosition(String.valueOf(offset));
            LOG.trace("Flushing data at offset {} for path {}", (Object)offset, (Object)this.getAbfsOutputStream().getPath());
            String fullBlobMd5 = null;
            if (this.getClient().isFullBlobChecksumValidationEnabled()) {
                fullBlobMd5 = this.computeFullBlobMd5();
            }
            op = this.getClient().flush(blockListXml.getBytes(StandardCharsets.UTF_8), this.getAbfsOutputStream().getPath(), isClose, this.getAbfsOutputStream().getCachedSasTokenString(), leaseId, this.getETag(), this.getAbfsOutputStream().getContextEncryptionAdapter(), tracingContextFlush, fullBlobMd5);
            this.setETag(op.getResult().getResponseHeader("ETag"));
        }
        catch (AbfsRestOperationException ex) {
            LOG.error("Error in remote flush requiring handler switch for path {}", (Object)this.getAbfsOutputStream().getPath(), (Object)ex);
            if (this.shouldIngressHandlerBeSwitched(ex)) {
                throw this.getIngressHandlerSwitchException(ex);
            }
            LOG.error("Error in remote flush for path {} and offset {}", new Object[]{this.getAbfsOutputStream().getPath(), offset, ex});
            throw ex;
        }
        finally {
            if (this.getClient().isFullBlobChecksumValidationEnabled()) {
                this.getAbfsOutputStream().getFullBlobContentMd5().reset();
            }
        }
        return op;
    }

    @Override
    protected AbfsRestOperation remoteAppendBlobWrite(String path, DataBlocks.BlockUploadData uploadData, AbfsBlock block, AppendRequestParameters reqParams, TracingContext tracingContext) throws IOException {
        AbfsRestOperation op;
        try {
            op = this.blobClient.appendBlock(path, reqParams, uploadData.toByteArray(), tracingContext);
        }
        catch (AbfsRestOperationException ex) {
            LOG.error("Error in remote write requiring handler switch for path {}", (Object)this.getAbfsOutputStream().getPath(), (Object)ex);
            if (this.shouldIngressHandlerBeSwitched(ex)) {
                throw this.getIngressHandlerSwitchException(ex);
            }
            LOG.error("Error in remote write for path {} and offset {}", new Object[]{this.getAbfsOutputStream().getPath(), block.getOffset(), ex});
            throw ex;
        }
        return op;
    }

    void setETag(String eTag) {
        this.eTag = eTag;
    }

    @Override
    @VisibleForTesting
    public String getETag() {
        return this.eTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeAppendBlobCurrentBufferToService() throws IOException {
        AbfsBlock activeBlock = this.blobBlockManager.getActiveBlock();
        if (!this.getAbfsOutputStream().hasActiveBlockDataToUpload()) {
            return;
        }
        int bytesLength = activeBlock.dataSize();
        DataBlocks.BlockUploadData uploadData = activeBlock.startUpload();
        if (this.blobBlockManager.hasActiveBlock()) {
            this.blobBlockManager.clearActiveBlock();
        }
        this.getAbfsOutputStream().getOutputStreamStatistics().writeCurrentBuffer();
        this.getAbfsOutputStream().getOutputStreamStatistics().bytesToUpload(bytesLength);
        long offset = this.getAbfsOutputStream().getPosition();
        this.getAbfsOutputStream().setPosition(offset + (long)bytesLength);
        try (AbfsPerfInfo perfInfo = new AbfsPerfInfo(this.blobClient.getAbfsPerfTracker(), "writeCurrentBufferToService", "append");){
            AbfsRestOperation op;
            LOG.trace("Writing current buffer to service at offset {} and path {}", (Object)offset, (Object)this.getAbfsOutputStream().getPath());
            AppendRequestParameters reqParams = new AppendRequestParameters(offset, 0, bytesLength, AppendRequestParameters.Mode.APPEND_MODE, true, this.getAbfsOutputStream().getLeaseId(), this.getAbfsOutputStream().isExpectHeaderEnabled(), this.getAbfsOutputStream().getMd5());
            try {
                op = this.remoteAppendBlobWrite(this.getAbfsOutputStream().getPath(), uploadData, activeBlock, reqParams, new TracingContext(this.getAbfsOutputStream().getTracingContext()));
            }
            catch (InvalidIngressServiceException ex) {
                try {
                    LOG.debug("InvalidIngressServiceException caught for path: {}, switching handler and retrying remoteAppendBlobWrite.", (Object)this.getAbfsOutputStream().getPath());
                    this.getAbfsOutputStream().switchHandler();
                    op = this.getAbfsOutputStream().getIngressHandler().remoteAppendBlobWrite(this.getAbfsOutputStream().getPath(), uploadData, activeBlock, reqParams, new TracingContext(this.getAbfsOutputStream().getTracingContext()));
                }
                catch (Throwable throwable) {
                    IOUtils.closeStreams((Closeable[])new Closeable[]{uploadData, activeBlock});
                    throw throwable;
                }
                IOUtils.closeStreams((Closeable[])new Closeable[]{uploadData, activeBlock});
            }
            IOUtils.closeStreams((Closeable[])new Closeable[]{uploadData, activeBlock});
            if (op != null) {
                this.getAbfsOutputStream().getCachedSasToken().update(op.getSasToken());
                this.getAbfsOutputStream().getOutputStreamStatistics().uploadSuccessful(bytesLength);
                perfInfo.registerResult(op.getResult());
                perfInfo.registerSuccess(true);
            }
        }
    }

    @Override
    public AzureBlockManager getBlockManager() {
        return this.blobBlockManager;
    }

    @Override
    public AbfsBlobClient getClient() {
        return this.blobClient;
    }

    @VisibleForTesting
    public AbfsClientHandler getClientHandler() {
        return this.clientHandler;
    }
}

